/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnVlanXlatePortGroupIdMasked;
import org.projectfloodlight.openflow.protocol.ver14.OFOxmBsnVlanXlatePortGroupIdVer14;
import org.projectfloodlight.openflow.types.ClassId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmBsnVlanXlatePortGroupIdMaskedVer14
implements OFOxmBsnVlanXlatePortGroupIdMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmBsnVlanXlatePortGroupIdMaskedVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 12;
    private static final ClassId DEFAULT_VALUE = ClassId.NONE;
    private static final ClassId DEFAULT_VALUE_MASK = ClassId.NONE;
    private final ClassId value;
    private final ClassId mask;
    static final OFOxmBsnVlanXlatePortGroupIdMaskedVer14 DEFAULT = new OFOxmBsnVlanXlatePortGroupIdMaskedVer14(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmBsnVlanXlatePortGroupIdMaskedVer14Funnel FUNNEL = new OFOxmBsnVlanXlatePortGroupIdMaskedVer14Funnel();
    static final Writer WRITER = new Writer();

    OFOxmBsnVlanXlatePortGroupIdMaskedVer14(ClassId value, ClassId mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmBsnVlanXlatePortGroupIdMaskedVer14: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmBsnVlanXlatePortGroupIdMaskedVer14: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 205576L;
    }

    @Override
    public ClassId getValue() {
        return this.value;
    }

    @Override
    public ClassId getMask() {
        return this.mask;
    }

    @Override
    public MatchField<ClassId> getMatchField() {
        return MatchField.BSN_VLAN_XLATE_PORT_GROUP_ID;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<ClassId> getCanonical() {
        if (ClassId.NO_MASK.equals(this.mask)) {
            return new OFOxmBsnVlanXlatePortGroupIdVer14(this.value);
        }
        if (ClassId.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFOxmBsnVlanXlatePortGroupIdMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmBsnVlanXlatePortGroupIdMaskedVer14(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmBsnVlanXlatePortGroupIdMaskedVer14 other = (OFOxmBsnVlanXlatePortGroupIdMaskedVer14)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmBsnVlanXlatePortGroupIdMaskedVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmBsnVlanXlatePortGroupIdMaskedVer14 message) {
            bb.writeInt(205576);
            message.value.write4Bytes(bb);
            message.mask.write4Bytes(bb);
        }
    }

    static class OFOxmBsnVlanXlatePortGroupIdMaskedVer14Funnel
    implements Funnel<OFOxmBsnVlanXlatePortGroupIdMaskedVer14> {
        private static final long serialVersionUID = 1L;

        OFOxmBsnVlanXlatePortGroupIdMaskedVer14Funnel() {
        }

        public void funnel(OFOxmBsnVlanXlatePortGroupIdMaskedVer14 message, PrimitiveSink sink) {
            sink.putInt(205576);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmBsnVlanXlatePortGroupIdMasked> {
        Reader() {
        }

        @Override
        public OFOxmBsnVlanXlatePortGroupIdMasked readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 205576) {
                throw new OFParseError("Wrong typeLen: Expected=0x32308L(0x32308L), got=" + typeLen);
            }
            ClassId value = ClassId.read4Bytes(bb);
            ClassId mask = ClassId.read4Bytes(bb);
            OFOxmBsnVlanXlatePortGroupIdMaskedVer14 oxmBsnVlanXlatePortGroupIdMaskedVer14 = new OFOxmBsnVlanXlatePortGroupIdMaskedVer14(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmBsnVlanXlatePortGroupIdMaskedVer14);
            }
            return oxmBsnVlanXlatePortGroupIdMaskedVer14;
        }
    }

    static class Builder
    implements OFOxmBsnVlanXlatePortGroupIdMasked.Builder {
        private boolean valueSet;
        private ClassId value;
        private boolean maskSet;
        private ClassId mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 205576L;
        }

        @Override
        public ClassId getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnVlanXlatePortGroupIdMasked.Builder setValue(ClassId value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public ClassId getMask() {
            return this.mask;
        }

        @Override
        public OFOxmBsnVlanXlatePortGroupIdMasked.Builder setMask(ClassId mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<ClassId> getMatchField() {
            return MatchField.BSN_VLAN_XLATE_PORT_GROUP_ID;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<ClassId> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmBsnVlanXlatePortGroupIdMasked build() {
            ClassId mask;
            ClassId value;
            ClassId classId = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            ClassId classId2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmBsnVlanXlatePortGroupIdMaskedVer14(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmBsnVlanXlatePortGroupIdMasked.Builder {
        final OFOxmBsnVlanXlatePortGroupIdMaskedVer14 parentMessage;
        private boolean valueSet;
        private ClassId value;
        private boolean maskSet;
        private ClassId mask;

        BuilderWithParent(OFOxmBsnVlanXlatePortGroupIdMaskedVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 205576L;
        }

        @Override
        public ClassId getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnVlanXlatePortGroupIdMasked.Builder setValue(ClassId value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public ClassId getMask() {
            return this.mask;
        }

        @Override
        public OFOxmBsnVlanXlatePortGroupIdMasked.Builder setMask(ClassId mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<ClassId> getMatchField() {
            return MatchField.BSN_VLAN_XLATE_PORT_GROUP_ID;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<ClassId> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmBsnVlanXlatePortGroupIdMasked build() {
            ClassId mask;
            ClassId value;
            ClassId classId = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            ClassId classId2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmBsnVlanXlatePortGroupIdMaskedVer14(value, mask);
        }
    }
}

