/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFMeterFlags;
import org.projectfloodlight.openflow.protocol.OFMeterMod;
import org.projectfloodlight.openflow.protocol.OFMeterModCommand;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.meterband.OFMeterBand;
import org.projectfloodlight.openflow.protocol.ver14.OFMeterBandVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFMeterFlagsSerializerVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFMeterModCommandSerializerVer14;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFMeterModVer14
implements OFMeterMod {
    private static final Logger logger = LoggerFactory.getLogger(OFMeterModVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 16;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFMeterFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final long DEFAULT_METER_ID = 0L;
    private static final List<OFMeterBand> DEFAULT_BANDS = ImmutableList.of();
    private final long xid;
    private final OFMeterModCommand command;
    private final Set<OFMeterFlags> flags;
    private final long meterId;
    private final List<OFMeterBand> bands;
    static final Reader READER = new Reader();
    static final OFMeterModVer14Funnel FUNNEL = new OFMeterModVer14Funnel();
    static final Writer WRITER = new Writer();

    OFMeterModVer14(long xid, OFMeterModCommand command, Set<OFMeterFlags> flags, long meterId, List<OFMeterBand> bands) {
        if (command == null) {
            throw new NullPointerException("OFMeterModVer14: property command cannot be null");
        }
        if (flags == null) {
            throw new NullPointerException("OFMeterModVer14: property flags cannot be null");
        }
        if (bands == null) {
            throw new NullPointerException("OFMeterModVer14: property bands cannot be null");
        }
        this.xid = xid;
        this.command = command;
        this.flags = flags;
        this.meterId = meterId;
        this.bands = bands;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFType getType() {
        return OFType.METER_MOD;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFMeterModCommand getCommand() {
        return this.command;
    }

    @Override
    public Set<OFMeterFlags> getFlags() {
        return this.flags;
    }

    @Override
    public long getMeterId() {
        return this.meterId;
    }

    @Override
    public List<OFMeterBand> getMeters() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property meters not supported in version 1.4");
    }

    @Override
    public List<OFMeterBand> getBands() {
        return this.bands;
    }

    @Override
    public OFMeterMod.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFMeterModVer14(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("command=").append((Object)this.command);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("meterId=").append(this.meterId);
        b.append(", ");
        b.append("bands=").append(this.bands);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFMeterModVer14 other = (OFMeterModVer14)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.command == null ? other.command != null : !this.command.equals((Object)other.command)) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        if (this.meterId != other.meterId) {
            return false;
        }
        return !(this.bands == null ? other.bands != null : !this.bands.equals(other.bands));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFMeterModVer14 other = (OFMeterModVer14)obj;
        if (this.command == null ? other.command != null : !this.command.equals((Object)other.command)) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        if (this.meterId != other.meterId) {
            return false;
        }
        return !(this.bands == null ? other.bands != null : !this.bands.equals(other.bands));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.command == null ? 0 : this.command.hashCode());
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * (int)(this.meterId ^ this.meterId >>> 32);
        result = 31 * result + (this.bands == null ? 0 : this.bands.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.command == null ? 0 : this.command.hashCode());
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * (int)(this.meterId ^ this.meterId >>> 32);
        result = 31 * result + (this.bands == null ? 0 : this.bands.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFMeterModVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFMeterModVer14 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(5);
            bb.writeByte(29);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            OFMeterModCommandSerializerVer14.writeTo(bb, message.command);
            OFMeterFlagsSerializerVer14.writeTo(bb, message.flags);
            bb.writeInt(U32.t(message.meterId));
            ChannelUtils.writeList(bb, message.bands);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFMeterModVer14Funnel
    implements Funnel<OFMeterModVer14> {
        private static final long serialVersionUID = 1L;

        OFMeterModVer14Funnel() {
        }

        public void funnel(OFMeterModVer14 message, PrimitiveSink sink) {
            sink.putByte((byte)5);
            sink.putByte((byte)29);
            sink.putLong(message.xid);
            OFMeterModCommandSerializerVer14.putTo(message.command, sink);
            OFMeterFlagsSerializerVer14.putTo(message.flags, sink);
            sink.putLong(message.meterId);
            FunnelUtils.putList(message.bands, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFMeterMod> {
        Reader() {
        }

        @Override
        public OFMeterMod readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 5) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_14(5), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 29) {
                throw new OFParseError("Wrong type: Expected=OFType.METER_MOD(29), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            OFMeterModCommand command = OFMeterModCommandSerializerVer14.readFrom(bb);
            Set<OFMeterFlags> flags = OFMeterFlagsSerializerVer14.readFrom(bb);
            long meterId = U32.f(bb.readInt());
            List<OFMeterBand> bands = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFMeterBandVer14.READER);
            OFMeterModVer14 meterModVer14 = new OFMeterModVer14(xid, command, flags, meterId, bands);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)meterModVer14);
            }
            return meterModVer14;
        }
    }

    static class Builder
    implements OFMeterMod.Builder {
        private boolean xidSet;
        private long xid;
        private boolean commandSet;
        private OFMeterModCommand command;
        private boolean flagsSet;
        private Set<OFMeterFlags> flags;
        private boolean meterIdSet;
        private long meterId;
        private boolean bandsSet;
        private List<OFMeterBand> bands;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.METER_MOD;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFMeterMod.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFMeterModCommand getCommand() {
            return this.command;
        }

        @Override
        public OFMeterMod.Builder setCommand(OFMeterModCommand command) {
            this.command = command;
            this.commandSet = true;
            return this;
        }

        @Override
        public Set<OFMeterFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFMeterMod.Builder setFlags(Set<OFMeterFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getMeterId() {
            return this.meterId;
        }

        @Override
        public OFMeterMod.Builder setMeterId(long meterId) {
            this.meterId = meterId;
            this.meterIdSet = true;
            return this;
        }

        @Override
        public List<OFMeterBand> getMeters() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property meters not supported in version 1.4");
        }

        @Override
        public OFMeterMod.Builder setMeters(List<OFMeterBand> meters) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property meters not supported in version 1.4");
        }

        @Override
        public List<OFMeterBand> getBands() {
            return this.bands;
        }

        @Override
        public OFMeterMod.Builder setBands(List<OFMeterBand> bands) {
            this.bands = bands;
            this.bandsSet = true;
            return this;
        }

        @Override
        public OFMeterMod build() {
            List<OFMeterBand> bands;
            Set<OFMeterFlags> flags;
            long xid;
            long l = xid = this.xidSet ? this.xid : 0L;
            if (!this.commandSet) {
                throw new IllegalStateException("Property command doesn't have default value -- must be set");
            }
            if (this.command == null) {
                throw new NullPointerException("Property command must not be null");
            }
            Set<OFMeterFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            long meterId = this.meterIdSet ? this.meterId : 0L;
            List<OFMeterBand> list = bands = this.bandsSet ? this.bands : DEFAULT_BANDS;
            if (bands == null) {
                throw new NullPointerException("Property bands must not be null");
            }
            return new OFMeterModVer14(xid, this.command, flags, meterId, bands);
        }
    }

    static class BuilderWithParent
    implements OFMeterMod.Builder {
        final OFMeterModVer14 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean commandSet;
        private OFMeterModCommand command;
        private boolean flagsSet;
        private Set<OFMeterFlags> flags;
        private boolean meterIdSet;
        private long meterId;
        private boolean bandsSet;
        private List<OFMeterBand> bands;

        BuilderWithParent(OFMeterModVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.METER_MOD;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFMeterMod.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFMeterModCommand getCommand() {
            return this.command;
        }

        @Override
        public OFMeterMod.Builder setCommand(OFMeterModCommand command) {
            this.command = command;
            this.commandSet = true;
            return this;
        }

        @Override
        public Set<OFMeterFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFMeterMod.Builder setFlags(Set<OFMeterFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getMeterId() {
            return this.meterId;
        }

        @Override
        public OFMeterMod.Builder setMeterId(long meterId) {
            this.meterId = meterId;
            this.meterIdSet = true;
            return this;
        }

        @Override
        public List<OFMeterBand> getMeters() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property meters not supported in version 1.4");
        }

        @Override
        public OFMeterMod.Builder setMeters(List<OFMeterBand> meters) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property meters not supported in version 1.4");
        }

        @Override
        public List<OFMeterBand> getBands() {
            return this.bands;
        }

        @Override
        public OFMeterMod.Builder setBands(List<OFMeterBand> bands) {
            this.bands = bands;
            this.bandsSet = true;
            return this;
        }

        @Override
        public OFMeterMod build() {
            List bands;
            Set flags;
            OFMeterModCommand command;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            OFMeterModCommand oFMeterModCommand = command = this.commandSet ? this.command : this.parentMessage.command;
            if (command == null) {
                throw new NullPointerException("Property command must not be null");
            }
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            long meterId = this.meterIdSet ? this.meterId : this.parentMessage.meterId;
            List list = bands = this.bandsSet ? this.bands : this.parentMessage.bands;
            if (bands == null) {
                throw new NullPointerException("Property bands must not be null");
            }
            return new OFMeterModVer14(xid, command, flags, meterId, bands);
        }
    }
}

