/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBundleAddMsg;
import org.projectfloodlight.openflow.protocol.OFBundleFlags;
import org.projectfloodlight.openflow.protocol.OFBundleProp;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver14.OFBundleFlagsSerializerVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFMessageVer14;
import org.projectfloodlight.openflow.types.BundleId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBundleAddMsgVer14
implements OFBundleAddMsg {
    private static final Logger logger = LoggerFactory.getLogger(OFBundleAddMsgVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 16;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFBundleFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private final long xid;
    private final BundleId bundleId;
    private final Set<OFBundleFlags> flags;
    private final OFMessage data;
    static final Reader READER = new Reader();
    static final OFBundleAddMsgVer14Funnel FUNNEL = new OFBundleAddMsgVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBundleAddMsgVer14(long xid, BundleId bundleId, Set<OFBundleFlags> flags, OFMessage data) {
        if (bundleId == null) {
            throw new NullPointerException("OFBundleAddMsgVer14: property bundleId cannot be null");
        }
        if (flags == null) {
            throw new NullPointerException("OFBundleAddMsgVer14: property flags cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("OFBundleAddMsgVer14: property data cannot be null");
        }
        this.xid = xid;
        this.bundleId = bundleId;
        this.flags = flags;
        this.data = data;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFType getType() {
        return OFType.BUNDLE_ADD_MESSAGE;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public BundleId getBundleId() {
        return this.bundleId;
    }

    @Override
    public Set<OFBundleFlags> getFlags() {
        return this.flags;
    }

    @Override
    public OFMessage getMessage() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property message not supported in version 1.4");
    }

    @Override
    public List<OFBundleProp> getProperties() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property properties not supported in version 1.4");
    }

    @Override
    public OFMessage getData() {
        return this.data;
    }

    @Override
    public OFBundleAddMsg.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBundleAddMsgVer14(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("bundleId=").append(this.bundleId);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("data=").append(this.data);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBundleAddMsgVer14 other = (OFBundleAddMsgVer14)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.bundleId == null ? other.bundleId != null : !this.bundleId.equals(other.bundleId)) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return !(this.data == null ? other.data != null : !this.data.equals(other.data));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBundleAddMsgVer14 other = (OFBundleAddMsgVer14)obj;
        if (this.bundleId == null ? other.bundleId != null : !this.bundleId.equals(other.bundleId)) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return !(this.data == null ? other.data != null : !this.data.equals(other.data));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.bundleId == null ? 0 : this.bundleId.hashCode());
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bundleId == null ? 0 : this.bundleId.hashCode());
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBundleAddMsgVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBundleAddMsgVer14 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(5);
            bb.writeByte(34);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            message.bundleId.write4Bytes(bb);
            bb.writeZero(2);
            OFBundleFlagsSerializerVer14.writeTo(bb, message.flags);
            message.data.writeTo(bb);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBundleAddMsgVer14Funnel
    implements Funnel<OFBundleAddMsgVer14> {
        private static final long serialVersionUID = 1L;

        OFBundleAddMsgVer14Funnel() {
        }

        public void funnel(OFBundleAddMsgVer14 message, PrimitiveSink sink) {
            sink.putByte((byte)5);
            sink.putByte((byte)34);
            sink.putLong(message.xid);
            message.bundleId.putTo(sink);
            OFBundleFlagsSerializerVer14.putTo(message.flags, sink);
            message.data.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBundleAddMsg> {
        Reader() {
        }

        @Override
        public OFBundleAddMsg readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 5) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_14(5), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 34) {
                throw new OFParseError("Wrong type: Expected=OFType.BUNDLE_ADD_MESSAGE(34), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            BundleId bundleId = BundleId.read4Bytes(bb);
            bb.skipBytes(2);
            Set<OFBundleFlags> flags = OFBundleFlagsSerializerVer14.readFrom(bb);
            OFMessage data = OFMessageVer14.READER.readFrom(bb);
            OFBundleAddMsgVer14 bundleAddMsgVer14 = new OFBundleAddMsgVer14(xid, bundleId, flags, data);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bundleAddMsgVer14);
            }
            return bundleAddMsgVer14;
        }
    }

    static class Builder
    implements OFBundleAddMsg.Builder {
        private boolean xidSet;
        private long xid;
        private boolean bundleIdSet;
        private BundleId bundleId;
        private boolean flagsSet;
        private Set<OFBundleFlags> flags;
        private boolean dataSet;
        private OFMessage data;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.BUNDLE_ADD_MESSAGE;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBundleAddMsg.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public BundleId getBundleId() {
            return this.bundleId;
        }

        @Override
        public OFBundleAddMsg.Builder setBundleId(BundleId bundleId) {
            this.bundleId = bundleId;
            this.bundleIdSet = true;
            return this;
        }

        @Override
        public Set<OFBundleFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBundleAddMsg.Builder setFlags(Set<OFBundleFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public OFMessage getMessage() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property message not supported in version 1.4");
        }

        @Override
        public OFBundleAddMsg.Builder setMessage(OFMessage message) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property message not supported in version 1.4");
        }

        @Override
        public List<OFBundleProp> getProperties() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property properties not supported in version 1.4");
        }

        @Override
        public OFBundleAddMsg.Builder setProperties(List<OFBundleProp> properties) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property properties not supported in version 1.4");
        }

        @Override
        public OFMessage getData() {
            return this.data;
        }

        @Override
        public OFBundleAddMsg.Builder setData(OFMessage data) {
            this.data = data;
            this.dataSet = true;
            return this.setXid(data.getXid());
        }

        @Override
        public OFBundleAddMsg build() {
            Set<OFBundleFlags> flags;
            long xid;
            long l = xid = this.xidSet ? this.xid : 0L;
            if (!this.bundleIdSet) {
                throw new IllegalStateException("Property bundleId doesn't have default value -- must be set");
            }
            if (this.bundleId == null) {
                throw new NullPointerException("Property bundleId must not be null");
            }
            Set<OFBundleFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            if (!this.dataSet) {
                throw new IllegalStateException("Property data doesn't have default value -- must be set");
            }
            if (this.data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFBundleAddMsgVer14(xid, this.bundleId, flags, this.data);
        }
    }

    static class BuilderWithParent
    implements OFBundleAddMsg.Builder {
        final OFBundleAddMsgVer14 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean bundleIdSet;
        private BundleId bundleId;
        private boolean flagsSet;
        private Set<OFBundleFlags> flags;
        private boolean dataSet;
        private OFMessage data;

        BuilderWithParent(OFBundleAddMsgVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.BUNDLE_ADD_MESSAGE;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBundleAddMsg.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public BundleId getBundleId() {
            return this.bundleId;
        }

        @Override
        public OFBundleAddMsg.Builder setBundleId(BundleId bundleId) {
            this.bundleId = bundleId;
            this.bundleIdSet = true;
            return this;
        }

        @Override
        public Set<OFBundleFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBundleAddMsg.Builder setFlags(Set<OFBundleFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public OFMessage getMessage() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property message not supported in version 1.4");
        }

        @Override
        public OFBundleAddMsg.Builder setMessage(OFMessage message) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property message not supported in version 1.4");
        }

        @Override
        public List<OFBundleProp> getProperties() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property properties not supported in version 1.4");
        }

        @Override
        public OFBundleAddMsg.Builder setProperties(List<OFBundleProp> properties) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property properties not supported in version 1.4");
        }

        @Override
        public OFMessage getData() {
            return this.data;
        }

        @Override
        public OFBundleAddMsg.Builder setData(OFMessage data) {
            this.data = data;
            this.dataSet = true;
            return this.setXid(data.getXid());
        }

        @Override
        public OFBundleAddMsg build() {
            OFMessage data;
            Set flags;
            BundleId bundleId;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            BundleId bundleId2 = bundleId = this.bundleIdSet ? this.bundleId : this.parentMessage.bundleId;
            if (bundleId == null) {
                throw new NullPointerException("Property bundleId must not be null");
            }
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            OFMessage oFMessage = data = this.dataSet ? this.data : this.parentMessage.data;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFBundleAddMsgVer14(xid, bundleId, flags, data);
        }
    }
}

