/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnUnit;
import org.projectfloodlight.openflow.protocol.OFBsnUnitType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnUnitTypeSerializerVer14;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnUnitVer14
implements OFBsnUnit {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnUnitVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 5;
    private static final long DEFAULT_VALUE = 0L;
    private static final Set<OFBsnUnitType> DEFAULT_UNIT = ImmutableSet.of();
    private final long value;
    private final Set<OFBsnUnitType> unit;
    static final OFBsnUnitVer14 DEFAULT = new OFBsnUnitVer14(0L, DEFAULT_UNIT);
    static final Reader READER = new Reader();
    static final OFBsnUnitVer14Funnel FUNNEL = new OFBsnUnitVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnUnitVer14(long value, Set<OFBsnUnitType> unit) {
        if (unit == null) {
            throw new NullPointerException("OFBsnUnitVer14: property unit cannot be null");
        }
        this.value = value;
        this.unit = unit;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public Set<OFBsnUnitType> getUnit() {
        return this.unit;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnUnit.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnUnitVer14(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("unit=").append(this.unit);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnUnitVer14 other = (OFBsnUnitVer14)obj;
        if (this.value != other.value) {
            return false;
        }
        return !(this.unit == null ? other.unit != null : !this.unit.equals(other.unit));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnUnitVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnUnitVer14 message) {
            bb.writeInt(U32.t(message.value));
            OFBsnUnitTypeSerializerVer14.writeTo(bb, message.unit);
        }
    }

    static class OFBsnUnitVer14Funnel
    implements Funnel<OFBsnUnitVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnUnitVer14Funnel() {
        }

        public void funnel(OFBsnUnitVer14 message, PrimitiveSink sink) {
            sink.putLong(message.value);
            OFBsnUnitTypeSerializerVer14.putTo(message.unit, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnUnit> {
        Reader() {
        }

        @Override
        public OFBsnUnit readFrom(ByteBuf bb) throws OFParseError {
            long value = U32.f(bb.readInt());
            Set<OFBsnUnitType> unit = OFBsnUnitTypeSerializerVer14.readFrom(bb);
            OFBsnUnitVer14 bsnUnitVer14 = new OFBsnUnitVer14(value, unit);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnUnitVer14);
            }
            return bsnUnitVer14;
        }
    }

    static class Builder
    implements OFBsnUnit.Builder {
        private boolean valueSet;
        private long value;
        private boolean unitSet;
        private Set<OFBsnUnitType> unit;

        Builder() {
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnUnit.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public Set<OFBsnUnitType> getUnit() {
            return this.unit;
        }

        @Override
        public OFBsnUnit.Builder setUnit(Set<OFBsnUnitType> unit) {
            this.unit = unit;
            this.unitSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnUnit build() {
            Set<OFBsnUnitType> unit;
            long value = this.valueSet ? this.value : 0L;
            Set<OFBsnUnitType> set = unit = this.unitSet ? this.unit : DEFAULT_UNIT;
            if (unit == null) {
                throw new NullPointerException("Property unit must not be null");
            }
            return new OFBsnUnitVer14(value, unit);
        }
    }

    static class BuilderWithParent
    implements OFBsnUnit.Builder {
        final OFBsnUnitVer14 parentMessage;
        private boolean valueSet;
        private long value;
        private boolean unitSet;
        private Set<OFBsnUnitType> unit;

        BuilderWithParent(OFBsnUnitVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnUnit.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public Set<OFBsnUnitType> getUnit() {
            return this.unit;
        }

        @Override
        public OFBsnUnit.Builder setUnit(Set<OFBsnUnitType> unit) {
            this.unit = unit;
            this.unitSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnUnit build() {
            Set unit;
            long value = this.valueSet ? this.value : this.parentMessage.value;
            Set set = unit = this.unitSet ? this.unit : this.parentMessage.unit;
            if (unit == null) {
                throw new NullPointerException("Property unit must not be null");
            }
            return new OFBsnUnitVer14(value, unit);
        }
    }
}

