/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvL3InterfaceClassId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvL3InterfaceClassIdVer14
implements OFBsnTlvL3InterfaceClassId {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvL3InterfaceClassIdVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvL3InterfaceClassIdVer14 DEFAULT = new OFBsnTlvL3InterfaceClassIdVer14(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvL3InterfaceClassIdVer14Funnel FUNNEL = new OFBsnTlvL3InterfaceClassIdVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvL3InterfaceClassIdVer14(long value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 134;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvL3InterfaceClassId.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvL3InterfaceClassIdVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvL3InterfaceClassIdVer14 other = (OFBsnTlvL3InterfaceClassIdVer14)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvL3InterfaceClassIdVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvL3InterfaceClassIdVer14 message) {
            bb.writeShort(134);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvL3InterfaceClassIdVer14Funnel
    implements Funnel<OFBsnTlvL3InterfaceClassIdVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvL3InterfaceClassIdVer14Funnel() {
        }

        public void funnel(OFBsnTlvL3InterfaceClassIdVer14 message, PrimitiveSink sink) {
            sink.putShort((short)134);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvL3InterfaceClassId> {
        Reader() {
        }

        @Override
        public OFBsnTlvL3InterfaceClassId readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 134) {
                throw new OFParseError("Wrong type: Expected=0x86(0x86), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvL3InterfaceClassIdVer14 bsnTlvL3InterfaceClassIdVer14 = new OFBsnTlvL3InterfaceClassIdVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvL3InterfaceClassIdVer14);
            }
            return bsnTlvL3InterfaceClassIdVer14;
        }
    }

    static class Builder
    implements OFBsnTlvL3InterfaceClassId.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 134;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvL3InterfaceClassId.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvL3InterfaceClassId build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvL3InterfaceClassIdVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvL3InterfaceClassId.Builder {
        final OFBsnTlvL3InterfaceClassIdVer14 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvL3InterfaceClassIdVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 134;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvL3InterfaceClassId.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvL3InterfaceClassId build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvL3InterfaceClassIdVer14(value);
        }
    }
}

