/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnHashType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvHashType;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnHashTypeSerializerVer14;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvHashTypeVer14
implements OFBsnTlvHashType {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvHashTypeVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 5;
    private final OFBsnHashType value;
    static final Reader READER = new Reader();
    static final OFBsnTlvHashTypeVer14Funnel FUNNEL = new OFBsnTlvHashTypeVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvHashTypeVer14(OFBsnHashType value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvHashTypeVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 101;
    }

    @Override
    public OFBsnHashType getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvHashType.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvHashTypeVer14(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvHashTypeVer14 other = (OFBsnTlvHashTypeVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvHashTypeVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvHashTypeVer14 message) {
            bb.writeShort(101);
            bb.writeShort(5);
            OFBsnHashTypeSerializerVer14.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvHashTypeVer14Funnel
    implements Funnel<OFBsnTlvHashTypeVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvHashTypeVer14Funnel() {
        }

        public void funnel(OFBsnTlvHashTypeVer14 message, PrimitiveSink sink) {
            sink.putShort((short)101);
            sink.putShort((short)5);
            OFBsnHashTypeSerializerVer14.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvHashType> {
        Reader() {
        }

        @Override
        public OFBsnTlvHashType readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 101) {
                throw new OFParseError("Wrong type: Expected=0x65(0x65), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 5) {
                throw new OFParseError("Wrong length: Expected=5(5), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnHashType value = OFBsnHashTypeSerializerVer14.readFrom(bb);
            OFBsnTlvHashTypeVer14 bsnTlvHashTypeVer14 = new OFBsnTlvHashTypeVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvHashTypeVer14);
            }
            return bsnTlvHashTypeVer14;
        }
    }

    static class Builder
    implements OFBsnTlvHashType.Builder {
        private boolean valueSet;
        private OFBsnHashType value;

        Builder() {
        }

        @Override
        public int getType() {
            return 101;
        }

        @Override
        public OFBsnHashType getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvHashType.Builder setValue(OFBsnHashType value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvHashType build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvHashTypeVer14(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvHashType.Builder {
        final OFBsnTlvHashTypeVer14 parentMessage;
        private boolean valueSet;
        private OFBsnHashType value;

        BuilderWithParent(OFBsnTlvHashTypeVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 101;
        }

        @Override
        public OFBsnHashType getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvHashType.Builder setValue(OFBsnHashType value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvHashType build() {
            OFBsnHashType value;
            OFBsnHashType oFBsnHashType = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvHashTypeVer14(value);
        }
    }
}

