/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnEnhancedHashType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvEnhancedHashCapability;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnEnhancedHashTypeSerializerVer14;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvEnhancedHashCapabilityVer14
implements OFBsnTlvEnhancedHashCapability {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvEnhancedHashCapabilityVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 12;
    private static final Set<OFBsnEnhancedHashType> DEFAULT_VALUE = ImmutableSet.of();
    private final Set<OFBsnEnhancedHashType> value;
    static final OFBsnTlvEnhancedHashCapabilityVer14 DEFAULT = new OFBsnTlvEnhancedHashCapabilityVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvEnhancedHashCapabilityVer14Funnel FUNNEL = new OFBsnTlvEnhancedHashCapabilityVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvEnhancedHashCapabilityVer14(Set<OFBsnEnhancedHashType> value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvEnhancedHashCapabilityVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 143;
    }

    @Override
    public Set<OFBsnEnhancedHashType> getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvEnhancedHashCapability.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvEnhancedHashCapabilityVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvEnhancedHashCapabilityVer14 other = (OFBsnTlvEnhancedHashCapabilityVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvEnhancedHashCapabilityVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvEnhancedHashCapabilityVer14 message) {
            bb.writeShort(143);
            bb.writeShort(12);
            OFBsnEnhancedHashTypeSerializerVer14.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvEnhancedHashCapabilityVer14Funnel
    implements Funnel<OFBsnTlvEnhancedHashCapabilityVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvEnhancedHashCapabilityVer14Funnel() {
        }

        public void funnel(OFBsnTlvEnhancedHashCapabilityVer14 message, PrimitiveSink sink) {
            sink.putShort((short)143);
            sink.putShort((short)12);
            OFBsnEnhancedHashTypeSerializerVer14.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvEnhancedHashCapability> {
        Reader() {
        }

        @Override
        public OFBsnTlvEnhancedHashCapability readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 143) {
                throw new OFParseError("Wrong type: Expected=0x8f(0x8f), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 12) {
                throw new OFParseError("Wrong length: Expected=12(12), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            Set<OFBsnEnhancedHashType> value = OFBsnEnhancedHashTypeSerializerVer14.readFrom(bb);
            OFBsnTlvEnhancedHashCapabilityVer14 bsnTlvEnhancedHashCapabilityVer14 = new OFBsnTlvEnhancedHashCapabilityVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvEnhancedHashCapabilityVer14);
            }
            return bsnTlvEnhancedHashCapabilityVer14;
        }
    }

    static class Builder
    implements OFBsnTlvEnhancedHashCapability.Builder {
        private boolean valueSet;
        private Set<OFBsnEnhancedHashType> value;

        Builder() {
        }

        @Override
        public int getType() {
            return 143;
        }

        @Override
        public Set<OFBsnEnhancedHashType> getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvEnhancedHashCapability.Builder setValue(Set<OFBsnEnhancedHashType> value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvEnhancedHashCapability build() {
            Set<OFBsnEnhancedHashType> value;
            Set<OFBsnEnhancedHashType> set = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvEnhancedHashCapabilityVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvEnhancedHashCapability.Builder {
        final OFBsnTlvEnhancedHashCapabilityVer14 parentMessage;
        private boolean valueSet;
        private Set<OFBsnEnhancedHashType> value;

        BuilderWithParent(OFBsnTlvEnhancedHashCapabilityVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 143;
        }

        @Override
        public Set<OFBsnEnhancedHashType> getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvEnhancedHashCapability.Builder setValue(Set<OFBsnEnhancedHashType> value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvEnhancedHashCapability build() {
            Set value;
            Set set = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvEnhancedHashCapabilityVer14(value);
        }
    }
}

