/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnPktinFlag;

public class OFBsnPktinFlagSerializerVer14 {
    public static final long BSN_PKTIN_FLAG_PDU_VAL = 1L;
    public static final long BSN_PKTIN_FLAG_NEW_HOST_VAL = 2L;
    public static final long BSN_PKTIN_FLAG_STATION_MOVE_VAL = 4L;
    public static final long BSN_PKTIN_FLAG_ARP_VAL = 8L;
    public static final long BSN_PKTIN_FLAG_DHCP_VAL = 16L;
    public static final long BSN_PKTIN_FLAG_L2_CPU_VAL = 32L;
    public static final long BSN_PKTIN_FLAG_DEBUG_VAL = 64L;
    public static final long BSN_PKTIN_FLAG_TTL_EXPIRED_VAL = 128L;
    public static final long BSN_PKTIN_FLAG_L3_MISS_VAL = 256L;
    public static final long BSN_PKTIN_FLAG_L3_CPU_VAL = 512L;
    public static final long BSN_PKTIN_FLAG_INGRESS_ACL_VAL = 1024L;
    public static final long BSN_PKTIN_FLAG_SFLOW_VAL = 2048L;
    public static final long BSN_PKTIN_FLAG_ARP_CACHE_VAL = 4096L;
    public static final long BSN_PKTIN_FLAG_ARP_TARGET_VAL = 8192L;
    public static final long BSN_PKTIN_FLAG_IGMP_VAL = 16384L;
    public static final long BSN_PKTIN_FLAG_PIM_VAL = 32768L;
    public static final long BSN_PKTIN_FLAG_VXLAN_SIP_MISS_VAL = 65536L;
    public static final long BSN_PKTIN_FLAG_MC_RESERVED_VAL = 131072L;
    public static final long BSN_PKTIN_FLAG_ANALYTICS_VAL = 262144L;
    public static final long BSN_PKTIN_FLAG_ICMPV6_VAL = 524288L;
    public static final long BSN_PKTIN_FLAG_INGRESS_ACL_LOCAL_VAL = 0x100000L;
    public static final long BSN_PKTIN_FLAG_IPMC_MISS_VAL = 0x200000L;
    public static final long BSN_PKTIN_FLAG_IPMC_RPF_FAILED_VAL = 0x400000L;

    public static Set<OFBsnPktinFlag> readFrom(ByteBuf bb) throws OFParseError {
        try {
            return OFBsnPktinFlagSerializerVer14.ofWireValue(bb.readLong());
        }
        catch (IllegalArgumentException e) {
            throw new OFParseError(e);
        }
    }

    public static void writeTo(ByteBuf bb, Set<OFBsnPktinFlag> set) {
        bb.writeLong(OFBsnPktinFlagSerializerVer14.toWireValue(set));
    }

    public static void putTo(Set<OFBsnPktinFlag> set, PrimitiveSink sink) {
        sink.putLong(OFBsnPktinFlagSerializerVer14.toWireValue(set));
    }

    public static Set<OFBsnPktinFlag> ofWireValue(long val) {
        EnumSet<OFBsnPktinFlag> set = EnumSet.noneOf(OFBsnPktinFlag.class);
        if ((val & 1L) != 0L) {
            set.add(OFBsnPktinFlag.BSN_PKTIN_FLAG_PDU);
        }
        if ((val & 2L) != 0L) {
            set.add(OFBsnPktinFlag.BSN_PKTIN_FLAG_NEW_HOST);
        }
        if ((val & 4L) != 0L) {
            set.add(OFBsnPktinFlag.BSN_PKTIN_FLAG_STATION_MOVE);
        }
        if ((val & 8L) != 0L) {
            set.add(OFBsnPktinFlag.BSN_PKTIN_FLAG_ARP);
        }
        if ((val & 0x10L) != 0L) {
            set.add(OFBsnPktinFlag.BSN_PKTIN_FLAG_DHCP);
        }
        if ((val & 0x20L) != 0L) {
            set.add(OFBsnPktinFlag.BSN_PKTIN_FLAG_L2_CPU);
        }
        if ((val & 0x40L) != 0L) {
            set.add(OFBsnPktinFlag.BSN_PKTIN_FLAG_DEBUG);
        }
        if ((val & 0x80L) != 0L) {
            set.add(OFBsnPktinFlag.BSN_PKTIN_FLAG_TTL_EXPIRED);
        }
        if ((val & 0x100L) != 0L) {
            set.add(OFBsnPktinFlag.BSN_PKTIN_FLAG_L3_MISS);
        }
        if ((val & 0x200L) != 0L) {
            set.add(OFBsnPktinFlag.BSN_PKTIN_FLAG_L3_CPU);
        }
        if ((val & 0x400L) != 0L) {
            set.add(OFBsnPktinFlag.BSN_PKTIN_FLAG_INGRESS_ACL);
        }
        if ((val & 0x800L) != 0L) {
            set.add(OFBsnPktinFlag.BSN_PKTIN_FLAG_SFLOW);
        }
        if ((val & 0x1000L) != 0L) {
            set.add(OFBsnPktinFlag.BSN_PKTIN_FLAG_ARP_CACHE);
        }
        if ((val & 0x2000L) != 0L) {
            set.add(OFBsnPktinFlag.BSN_PKTIN_FLAG_ARP_TARGET);
        }
        if ((val & 0x4000L) != 0L) {
            set.add(OFBsnPktinFlag.BSN_PKTIN_FLAG_IGMP);
        }
        if ((val & 0x8000L) != 0L) {
            set.add(OFBsnPktinFlag.BSN_PKTIN_FLAG_PIM);
        }
        if ((val & 0x10000L) != 0L) {
            set.add(OFBsnPktinFlag.BSN_PKTIN_FLAG_VXLAN_SIP_MISS);
        }
        if ((val & 0x20000L) != 0L) {
            set.add(OFBsnPktinFlag.BSN_PKTIN_FLAG_MC_RESERVED);
        }
        if ((val & 0x40000L) != 0L) {
            set.add(OFBsnPktinFlag.BSN_PKTIN_FLAG_ANALYTICS);
        }
        if ((val & 0x80000L) != 0L) {
            set.add(OFBsnPktinFlag.BSN_PKTIN_FLAG_ICMPV6);
        }
        if ((val & 0x100000L) != 0L) {
            set.add(OFBsnPktinFlag.BSN_PKTIN_FLAG_INGRESS_ACL_LOCAL);
        }
        if ((val & 0x200000L) != 0L) {
            set.add(OFBsnPktinFlag.BSN_PKTIN_FLAG_IPMC_MISS);
        }
        if ((val & 0x400000L) != 0L) {
            set.add(OFBsnPktinFlag.BSN_PKTIN_FLAG_IPMC_RPF_FAILED);
        }
        return Collections.unmodifiableSet(set);
    }

    public static long toWireValue(Set<OFBsnPktinFlag> set) {
        long wireValue = 0L;
        block25: for (OFBsnPktinFlag e : set) {
            switch (e) {
                case BSN_PKTIN_FLAG_PDU: {
                    wireValue |= 1L;
                    continue block25;
                }
                case BSN_PKTIN_FLAG_NEW_HOST: {
                    wireValue |= 2L;
                    continue block25;
                }
                case BSN_PKTIN_FLAG_STATION_MOVE: {
                    wireValue |= 4L;
                    continue block25;
                }
                case BSN_PKTIN_FLAG_ARP: {
                    wireValue |= 8L;
                    continue block25;
                }
                case BSN_PKTIN_FLAG_DHCP: {
                    wireValue |= 0x10L;
                    continue block25;
                }
                case BSN_PKTIN_FLAG_L2_CPU: {
                    wireValue |= 0x20L;
                    continue block25;
                }
                case BSN_PKTIN_FLAG_DEBUG: {
                    wireValue |= 0x40L;
                    continue block25;
                }
                case BSN_PKTIN_FLAG_TTL_EXPIRED: {
                    wireValue |= 0x80L;
                    continue block25;
                }
                case BSN_PKTIN_FLAG_L3_MISS: {
                    wireValue |= 0x100L;
                    continue block25;
                }
                case BSN_PKTIN_FLAG_L3_CPU: {
                    wireValue |= 0x200L;
                    continue block25;
                }
                case BSN_PKTIN_FLAG_INGRESS_ACL: {
                    wireValue |= 0x400L;
                    continue block25;
                }
                case BSN_PKTIN_FLAG_SFLOW: {
                    wireValue |= 0x800L;
                    continue block25;
                }
                case BSN_PKTIN_FLAG_ARP_CACHE: {
                    wireValue |= 0x1000L;
                    continue block25;
                }
                case BSN_PKTIN_FLAG_ARP_TARGET: {
                    wireValue |= 0x2000L;
                    continue block25;
                }
                case BSN_PKTIN_FLAG_IGMP: {
                    wireValue |= 0x4000L;
                    continue block25;
                }
                case BSN_PKTIN_FLAG_PIM: {
                    wireValue |= 0x8000L;
                    continue block25;
                }
                case BSN_PKTIN_FLAG_VXLAN_SIP_MISS: {
                    wireValue |= 0x10000L;
                    continue block25;
                }
                case BSN_PKTIN_FLAG_MC_RESERVED: {
                    wireValue |= 0x20000L;
                    continue block25;
                }
                case BSN_PKTIN_FLAG_ANALYTICS: {
                    wireValue |= 0x40000L;
                    continue block25;
                }
                case BSN_PKTIN_FLAG_ICMPV6: {
                    wireValue |= 0x80000L;
                    continue block25;
                }
                case BSN_PKTIN_FLAG_INGRESS_ACL_LOCAL: {
                    wireValue |= 0x100000L;
                    continue block25;
                }
                case BSN_PKTIN_FLAG_IPMC_MISS: {
                    wireValue |= 0x200000L;
                    continue block25;
                }
                case BSN_PKTIN_FLAG_IPMC_RPF_FAILED: {
                    wireValue |= 0x400000L;
                    continue block25;
                }
            }
            throw new IllegalArgumentException("Illegal enum value for type OFBsnPktinFlag in version 1.4: " + (Object)((Object)e));
        }
        return wireValue;
    }
}

