/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnGenericStatsEntry;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlv;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnTlvVer14;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnGenericStatsEntryVer14
implements OFBsnGenericStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnGenericStatsEntryVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 2;
    private static final List<OFBsnTlv> DEFAULT_TLVS = ImmutableList.of();
    private final List<OFBsnTlv> tlvs;
    static final OFBsnGenericStatsEntryVer14 DEFAULT = new OFBsnGenericStatsEntryVer14(DEFAULT_TLVS);
    static final Reader READER = new Reader();
    static final OFBsnGenericStatsEntryVer14Funnel FUNNEL = new OFBsnGenericStatsEntryVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnGenericStatsEntryVer14(List<OFBsnTlv> tlvs) {
        if (tlvs == null) {
            throw new NullPointerException("OFBsnGenericStatsEntryVer14: property tlvs cannot be null");
        }
        this.tlvs = tlvs;
    }

    @Override
    public List<OFBsnTlv> getTlvs() {
        return this.tlvs;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnGenericStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnGenericStatsEntryVer14(");
        b.append("tlvs=").append(this.tlvs);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGenericStatsEntryVer14 other = (OFBsnGenericStatsEntryVer14)obj;
        return !(this.tlvs == null ? other.tlvs != null : !this.tlvs.equals(other.tlvs));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tlvs == null ? 0 : this.tlvs.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnGenericStatsEntryVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnGenericStatsEntryVer14 message) {
            int startIndex = bb.writerIndex();
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            ChannelUtils.writeList(bb, message.tlvs);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBsnGenericStatsEntryVer14Funnel
    implements Funnel<OFBsnGenericStatsEntryVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnGenericStatsEntryVer14Funnel() {
        }

        public void funnel(OFBsnGenericStatsEntryVer14 message, PrimitiveSink sink) {
            FunnelUtils.putList(message.tlvs, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnGenericStatsEntry> {
        Reader() {
        }

        @Override
        public OFBsnGenericStatsEntry readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            int length = U16.f(bb.readShort());
            if (length < 2) {
                throw new OFParseError("Wrong length: Expected to be >= 2, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            List<OFBsnTlv> tlvs = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFBsnTlvVer14.READER);
            OFBsnGenericStatsEntryVer14 bsnGenericStatsEntryVer14 = new OFBsnGenericStatsEntryVer14(tlvs);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnGenericStatsEntryVer14);
            }
            return bsnGenericStatsEntryVer14;
        }
    }

    static class Builder
    implements OFBsnGenericStatsEntry.Builder {
        private boolean tlvsSet;
        private List<OFBsnTlv> tlvs;

        Builder() {
        }

        @Override
        public List<OFBsnTlv> getTlvs() {
            return this.tlvs;
        }

        @Override
        public OFBsnGenericStatsEntry.Builder setTlvs(List<OFBsnTlv> tlvs) {
            this.tlvs = tlvs;
            this.tlvsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnGenericStatsEntry build() {
            List<OFBsnTlv> tlvs;
            List<OFBsnTlv> list = tlvs = this.tlvsSet ? this.tlvs : DEFAULT_TLVS;
            if (tlvs == null) {
                throw new NullPointerException("Property tlvs must not be null");
            }
            return new OFBsnGenericStatsEntryVer14(tlvs);
        }
    }

    static class BuilderWithParent
    implements OFBsnGenericStatsEntry.Builder {
        final OFBsnGenericStatsEntryVer14 parentMessage;
        private boolean tlvsSet;
        private List<OFBsnTlv> tlvs;

        BuilderWithParent(OFBsnGenericStatsEntryVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public List<OFBsnTlv> getTlvs() {
            return this.tlvs;
        }

        @Override
        public OFBsnGenericStatsEntry.Builder setTlvs(List<OFBsnTlv> tlvs) {
            this.tlvs = tlvs;
            this.tlvsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnGenericStatsEntry build() {
            List tlvs;
            List list = tlvs = this.tlvsSet ? this.tlvs : this.parentMessage.tlvs;
            if (tlvs == null) {
                throw new NullPointerException("Property tlvs must not be null");
            }
            return new OFBsnGenericStatsEntryVer14(tlvs);
        }
    }
}

