/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmIcmpv6TypeMasked;
import org.projectfloodlight.openflow.protocol.ver13.OFOxmIcmpv6TypeVer13;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmIcmpv6TypeMaskedVer13
implements OFOxmIcmpv6TypeMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmIcmpv6TypeMaskedVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 6;
    private static final U8 DEFAULT_VALUE = U8.ZERO;
    private static final U8 DEFAULT_VALUE_MASK = U8.ZERO;
    private final U8 value;
    private final U8 mask;
    static final OFOxmIcmpv6TypeMaskedVer13 DEFAULT = new OFOxmIcmpv6TypeMaskedVer13(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmIcmpv6TypeMaskedVer13Funnel FUNNEL = new OFOxmIcmpv6TypeMaskedVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmIcmpv6TypeMaskedVer13(U8 value, U8 mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmIcmpv6TypeMaskedVer13: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmIcmpv6TypeMaskedVer13: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 2147498754L;
    }

    @Override
    public U8 getValue() {
        return this.value;
    }

    @Override
    public U8 getMask() {
        return this.mask;
    }

    @Override
    public MatchField<U8> getMatchField() {
        return MatchField.ICMPV6_TYPE;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<U8> getCanonical() {
        if (U8.NO_MASK.equals(this.mask)) {
            return new OFOxmIcmpv6TypeVer13(this.value);
        }
        if (U8.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmIcmpv6TypeMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmIcmpv6TypeMaskedVer13(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmIcmpv6TypeMaskedVer13 other = (OFOxmIcmpv6TypeMaskedVer13)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmIcmpv6TypeMaskedVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmIcmpv6TypeMaskedVer13 message) {
            bb.writeInt(-2147468542);
            bb.writeByte((int)message.value.getRaw());
            bb.writeByte((int)message.mask.getRaw());
        }
    }

    static class OFOxmIcmpv6TypeMaskedVer13Funnel
    implements Funnel<OFOxmIcmpv6TypeMaskedVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmIcmpv6TypeMaskedVer13Funnel() {
        }

        public void funnel(OFOxmIcmpv6TypeMaskedVer13 message, PrimitiveSink sink) {
            sink.putInt(-2147468542);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmIcmpv6TypeMasked> {
        Reader() {
        }

        @Override
        public OFOxmIcmpv6TypeMasked readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147468542) {
                throw new OFParseError("Wrong typeLen: Expected=0x80003b02L(0x80003b02L), got=" + typeLen);
            }
            U8 value = U8.of(bb.readByte());
            U8 mask = U8.of(bb.readByte());
            OFOxmIcmpv6TypeMaskedVer13 oxmIcmpv6TypeMaskedVer13 = new OFOxmIcmpv6TypeMaskedVer13(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmIcmpv6TypeMaskedVer13);
            }
            return oxmIcmpv6TypeMaskedVer13;
        }
    }

    static class Builder
    implements OFOxmIcmpv6TypeMasked.Builder {
        private boolean valueSet;
        private U8 value;
        private boolean maskSet;
        private U8 mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147498754L;
        }

        @Override
        public U8 getValue() {
            return this.value;
        }

        @Override
        public OFOxmIcmpv6TypeMasked.Builder setValue(U8 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public U8 getMask() {
            return this.mask;
        }

        @Override
        public OFOxmIcmpv6TypeMasked.Builder setMask(U8 mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<U8> getMatchField() {
            return MatchField.ICMPV6_TYPE;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<U8> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmIcmpv6TypeMasked build() {
            U8 mask;
            U8 value;
            U8 u8 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            U8 u82 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmIcmpv6TypeMaskedVer13(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmIcmpv6TypeMasked.Builder {
        final OFOxmIcmpv6TypeMaskedVer13 parentMessage;
        private boolean valueSet;
        private U8 value;
        private boolean maskSet;
        private U8 mask;

        BuilderWithParent(OFOxmIcmpv6TypeMaskedVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147498754L;
        }

        @Override
        public U8 getValue() {
            return this.value;
        }

        @Override
        public OFOxmIcmpv6TypeMasked.Builder setValue(U8 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public U8 getMask() {
            return this.mask;
        }

        @Override
        public OFOxmIcmpv6TypeMasked.Builder setMask(U8 mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<U8> getMatchField() {
            return MatchField.ICMPV6_TYPE;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<U8> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmIcmpv6TypeMasked build() {
            U8 mask;
            U8 value;
            U8 u8 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            U8 u82 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmIcmpv6TypeMaskedVer13(value, mask);
        }
    }
}

