/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmConnTrackingIpv6SrcMasked;
import org.projectfloodlight.openflow.protocol.ver13.OFOxmConnTrackingIpv6SrcVer13;
import org.projectfloodlight.openflow.types.IPv6Address;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmConnTrackingIpv6SrcMaskedVer13
implements OFOxmConnTrackingIpv6SrcMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmConnTrackingIpv6SrcMaskedVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 36;
    private static final IPv6Address DEFAULT_VALUE = IPv6Address.NONE;
    private static final IPv6Address DEFAULT_VALUE_MASK = IPv6Address.NONE;
    private final IPv6Address value;
    private final IPv6Address mask;
    static final OFOxmConnTrackingIpv6SrcMaskedVer13 DEFAULT = new OFOxmConnTrackingIpv6SrcMaskedVer13(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmConnTrackingIpv6SrcMaskedVer13Funnel FUNNEL = new OFOxmConnTrackingIpv6SrcMaskedVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmConnTrackingIpv6SrcMaskedVer13(IPv6Address value, IPv6Address mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmConnTrackingIpv6SrcMaskedVer13: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmConnTrackingIpv6SrcMaskedVer13: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 128288L;
    }

    @Override
    public IPv6Address getValue() {
        return this.value;
    }

    @Override
    public IPv6Address getMask() {
        return this.mask;
    }

    @Override
    public MatchField<IPv6Address> getMatchField() {
        return MatchField.CONN_TRACKING_IPV6_SRC;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<IPv6Address> getCanonical() {
        if (IPv6Address.NO_MASK.equals(this.mask)) {
            return new OFOxmConnTrackingIpv6SrcVer13(this.value);
        }
        if (IPv6Address.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmConnTrackingIpv6SrcMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmConnTrackingIpv6SrcMaskedVer13(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmConnTrackingIpv6SrcMaskedVer13 other = (OFOxmConnTrackingIpv6SrcMaskedVer13)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmConnTrackingIpv6SrcMaskedVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmConnTrackingIpv6SrcMaskedVer13 message) {
            bb.writeInt(128288);
            message.value.write16Bytes(bb);
            message.mask.write16Bytes(bb);
        }
    }

    static class OFOxmConnTrackingIpv6SrcMaskedVer13Funnel
    implements Funnel<OFOxmConnTrackingIpv6SrcMaskedVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmConnTrackingIpv6SrcMaskedVer13Funnel() {
        }

        public void funnel(OFOxmConnTrackingIpv6SrcMaskedVer13 message, PrimitiveSink sink) {
            sink.putInt(128288);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmConnTrackingIpv6SrcMasked> {
        Reader() {
        }

        @Override
        public OFOxmConnTrackingIpv6SrcMasked readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 128288) {
                throw new OFParseError("Wrong typeLen: Expected=0x1f520L(0x1f520L), got=" + typeLen);
            }
            IPv6Address value = IPv6Address.read16Bytes(bb);
            IPv6Address mask = IPv6Address.read16Bytes(bb);
            OFOxmConnTrackingIpv6SrcMaskedVer13 oxmConnTrackingIpv6SrcMaskedVer13 = new OFOxmConnTrackingIpv6SrcMaskedVer13(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmConnTrackingIpv6SrcMaskedVer13);
            }
            return oxmConnTrackingIpv6SrcMaskedVer13;
        }
    }

    static class Builder
    implements OFOxmConnTrackingIpv6SrcMasked.Builder {
        private boolean valueSet;
        private IPv6Address value;
        private boolean maskSet;
        private IPv6Address mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 128288L;
        }

        @Override
        public IPv6Address getValue() {
            return this.value;
        }

        @Override
        public OFOxmConnTrackingIpv6SrcMasked.Builder setValue(IPv6Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public IPv6Address getMask() {
            return this.mask;
        }

        @Override
        public OFOxmConnTrackingIpv6SrcMasked.Builder setMask(IPv6Address mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<IPv6Address> getMatchField() {
            return MatchField.CONN_TRACKING_IPV6_SRC;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<IPv6Address> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmConnTrackingIpv6SrcMasked build() {
            IPv6Address mask;
            IPv6Address value;
            IPv6Address iPv6Address = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            IPv6Address iPv6Address2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmConnTrackingIpv6SrcMaskedVer13(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmConnTrackingIpv6SrcMasked.Builder {
        final OFOxmConnTrackingIpv6SrcMaskedVer13 parentMessage;
        private boolean valueSet;
        private IPv6Address value;
        private boolean maskSet;
        private IPv6Address mask;

        BuilderWithParent(OFOxmConnTrackingIpv6SrcMaskedVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 128288L;
        }

        @Override
        public IPv6Address getValue() {
            return this.value;
        }

        @Override
        public OFOxmConnTrackingIpv6SrcMasked.Builder setValue(IPv6Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public IPv6Address getMask() {
            return this.mask;
        }

        @Override
        public OFOxmConnTrackingIpv6SrcMasked.Builder setMask(IPv6Address mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<IPv6Address> getMatchField() {
            return MatchField.CONN_TRACKING_IPV6_SRC;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<IPv6Address> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmConnTrackingIpv6SrcMasked build() {
            IPv6Address mask;
            IPv6Address value;
            IPv6Address iPv6Address = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            IPv6Address iPv6Address2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmConnTrackingIpv6SrcMaskedVer13(value, mask);
        }
    }
}

