/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFGroupCapabilities;
import org.projectfloodlight.openflow.protocol.OFGroupFeaturesStatsReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFStatsReplyFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver13.OFGroupCapabilitiesSerializerVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFStatsReplyFlagsSerializerVer13;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFGroupFeaturesStatsReplyVer13
implements OFGroupFeaturesStatsReply {
    private static final Logger logger = LoggerFactory.getLogger(OFGroupFeaturesStatsReplyVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 56;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsReplyFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final long DEFAULT_TYPES = 0L;
    private static final Set<OFGroupCapabilities> DEFAULT_CAPABILITIES = ImmutableSet.of();
    private static final long DEFAULT_MAX_GROUPS_ALL = 0L;
    private static final long DEFAULT_MAX_GROUPS_SELECT = 0L;
    private static final long DEFAULT_MAX_GROUPS_INDIRECT = 0L;
    private static final long DEFAULT_MAX_GROUPS_FF = 0L;
    private static final long DEFAULT_ACTIONS_ALL = 0L;
    private static final long DEFAULT_ACTIONS_SELECT = 0L;
    private static final long DEFAULT_ACTIONS_INDIRECT = 0L;
    private static final long DEFAULT_ACTIONS_FF = 0L;
    private final long xid;
    private final Set<OFStatsReplyFlags> flags;
    private final long types;
    private final Set<OFGroupCapabilities> capabilities;
    private final long maxGroupsAll;
    private final long maxGroupsSelect;
    private final long maxGroupsIndirect;
    private final long maxGroupsFf;
    private final long actionsAll;
    private final long actionsSelect;
    private final long actionsIndirect;
    private final long actionsFf;
    static final OFGroupFeaturesStatsReplyVer13 DEFAULT = new OFGroupFeaturesStatsReplyVer13(0L, DEFAULT_FLAGS, 0L, DEFAULT_CAPABILITIES, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
    static final Reader READER = new Reader();
    static final OFGroupFeaturesStatsReplyVer13Funnel FUNNEL = new OFGroupFeaturesStatsReplyVer13Funnel();
    static final Writer WRITER = new Writer();

    OFGroupFeaturesStatsReplyVer13(long xid, Set<OFStatsReplyFlags> flags, long types, Set<OFGroupCapabilities> capabilities, long maxGroupsAll, long maxGroupsSelect, long maxGroupsIndirect, long maxGroupsFf, long actionsAll, long actionsSelect, long actionsIndirect, long actionsFf) {
        if (flags == null) {
            throw new NullPointerException("OFGroupFeaturesStatsReplyVer13: property flags cannot be null");
        }
        if (capabilities == null) {
            throw new NullPointerException("OFGroupFeaturesStatsReplyVer13: property capabilities cannot be null");
        }
        this.xid = xid;
        this.flags = flags;
        this.types = types;
        this.capabilities = capabilities;
        this.maxGroupsAll = maxGroupsAll;
        this.maxGroupsSelect = maxGroupsSelect;
        this.maxGroupsIndirect = maxGroupsIndirect;
        this.maxGroupsFf = maxGroupsFf;
        this.actionsAll = actionsAll;
        this.actionsSelect = actionsSelect;
        this.actionsIndirect = actionsIndirect;
        this.actionsFf = actionsFf;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REPLY;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.GROUP_FEATURES;
    }

    @Override
    public Set<OFStatsReplyFlags> getFlags() {
        return this.flags;
    }

    @Override
    public long getTypes() {
        return this.types;
    }

    @Override
    public Set<OFGroupCapabilities> getCapabilities() {
        return this.capabilities;
    }

    @Override
    public long getMaxGroupsAll() {
        return this.maxGroupsAll;
    }

    @Override
    public long getMaxGroupsSelect() {
        return this.maxGroupsSelect;
    }

    @Override
    public long getMaxGroupsIndirect() {
        return this.maxGroupsIndirect;
    }

    @Override
    public long getMaxGroupsFf() {
        return this.maxGroupsFf;
    }

    @Override
    public long getActionsAll() {
        return this.actionsAll;
    }

    @Override
    public long getActionsSelect() {
        return this.actionsSelect;
    }

    @Override
    public long getActionsIndirect() {
        return this.actionsIndirect;
    }

    @Override
    public long getActionsFf() {
        return this.actionsFf;
    }

    @Override
    public OFGroupFeaturesStatsReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFGroupFeaturesStatsReplyVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("types=").append(this.types);
        b.append(", ");
        b.append("capabilities=").append(this.capabilities);
        b.append(", ");
        b.append("maxGroupsAll=").append(this.maxGroupsAll);
        b.append(", ");
        b.append("maxGroupsSelect=").append(this.maxGroupsSelect);
        b.append(", ");
        b.append("maxGroupsIndirect=").append(this.maxGroupsIndirect);
        b.append(", ");
        b.append("maxGroupsFf=").append(this.maxGroupsFf);
        b.append(", ");
        b.append("actionsAll=").append(this.actionsAll);
        b.append(", ");
        b.append("actionsSelect=").append(this.actionsSelect);
        b.append(", ");
        b.append("actionsIndirect=").append(this.actionsIndirect);
        b.append(", ");
        b.append("actionsFf=").append(this.actionsFf);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFGroupFeaturesStatsReplyVer13 other = (OFGroupFeaturesStatsReplyVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        if (this.types != other.types) {
            return false;
        }
        if (this.capabilities == null ? other.capabilities != null : !this.capabilities.equals(other.capabilities)) {
            return false;
        }
        if (this.maxGroupsAll != other.maxGroupsAll) {
            return false;
        }
        if (this.maxGroupsSelect != other.maxGroupsSelect) {
            return false;
        }
        if (this.maxGroupsIndirect != other.maxGroupsIndirect) {
            return false;
        }
        if (this.maxGroupsFf != other.maxGroupsFf) {
            return false;
        }
        if (this.actionsAll != other.actionsAll) {
            return false;
        }
        if (this.actionsSelect != other.actionsSelect) {
            return false;
        }
        if (this.actionsIndirect != other.actionsIndirect) {
            return false;
        }
        return this.actionsFf == other.actionsFf;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFGroupFeaturesStatsReplyVer13 other = (OFGroupFeaturesStatsReplyVer13)obj;
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        if (this.types != other.types) {
            return false;
        }
        if (this.capabilities == null ? other.capabilities != null : !this.capabilities.equals(other.capabilities)) {
            return false;
        }
        if (this.maxGroupsAll != other.maxGroupsAll) {
            return false;
        }
        if (this.maxGroupsSelect != other.maxGroupsSelect) {
            return false;
        }
        if (this.maxGroupsIndirect != other.maxGroupsIndirect) {
            return false;
        }
        if (this.maxGroupsFf != other.maxGroupsFf) {
            return false;
        }
        if (this.actionsAll != other.actionsAll) {
            return false;
        }
        if (this.actionsSelect != other.actionsSelect) {
            return false;
        }
        if (this.actionsIndirect != other.actionsIndirect) {
            return false;
        }
        return this.actionsFf == other.actionsFf;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * (int)(this.types ^ this.types >>> 32);
        result = 31 * result + (this.capabilities == null ? 0 : this.capabilities.hashCode());
        result = 31 * (int)(this.maxGroupsAll ^ this.maxGroupsAll >>> 32);
        result = 31 * (int)(this.maxGroupsSelect ^ this.maxGroupsSelect >>> 32);
        result = 31 * (int)(this.maxGroupsIndirect ^ this.maxGroupsIndirect >>> 32);
        result = 31 * (int)(this.maxGroupsFf ^ this.maxGroupsFf >>> 32);
        result = 31 * (int)(this.actionsAll ^ this.actionsAll >>> 32);
        result = 31 * (int)(this.actionsSelect ^ this.actionsSelect >>> 32);
        result = 31 * (int)(this.actionsIndirect ^ this.actionsIndirect >>> 32);
        result = 31 * (int)(this.actionsFf ^ this.actionsFf >>> 32);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * (int)(this.types ^ this.types >>> 32);
        result = 31 * result + (this.capabilities == null ? 0 : this.capabilities.hashCode());
        result = 31 * (int)(this.maxGroupsAll ^ this.maxGroupsAll >>> 32);
        result = 31 * (int)(this.maxGroupsSelect ^ this.maxGroupsSelect >>> 32);
        result = 31 * (int)(this.maxGroupsIndirect ^ this.maxGroupsIndirect >>> 32);
        result = 31 * (int)(this.maxGroupsFf ^ this.maxGroupsFf >>> 32);
        result = 31 * (int)(this.actionsAll ^ this.actionsAll >>> 32);
        result = 31 * (int)(this.actionsSelect ^ this.actionsSelect >>> 32);
        result = 31 * (int)(this.actionsIndirect ^ this.actionsIndirect >>> 32);
        result = 31 * (int)(this.actionsFf ^ this.actionsFf >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFGroupFeaturesStatsReplyVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFGroupFeaturesStatsReplyVer13 message) {
            bb.writeByte(4);
            bb.writeByte(19);
            bb.writeShort(56);
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(8);
            OFStatsReplyFlagsSerializerVer13.writeTo(bb, message.flags);
            bb.writeZero(4);
            bb.writeInt(U32.t(message.types));
            OFGroupCapabilitiesSerializerVer13.writeTo(bb, message.capabilities);
            bb.writeInt(U32.t(message.maxGroupsAll));
            bb.writeInt(U32.t(message.maxGroupsSelect));
            bb.writeInt(U32.t(message.maxGroupsIndirect));
            bb.writeInt(U32.t(message.maxGroupsFf));
            bb.writeInt(U32.t(message.actionsAll));
            bb.writeInt(U32.t(message.actionsSelect));
            bb.writeInt(U32.t(message.actionsIndirect));
            bb.writeInt(U32.t(message.actionsFf));
        }
    }

    static class OFGroupFeaturesStatsReplyVer13Funnel
    implements Funnel<OFGroupFeaturesStatsReplyVer13> {
        private static final long serialVersionUID = 1L;

        OFGroupFeaturesStatsReplyVer13Funnel() {
        }

        public void funnel(OFGroupFeaturesStatsReplyVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)19);
            sink.putShort((short)56);
            sink.putLong(message.xid);
            sink.putShort((short)8);
            OFStatsReplyFlagsSerializerVer13.putTo(message.flags, sink);
            sink.putLong(message.types);
            OFGroupCapabilitiesSerializerVer13.putTo(message.capabilities, sink);
            sink.putLong(message.maxGroupsAll);
            sink.putLong(message.maxGroupsSelect);
            sink.putLong(message.maxGroupsIndirect);
            sink.putLong(message.maxGroupsFf);
            sink.putLong(message.actionsAll);
            sink.putLong(message.actionsSelect);
            sink.putLong(message.actionsIndirect);
            sink.putLong(message.actionsFf);
        }
    }

    static class Reader
    implements OFMessageReader<OFGroupFeaturesStatsReply> {
        Reader() {
        }

        @Override
        public OFGroupFeaturesStatsReply readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 19) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REPLY(19), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 56) {
                throw new OFParseError("Wrong length: Expected=56(56), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != 8) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.GROUP_FEATURES(8), got=" + statsType);
            }
            Set<OFStatsReplyFlags> flags = OFStatsReplyFlagsSerializerVer13.readFrom(bb);
            bb.skipBytes(4);
            long types = U32.f(bb.readInt());
            Set<OFGroupCapabilities> capabilities = OFGroupCapabilitiesSerializerVer13.readFrom(bb);
            long maxGroupsAll = U32.f(bb.readInt());
            long maxGroupsSelect = U32.f(bb.readInt());
            long maxGroupsIndirect = U32.f(bb.readInt());
            long maxGroupsFf = U32.f(bb.readInt());
            long actionsAll = U32.f(bb.readInt());
            long actionsSelect = U32.f(bb.readInt());
            long actionsIndirect = U32.f(bb.readInt());
            long actionsFf = U32.f(bb.readInt());
            OFGroupFeaturesStatsReplyVer13 groupFeaturesStatsReplyVer13 = new OFGroupFeaturesStatsReplyVer13(xid, flags, types, capabilities, maxGroupsAll, maxGroupsSelect, maxGroupsIndirect, maxGroupsFf, actionsAll, actionsSelect, actionsIndirect, actionsFf);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)groupFeaturesStatsReplyVer13);
            }
            return groupFeaturesStatsReplyVer13;
        }
    }

    static class Builder
    implements OFGroupFeaturesStatsReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsReplyFlags> flags;
        private boolean typesSet;
        private long types;
        private boolean capabilitiesSet;
        private Set<OFGroupCapabilities> capabilities;
        private boolean maxGroupsAllSet;
        private long maxGroupsAll;
        private boolean maxGroupsSelectSet;
        private long maxGroupsSelect;
        private boolean maxGroupsIndirectSet;
        private long maxGroupsIndirect;
        private boolean maxGroupsFfSet;
        private long maxGroupsFf;
        private boolean actionsAllSet;
        private long actionsAll;
        private boolean actionsSelectSet;
        private long actionsSelect;
        private boolean actionsIndirectSet;
        private long actionsIndirect;
        private boolean actionsFfSet;
        private long actionsFf;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFGroupFeaturesStatsReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.GROUP_FEATURES;
        }

        @Override
        public Set<OFStatsReplyFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFGroupFeaturesStatsReply.Builder setFlags(Set<OFStatsReplyFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getTypes() {
            return this.types;
        }

        @Override
        public OFGroupFeaturesStatsReply.Builder setTypes(long types) {
            this.types = types;
            this.typesSet = true;
            return this;
        }

        @Override
        public Set<OFGroupCapabilities> getCapabilities() {
            return this.capabilities;
        }

        @Override
        public OFGroupFeaturesStatsReply.Builder setCapabilities(Set<OFGroupCapabilities> capabilities) {
            this.capabilities = capabilities;
            this.capabilitiesSet = true;
            return this;
        }

        @Override
        public long getMaxGroupsAll() {
            return this.maxGroupsAll;
        }

        @Override
        public OFGroupFeaturesStatsReply.Builder setMaxGroupsAll(long maxGroupsAll) {
            this.maxGroupsAll = maxGroupsAll;
            this.maxGroupsAllSet = true;
            return this;
        }

        @Override
        public long getMaxGroupsSelect() {
            return this.maxGroupsSelect;
        }

        @Override
        public OFGroupFeaturesStatsReply.Builder setMaxGroupsSelect(long maxGroupsSelect) {
            this.maxGroupsSelect = maxGroupsSelect;
            this.maxGroupsSelectSet = true;
            return this;
        }

        @Override
        public long getMaxGroupsIndirect() {
            return this.maxGroupsIndirect;
        }

        @Override
        public OFGroupFeaturesStatsReply.Builder setMaxGroupsIndirect(long maxGroupsIndirect) {
            this.maxGroupsIndirect = maxGroupsIndirect;
            this.maxGroupsIndirectSet = true;
            return this;
        }

        @Override
        public long getMaxGroupsFf() {
            return this.maxGroupsFf;
        }

        @Override
        public OFGroupFeaturesStatsReply.Builder setMaxGroupsFf(long maxGroupsFf) {
            this.maxGroupsFf = maxGroupsFf;
            this.maxGroupsFfSet = true;
            return this;
        }

        @Override
        public long getActionsAll() {
            return this.actionsAll;
        }

        @Override
        public OFGroupFeaturesStatsReply.Builder setActionsAll(long actionsAll) {
            this.actionsAll = actionsAll;
            this.actionsAllSet = true;
            return this;
        }

        @Override
        public long getActionsSelect() {
            return this.actionsSelect;
        }

        @Override
        public OFGroupFeaturesStatsReply.Builder setActionsSelect(long actionsSelect) {
            this.actionsSelect = actionsSelect;
            this.actionsSelectSet = true;
            return this;
        }

        @Override
        public long getActionsIndirect() {
            return this.actionsIndirect;
        }

        @Override
        public OFGroupFeaturesStatsReply.Builder setActionsIndirect(long actionsIndirect) {
            this.actionsIndirect = actionsIndirect;
            this.actionsIndirectSet = true;
            return this;
        }

        @Override
        public long getActionsFf() {
            return this.actionsFf;
        }

        @Override
        public OFGroupFeaturesStatsReply.Builder setActionsFf(long actionsFf) {
            this.actionsFf = actionsFf;
            this.actionsFfSet = true;
            return this;
        }

        @Override
        public OFGroupFeaturesStatsReply build() {
            Set<OFGroupCapabilities> capabilities;
            Set<OFStatsReplyFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsReplyFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            long types = this.typesSet ? this.types : 0L;
            Set<OFGroupCapabilities> set2 = capabilities = this.capabilitiesSet ? this.capabilities : DEFAULT_CAPABILITIES;
            if (capabilities == null) {
                throw new NullPointerException("Property capabilities must not be null");
            }
            long maxGroupsAll = this.maxGroupsAllSet ? this.maxGroupsAll : 0L;
            long maxGroupsSelect = this.maxGroupsSelectSet ? this.maxGroupsSelect : 0L;
            long maxGroupsIndirect = this.maxGroupsIndirectSet ? this.maxGroupsIndirect : 0L;
            long maxGroupsFf = this.maxGroupsFfSet ? this.maxGroupsFf : 0L;
            long actionsAll = this.actionsAllSet ? this.actionsAll : 0L;
            long actionsSelect = this.actionsSelectSet ? this.actionsSelect : 0L;
            long actionsIndirect = this.actionsIndirectSet ? this.actionsIndirect : 0L;
            long actionsFf = this.actionsFfSet ? this.actionsFf : 0L;
            return new OFGroupFeaturesStatsReplyVer13(xid, flags, types, capabilities, maxGroupsAll, maxGroupsSelect, maxGroupsIndirect, maxGroupsFf, actionsAll, actionsSelect, actionsIndirect, actionsFf);
        }
    }

    static class BuilderWithParent
    implements OFGroupFeaturesStatsReply.Builder {
        final OFGroupFeaturesStatsReplyVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsReplyFlags> flags;
        private boolean typesSet;
        private long types;
        private boolean capabilitiesSet;
        private Set<OFGroupCapabilities> capabilities;
        private boolean maxGroupsAllSet;
        private long maxGroupsAll;
        private boolean maxGroupsSelectSet;
        private long maxGroupsSelect;
        private boolean maxGroupsIndirectSet;
        private long maxGroupsIndirect;
        private boolean maxGroupsFfSet;
        private long maxGroupsFf;
        private boolean actionsAllSet;
        private long actionsAll;
        private boolean actionsSelectSet;
        private long actionsSelect;
        private boolean actionsIndirectSet;
        private long actionsIndirect;
        private boolean actionsFfSet;
        private long actionsFf;

        BuilderWithParent(OFGroupFeaturesStatsReplyVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFGroupFeaturesStatsReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.GROUP_FEATURES;
        }

        @Override
        public Set<OFStatsReplyFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFGroupFeaturesStatsReply.Builder setFlags(Set<OFStatsReplyFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getTypes() {
            return this.types;
        }

        @Override
        public OFGroupFeaturesStatsReply.Builder setTypes(long types) {
            this.types = types;
            this.typesSet = true;
            return this;
        }

        @Override
        public Set<OFGroupCapabilities> getCapabilities() {
            return this.capabilities;
        }

        @Override
        public OFGroupFeaturesStatsReply.Builder setCapabilities(Set<OFGroupCapabilities> capabilities) {
            this.capabilities = capabilities;
            this.capabilitiesSet = true;
            return this;
        }

        @Override
        public long getMaxGroupsAll() {
            return this.maxGroupsAll;
        }

        @Override
        public OFGroupFeaturesStatsReply.Builder setMaxGroupsAll(long maxGroupsAll) {
            this.maxGroupsAll = maxGroupsAll;
            this.maxGroupsAllSet = true;
            return this;
        }

        @Override
        public long getMaxGroupsSelect() {
            return this.maxGroupsSelect;
        }

        @Override
        public OFGroupFeaturesStatsReply.Builder setMaxGroupsSelect(long maxGroupsSelect) {
            this.maxGroupsSelect = maxGroupsSelect;
            this.maxGroupsSelectSet = true;
            return this;
        }

        @Override
        public long getMaxGroupsIndirect() {
            return this.maxGroupsIndirect;
        }

        @Override
        public OFGroupFeaturesStatsReply.Builder setMaxGroupsIndirect(long maxGroupsIndirect) {
            this.maxGroupsIndirect = maxGroupsIndirect;
            this.maxGroupsIndirectSet = true;
            return this;
        }

        @Override
        public long getMaxGroupsFf() {
            return this.maxGroupsFf;
        }

        @Override
        public OFGroupFeaturesStatsReply.Builder setMaxGroupsFf(long maxGroupsFf) {
            this.maxGroupsFf = maxGroupsFf;
            this.maxGroupsFfSet = true;
            return this;
        }

        @Override
        public long getActionsAll() {
            return this.actionsAll;
        }

        @Override
        public OFGroupFeaturesStatsReply.Builder setActionsAll(long actionsAll) {
            this.actionsAll = actionsAll;
            this.actionsAllSet = true;
            return this;
        }

        @Override
        public long getActionsSelect() {
            return this.actionsSelect;
        }

        @Override
        public OFGroupFeaturesStatsReply.Builder setActionsSelect(long actionsSelect) {
            this.actionsSelect = actionsSelect;
            this.actionsSelectSet = true;
            return this;
        }

        @Override
        public long getActionsIndirect() {
            return this.actionsIndirect;
        }

        @Override
        public OFGroupFeaturesStatsReply.Builder setActionsIndirect(long actionsIndirect) {
            this.actionsIndirect = actionsIndirect;
            this.actionsIndirectSet = true;
            return this;
        }

        @Override
        public long getActionsFf() {
            return this.actionsFf;
        }

        @Override
        public OFGroupFeaturesStatsReply.Builder setActionsFf(long actionsFf) {
            this.actionsFf = actionsFf;
            this.actionsFfSet = true;
            return this;
        }

        @Override
        public OFGroupFeaturesStatsReply build() {
            Set capabilities;
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            long types = this.typesSet ? this.types : this.parentMessage.types;
            Set set2 = capabilities = this.capabilitiesSet ? this.capabilities : this.parentMessage.capabilities;
            if (capabilities == null) {
                throw new NullPointerException("Property capabilities must not be null");
            }
            long maxGroupsAll = this.maxGroupsAllSet ? this.maxGroupsAll : this.parentMessage.maxGroupsAll;
            long maxGroupsSelect = this.maxGroupsSelectSet ? this.maxGroupsSelect : this.parentMessage.maxGroupsSelect;
            long maxGroupsIndirect = this.maxGroupsIndirectSet ? this.maxGroupsIndirect : this.parentMessage.maxGroupsIndirect;
            long maxGroupsFf = this.maxGroupsFfSet ? this.maxGroupsFf : this.parentMessage.maxGroupsFf;
            long actionsAll = this.actionsAllSet ? this.actionsAll : this.parentMessage.actionsAll;
            long actionsSelect = this.actionsSelectSet ? this.actionsSelect : this.parentMessage.actionsSelect;
            long actionsIndirect = this.actionsIndirectSet ? this.actionsIndirect : this.parentMessage.actionsIndirect;
            long actionsFf = this.actionsFfSet ? this.actionsFf : this.parentMessage.actionsFf;
            return new OFGroupFeaturesStatsReplyVer13(xid, flags, types, capabilities, maxGroupsAll, maxGroupsSelect, maxGroupsIndirect, maxGroupsFf, actionsAll, actionsSelect, actionsIndirect, actionsFf);
        }
    }
}

