/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFGetConfigRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFGetConfigRequestVer13
implements OFGetConfigRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFGetConfigRequestVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final long DEFAULT_XID = 0L;
    private final long xid;
    static final OFGetConfigRequestVer13 DEFAULT = new OFGetConfigRequestVer13(0L);
    static final Reader READER = new Reader();
    static final OFGetConfigRequestVer13Funnel FUNNEL = new OFGetConfigRequestVer13Funnel();
    static final Writer WRITER = new Writer();

    OFGetConfigRequestVer13(long xid) {
        this.xid = xid;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.GET_CONFIG_REQUEST;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFGetConfigRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFGetConfigRequestVer13(");
        b.append("xid=").append(this.xid);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFGetConfigRequestVer13 other = (OFGetConfigRequestVer13)obj;
        return this.xid == other.xid;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFGetConfigRequestVer13 other = (OFGetConfigRequestVer13)obj;
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFGetConfigRequestVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFGetConfigRequestVer13 message) {
            bb.writeByte(4);
            bb.writeByte(7);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.xid));
        }
    }

    static class OFGetConfigRequestVer13Funnel
    implements Funnel<OFGetConfigRequestVer13> {
        private static final long serialVersionUID = 1L;

        OFGetConfigRequestVer13Funnel() {
        }

        public void funnel(OFGetConfigRequestVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)7);
            sink.putShort((short)8);
            sink.putLong(message.xid);
        }
    }

    static class Reader
    implements OFMessageReader<OFGetConfigRequest> {
        Reader() {
        }

        @Override
        public OFGetConfigRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 7) {
                throw new OFParseError("Wrong type: Expected=OFType.GET_CONFIG_REQUEST(7), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            OFGetConfigRequestVer13 getConfigRequestVer13 = new OFGetConfigRequestVer13(xid);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)getConfigRequestVer13);
            }
            return getConfigRequestVer13;
        }
    }

    static class Builder
    implements OFGetConfigRequest.Builder {
        private boolean xidSet;
        private long xid;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.GET_CONFIG_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFGetConfigRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFGetConfigRequest build() {
            long xid = this.xidSet ? this.xid : 0L;
            return new OFGetConfigRequestVer13(xid);
        }
    }

    static class BuilderWithParent
    implements OFGetConfigRequest.Builder {
        final OFGetConfigRequestVer13 parentMessage;
        private boolean xidSet;
        private long xid;

        BuilderWithParent(OFGetConfigRequestVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.GET_CONFIG_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFGetConfigRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFGetConfigRequest build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            return new OFGetConfigRequestVer13(xid);
        }
    }
}

