/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnPimPacketType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvPimPacketType;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnPimPacketTypeSerializerVer13;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvPimPacketTypeVer13
implements OFBsnTlvPimPacketType {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvPimPacketTypeVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 6;
    private final OFBsnPimPacketType value;
    static final Reader READER = new Reader();
    static final OFBsnTlvPimPacketTypeVer13Funnel FUNNEL = new OFBsnTlvPimPacketTypeVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvPimPacketTypeVer13(OFBsnPimPacketType value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvPimPacketTypeVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 170;
    }

    @Override
    public OFBsnPimPacketType getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvPimPacketType.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvPimPacketTypeVer13(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvPimPacketTypeVer13 other = (OFBsnTlvPimPacketTypeVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvPimPacketTypeVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvPimPacketTypeVer13 message) {
            bb.writeShort(170);
            bb.writeShort(6);
            OFBsnPimPacketTypeSerializerVer13.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvPimPacketTypeVer13Funnel
    implements Funnel<OFBsnTlvPimPacketTypeVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvPimPacketTypeVer13Funnel() {
        }

        public void funnel(OFBsnTlvPimPacketTypeVer13 message, PrimitiveSink sink) {
            sink.putShort((short)170);
            sink.putShort((short)6);
            OFBsnPimPacketTypeSerializerVer13.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvPimPacketType> {
        Reader() {
        }

        @Override
        public OFBsnTlvPimPacketType readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 170) {
                throw new OFParseError("Wrong type: Expected=0xaa(0xaa), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnPimPacketType value = OFBsnPimPacketTypeSerializerVer13.readFrom(bb);
            OFBsnTlvPimPacketTypeVer13 bsnTlvPimPacketTypeVer13 = new OFBsnTlvPimPacketTypeVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvPimPacketTypeVer13);
            }
            return bsnTlvPimPacketTypeVer13;
        }
    }

    static class Builder
    implements OFBsnTlvPimPacketType.Builder {
        private boolean valueSet;
        private OFBsnPimPacketType value;

        Builder() {
        }

        @Override
        public int getType() {
            return 170;
        }

        @Override
        public OFBsnPimPacketType getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvPimPacketType.Builder setValue(OFBsnPimPacketType value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvPimPacketType build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvPimPacketTypeVer13(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvPimPacketType.Builder {
        final OFBsnTlvPimPacketTypeVer13 parentMessage;
        private boolean valueSet;
        private OFBsnPimPacketType value;

        BuilderWithParent(OFBsnTlvPimPacketTypeVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 170;
        }

        @Override
        public OFBsnPimPacketType getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvPimPacketType.Builder setValue(OFBsnPimPacketType value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvPimPacketType build() {
            OFBsnPimPacketType value;
            OFBsnPimPacketType oFBsnPimPacketType = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvPimPacketTypeVer13(value);
        }
    }
}

