/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnLagFlag;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvLagOptions;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnLagFlagSerializerVer13;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvLagOptionsVer13
implements OFBsnTlvLagOptions {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvLagOptionsVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 6;
    private static final Set<OFBsnLagFlag> DEFAULT_FLAGS = ImmutableSet.of();
    private final Set<OFBsnLagFlag> flags;
    static final OFBsnTlvLagOptionsVer13 DEFAULT = new OFBsnTlvLagOptionsVer13(DEFAULT_FLAGS);
    static final Reader READER = new Reader();
    static final OFBsnTlvLagOptionsVer13Funnel FUNNEL = new OFBsnTlvLagOptionsVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvLagOptionsVer13(Set<OFBsnLagFlag> flags) {
        if (flags == null) {
            throw new NullPointerException("OFBsnTlvLagOptionsVer13: property flags cannot be null");
        }
        this.flags = flags;
    }

    @Override
    public int getType() {
        return 160;
    }

    @Override
    public Set<OFBsnLagFlag> getFlags() {
        return this.flags;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvLagOptions.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvLagOptionsVer13(");
        b.append("flags=").append(this.flags);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvLagOptionsVer13 other = (OFBsnTlvLagOptionsVer13)obj;
        return !(this.flags == null ? other.flags != null : !this.flags.equals(other.flags));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvLagOptionsVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvLagOptionsVer13 message) {
            bb.writeShort(160);
            bb.writeShort(6);
            OFBsnLagFlagSerializerVer13.writeTo(bb, message.flags);
        }
    }

    static class OFBsnTlvLagOptionsVer13Funnel
    implements Funnel<OFBsnTlvLagOptionsVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvLagOptionsVer13Funnel() {
        }

        public void funnel(OFBsnTlvLagOptionsVer13 message, PrimitiveSink sink) {
            sink.putShort((short)160);
            sink.putShort((short)6);
            OFBsnLagFlagSerializerVer13.putTo(message.flags, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvLagOptions> {
        Reader() {
        }

        @Override
        public OFBsnTlvLagOptions readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 160) {
                throw new OFParseError("Wrong type: Expected=0xa0(0xa0), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            Set<OFBsnLagFlag> flags = OFBsnLagFlagSerializerVer13.readFrom(bb);
            OFBsnTlvLagOptionsVer13 bsnTlvLagOptionsVer13 = new OFBsnTlvLagOptionsVer13(flags);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvLagOptionsVer13);
            }
            return bsnTlvLagOptionsVer13;
        }
    }

    static class Builder
    implements OFBsnTlvLagOptions.Builder {
        private boolean flagsSet;
        private Set<OFBsnLagFlag> flags;

        Builder() {
        }

        @Override
        public int getType() {
            return 160;
        }

        @Override
        public Set<OFBsnLagFlag> getFlags() {
            return this.flags;
        }

        @Override
        public OFBsnTlvLagOptions.Builder setFlags(Set<OFBsnLagFlag> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvLagOptions build() {
            Set<OFBsnLagFlag> flags;
            Set<OFBsnLagFlag> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            return new OFBsnTlvLagOptionsVer13(flags);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvLagOptions.Builder {
        final OFBsnTlvLagOptionsVer13 parentMessage;
        private boolean flagsSet;
        private Set<OFBsnLagFlag> flags;

        BuilderWithParent(OFBsnTlvLagOptionsVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 160;
        }

        @Override
        public Set<OFBsnLagFlag> getFlags() {
            return this.flags;
        }

        @Override
        public OFBsnTlvLagOptions.Builder setFlags(Set<OFBsnLagFlag> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvLagOptions build() {
            Set flags;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            return new OFBsnTlvLagOptionsVer13(flags);
        }
    }
}

