/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvEthType;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvEthTypeVer13
implements OFBsnTlvEthType {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvEthTypeVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 6;
    private static final int DEFAULT_VALUE = 0;
    private final int value;
    static final OFBsnTlvEthTypeVer13 DEFAULT = new OFBsnTlvEthTypeVer13(0);
    static final Reader READER = new Reader();
    static final OFBsnTlvEthTypeVer13Funnel FUNNEL = new OFBsnTlvEthTypeVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvEthTypeVer13(int value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 131;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvEthType.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvEthTypeVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvEthTypeVer13 other = (OFBsnTlvEthTypeVer13)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvEthTypeVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvEthTypeVer13 message) {
            bb.writeShort(131);
            bb.writeShort(6);
            bb.writeShort((int)U16.t(message.value));
        }
    }

    static class OFBsnTlvEthTypeVer13Funnel
    implements Funnel<OFBsnTlvEthTypeVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvEthTypeVer13Funnel() {
        }

        public void funnel(OFBsnTlvEthTypeVer13 message, PrimitiveSink sink) {
            sink.putShort((short)131);
            sink.putShort((short)6);
            sink.putInt(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvEthType> {
        Reader() {
        }

        @Override
        public OFBsnTlvEthType readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 131) {
                throw new OFParseError("Wrong type: Expected=0x83(0x83), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            int value = U16.f(bb.readShort());
            OFBsnTlvEthTypeVer13 bsnTlvEthTypeVer13 = new OFBsnTlvEthTypeVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvEthTypeVer13);
            }
            return bsnTlvEthTypeVer13;
        }
    }

    static class Builder
    implements OFBsnTlvEthType.Builder {
        private boolean valueSet;
        private int value;

        Builder() {
        }

        @Override
        public int getType() {
            return 131;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvEthType.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvEthType build() {
            int value = this.valueSet ? this.value : 0;
            return new OFBsnTlvEthTypeVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvEthType.Builder {
        final OFBsnTlvEthTypeVer13 parentMessage;
        private boolean valueSet;
        private int value;

        BuilderWithParent(OFBsnTlvEthTypeVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 131;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvEthType.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvEthType build() {
            int value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvEthTypeVer13(value);
        }
    }
}

