/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnSetAuxCxnsReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnSetAuxCxnsReplyVer13
implements OFBsnSetAuxCxnsReply {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnSetAuxCxnsReplyVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 24;
    private static final long DEFAULT_XID = 0L;
    private static final long DEFAULT_NUM_AUX = 0L;
    private static final long DEFAULT_STATUS = 0L;
    private final long xid;
    private final long numAux;
    private final long status;
    static final OFBsnSetAuxCxnsReplyVer13 DEFAULT = new OFBsnSetAuxCxnsReplyVer13(0L, 0L, 0L);
    static final Reader READER = new Reader();
    static final OFBsnSetAuxCxnsReplyVer13Funnel FUNNEL = new OFBsnSetAuxCxnsReplyVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnSetAuxCxnsReplyVer13(long xid, long numAux, long status) {
        this.xid = xid;
        this.numAux = numAux;
        this.status = status;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 59L;
    }

    @Override
    public long getNumAux() {
        return this.numAux;
    }

    @Override
    public long getStatus() {
        return this.status;
    }

    @Override
    public OFBsnSetAuxCxnsReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnSetAuxCxnsReplyVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("numAux=").append(this.numAux);
        b.append(", ");
        b.append("status=").append(this.status);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnSetAuxCxnsReplyVer13 other = (OFBsnSetAuxCxnsReplyVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.numAux != other.numAux) {
            return false;
        }
        return this.status == other.status;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnSetAuxCxnsReplyVer13 other = (OFBsnSetAuxCxnsReplyVer13)obj;
        if (this.numAux != other.numAux) {
            return false;
        }
        return this.status == other.status;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * (int)(this.numAux ^ this.numAux >>> 32);
        result = 31 * (int)(this.status ^ this.status >>> 32);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.numAux ^ this.numAux >>> 32);
        result = 31 * (int)(this.status ^ this.status >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnSetAuxCxnsReplyVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnSetAuxCxnsReplyVer13 message) {
            bb.writeByte(4);
            bb.writeByte(4);
            bb.writeShort(24);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(59);
            bb.writeInt(U32.t(message.numAux));
            bb.writeInt(U32.t(message.status));
        }
    }

    static class OFBsnSetAuxCxnsReplyVer13Funnel
    implements Funnel<OFBsnSetAuxCxnsReplyVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnSetAuxCxnsReplyVer13Funnel() {
        }

        public void funnel(OFBsnSetAuxCxnsReplyVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)4);
            sink.putShort((short)24);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(59);
            sink.putLong(message.numAux);
            sink.putLong(message.status);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnSetAuxCxnsReply> {
        Reader() {
        }

        @Override
        public OFBsnSetAuxCxnsReply readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 24) {
                throw new OFParseError("Wrong length: Expected=24(24), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 59) {
                throw new OFParseError("Wrong subtype: Expected=0x3bL(0x3bL), got=" + subtype);
            }
            long numAux = U32.f(bb.readInt());
            long status = U32.f(bb.readInt());
            OFBsnSetAuxCxnsReplyVer13 bsnSetAuxCxnsReplyVer13 = new OFBsnSetAuxCxnsReplyVer13(xid, numAux, status);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnSetAuxCxnsReplyVer13);
            }
            return bsnSetAuxCxnsReplyVer13;
        }
    }

    static class Builder
    implements OFBsnSetAuxCxnsReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean numAuxSet;
        private long numAux;
        private boolean statusSet;
        private long status;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnSetAuxCxnsReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 59L;
        }

        @Override
        public long getNumAux() {
            return this.numAux;
        }

        @Override
        public OFBsnSetAuxCxnsReply.Builder setNumAux(long numAux) {
            this.numAux = numAux;
            this.numAuxSet = true;
            return this;
        }

        @Override
        public long getStatus() {
            return this.status;
        }

        @Override
        public OFBsnSetAuxCxnsReply.Builder setStatus(long status) {
            this.status = status;
            this.statusSet = true;
            return this;
        }

        @Override
        public OFBsnSetAuxCxnsReply build() {
            long xid = this.xidSet ? this.xid : 0L;
            long numAux = this.numAuxSet ? this.numAux : 0L;
            long status = this.statusSet ? this.status : 0L;
            return new OFBsnSetAuxCxnsReplyVer13(xid, numAux, status);
        }
    }

    static class BuilderWithParent
    implements OFBsnSetAuxCxnsReply.Builder {
        final OFBsnSetAuxCxnsReplyVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean numAuxSet;
        private long numAux;
        private boolean statusSet;
        private long status;

        BuilderWithParent(OFBsnSetAuxCxnsReplyVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnSetAuxCxnsReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 59L;
        }

        @Override
        public long getNumAux() {
            return this.numAux;
        }

        @Override
        public OFBsnSetAuxCxnsReply.Builder setNumAux(long numAux) {
            this.numAux = numAux;
            this.numAuxSet = true;
            return this;
        }

        @Override
        public long getStatus() {
            return this.status;
        }

        @Override
        public OFBsnSetAuxCxnsReply.Builder setStatus(long status) {
            this.status = status;
            this.statusSet = true;
            return this;
        }

        @Override
        public OFBsnSetAuxCxnsReply build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            long numAux = this.numAuxSet ? this.numAux : this.parentMessage.numAux;
            long status = this.statusSet ? this.status : this.parentMessage.status;
            return new OFBsnSetAuxCxnsReplyVer13(xid, numAux, status);
        }
    }
}

