/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnControllerRoleReason;
import org.projectfloodlight.openflow.protocol.OFBsnRoleStatus;
import org.projectfloodlight.openflow.protocol.OFControllerRole;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnControllerRoleReasonSerializerVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFControllerRoleSerializerVer13;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnRoleStatusVer13
implements OFBsnRoleStatus {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnRoleStatusVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 32;
    private static final long DEFAULT_XID = 0L;
    private static final U64 DEFAULT_GENERATION_ID = U64.ZERO;
    private final long xid;
    private final OFControllerRole role;
    private final OFBsnControllerRoleReason reason;
    private final U64 generationId;
    static final Reader READER = new Reader();
    static final OFBsnRoleStatusVer13Funnel FUNNEL = new OFBsnRoleStatusVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnRoleStatusVer13(long xid, OFControllerRole role, OFBsnControllerRoleReason reason, U64 generationId) {
        if (role == null) {
            throw new NullPointerException("OFBsnRoleStatusVer13: property role cannot be null");
        }
        if (reason == null) {
            throw new NullPointerException("OFBsnRoleStatusVer13: property reason cannot be null");
        }
        if (generationId == null) {
            throw new NullPointerException("OFBsnRoleStatusVer13: property generationId cannot be null");
        }
        this.xid = xid;
        this.role = role;
        this.reason = reason;
        this.generationId = generationId;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 55L;
    }

    @Override
    public OFControllerRole getRole() {
        return this.role;
    }

    @Override
    public OFBsnControllerRoleReason getReason() {
        return this.reason;
    }

    @Override
    public U64 getGenerationId() {
        return this.generationId;
    }

    @Override
    public OFBsnRoleStatus.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnRoleStatusVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("role=").append((Object)this.role);
        b.append(", ");
        b.append("reason=").append((Object)this.reason);
        b.append(", ");
        b.append("generationId=").append(this.generationId);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnRoleStatusVer13 other = (OFBsnRoleStatusVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.role == null ? other.role != null : !this.role.equals((Object)other.role)) {
            return false;
        }
        if (this.reason == null ? other.reason != null : !this.reason.equals((Object)other.reason)) {
            return false;
        }
        return !(this.generationId == null ? other.generationId != null : !this.generationId.equals(other.generationId));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnRoleStatusVer13 other = (OFBsnRoleStatusVer13)obj;
        if (this.role == null ? other.role != null : !this.role.equals((Object)other.role)) {
            return false;
        }
        if (this.reason == null ? other.reason != null : !this.reason.equals((Object)other.reason)) {
            return false;
        }
        return !(this.generationId == null ? other.generationId != null : !this.generationId.equals(other.generationId));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
        result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 31 * result + (this.generationId == null ? 0 : this.generationId.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
        result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 31 * result + (this.generationId == null ? 0 : this.generationId.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnRoleStatusVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnRoleStatusVer13 message) {
            bb.writeByte(4);
            bb.writeByte(4);
            bb.writeShort(32);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(55);
            OFControllerRoleSerializerVer13.writeTo(bb, message.role);
            OFBsnControllerRoleReasonSerializerVer13.writeTo(bb, message.reason);
            bb.writeZero(3);
            bb.writeLong(message.generationId.getValue());
        }
    }

    static class OFBsnRoleStatusVer13Funnel
    implements Funnel<OFBsnRoleStatusVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnRoleStatusVer13Funnel() {
        }

        public void funnel(OFBsnRoleStatusVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)4);
            sink.putShort((short)32);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(55);
            OFControllerRoleSerializerVer13.putTo(message.role, sink);
            OFBsnControllerRoleReasonSerializerVer13.putTo(message.reason, sink);
            message.generationId.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnRoleStatus> {
        Reader() {
        }

        @Override
        public OFBsnRoleStatus readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 32) {
                throw new OFParseError("Wrong length: Expected=32(32), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 55) {
                throw new OFParseError("Wrong subtype: Expected=0x37L(0x37L), got=" + subtype);
            }
            OFControllerRole role = OFControllerRoleSerializerVer13.readFrom(bb);
            OFBsnControllerRoleReason reason = OFBsnControllerRoleReasonSerializerVer13.readFrom(bb);
            bb.skipBytes(3);
            U64 generationId = U64.ofRaw(bb.readLong());
            OFBsnRoleStatusVer13 bsnRoleStatusVer13 = new OFBsnRoleStatusVer13(xid, role, reason, generationId);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnRoleStatusVer13);
            }
            return bsnRoleStatusVer13;
        }
    }

    static class Builder
    implements OFBsnRoleStatus.Builder {
        private boolean xidSet;
        private long xid;
        private boolean roleSet;
        private OFControllerRole role;
        private boolean reasonSet;
        private OFBsnControllerRoleReason reason;
        private boolean generationIdSet;
        private U64 generationId;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnRoleStatus.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 55L;
        }

        @Override
        public OFControllerRole getRole() {
            return this.role;
        }

        @Override
        public OFBsnRoleStatus.Builder setRole(OFControllerRole role) {
            this.role = role;
            this.roleSet = true;
            return this;
        }

        @Override
        public OFBsnControllerRoleReason getReason() {
            return this.reason;
        }

        @Override
        public OFBsnRoleStatus.Builder setReason(OFBsnControllerRoleReason reason) {
            this.reason = reason;
            this.reasonSet = true;
            return this;
        }

        @Override
        public U64 getGenerationId() {
            return this.generationId;
        }

        @Override
        public OFBsnRoleStatus.Builder setGenerationId(U64 generationId) {
            this.generationId = generationId;
            this.generationIdSet = true;
            return this;
        }

        @Override
        public OFBsnRoleStatus build() {
            U64 generationId;
            long xid;
            long l = xid = this.xidSet ? this.xid : 0L;
            if (!this.roleSet) {
                throw new IllegalStateException("Property role doesn't have default value -- must be set");
            }
            if (this.role == null) {
                throw new NullPointerException("Property role must not be null");
            }
            if (!this.reasonSet) {
                throw new IllegalStateException("Property reason doesn't have default value -- must be set");
            }
            if (this.reason == null) {
                throw new NullPointerException("Property reason must not be null");
            }
            U64 u64 = generationId = this.generationIdSet ? this.generationId : DEFAULT_GENERATION_ID;
            if (generationId == null) {
                throw new NullPointerException("Property generationId must not be null");
            }
            return new OFBsnRoleStatusVer13(xid, this.role, this.reason, generationId);
        }
    }

    static class BuilderWithParent
    implements OFBsnRoleStatus.Builder {
        final OFBsnRoleStatusVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean roleSet;
        private OFControllerRole role;
        private boolean reasonSet;
        private OFBsnControllerRoleReason reason;
        private boolean generationIdSet;
        private U64 generationId;

        BuilderWithParent(OFBsnRoleStatusVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnRoleStatus.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 55L;
        }

        @Override
        public OFControllerRole getRole() {
            return this.role;
        }

        @Override
        public OFBsnRoleStatus.Builder setRole(OFControllerRole role) {
            this.role = role;
            this.roleSet = true;
            return this;
        }

        @Override
        public OFBsnControllerRoleReason getReason() {
            return this.reason;
        }

        @Override
        public OFBsnRoleStatus.Builder setReason(OFBsnControllerRoleReason reason) {
            this.reason = reason;
            this.reasonSet = true;
            return this;
        }

        @Override
        public U64 getGenerationId() {
            return this.generationId;
        }

        @Override
        public OFBsnRoleStatus.Builder setGenerationId(U64 generationId) {
            this.generationId = generationId;
            this.generationIdSet = true;
            return this;
        }

        @Override
        public OFBsnRoleStatus build() {
            U64 generationId;
            OFBsnControllerRoleReason reason;
            OFControllerRole role;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            OFControllerRole oFControllerRole = role = this.roleSet ? this.role : this.parentMessage.role;
            if (role == null) {
                throw new NullPointerException("Property role must not be null");
            }
            OFBsnControllerRoleReason oFBsnControllerRoleReason = reason = this.reasonSet ? this.reason : this.parentMessage.reason;
            if (reason == null) {
                throw new NullPointerException("Property reason must not be null");
            }
            U64 u64 = generationId = this.generationIdSet ? this.generationId : this.parentMessage.generationId;
            if (generationId == null) {
                throw new NullPointerException("Property generationId must not be null");
            }
            return new OFBsnRoleStatusVer13(xid, role, reason, generationId);
        }
    }
}

