/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnPortCounterStatsRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFStatsRequestFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver13.OFStatsRequestFlagsSerializerVer13;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnPortCounterStatsRequestVer13
implements OFBsnPortCounterStatsRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnPortCounterStatsRequestVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 28;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsRequestFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final OFPort DEFAULT_PORT_NO = OFPort.ANY;
    private final long xid;
    private final Set<OFStatsRequestFlags> flags;
    private final OFPort portNo;
    static final OFBsnPortCounterStatsRequestVer13 DEFAULT = new OFBsnPortCounterStatsRequestVer13(0L, DEFAULT_FLAGS, DEFAULT_PORT_NO);
    static final Reader READER = new Reader();
    static final OFBsnPortCounterStatsRequestVer13Funnel FUNNEL = new OFBsnPortCounterStatsRequestVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnPortCounterStatsRequestVer13(long xid, Set<OFStatsRequestFlags> flags, OFPort portNo) {
        if (flags == null) {
            throw new NullPointerException("OFBsnPortCounterStatsRequestVer13: property flags cannot be null");
        }
        if (portNo == null) {
            throw new NullPointerException("OFBsnPortCounterStatsRequestVer13: property portNo cannot be null");
        }
        this.xid = xid;
        this.flags = flags;
        this.portNo = portNo;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REQUEST;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.EXPERIMENTER;
    }

    @Override
    public Set<OFStatsRequestFlags> getFlags() {
        return this.flags;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 8L;
    }

    @Override
    public OFPort getPortNo() {
        return this.portNo;
    }

    @Override
    public OFBsnPortCounterStatsRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnPortCounterStatsRequestVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("portNo=").append(this.portNo);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnPortCounterStatsRequestVer13 other = (OFBsnPortCounterStatsRequestVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return !(this.portNo == null ? other.portNo != null : !this.portNo.equals(other.portNo));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnPortCounterStatsRequestVer13 other = (OFBsnPortCounterStatsRequestVer13)obj;
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return !(this.portNo == null ? other.portNo != null : !this.portNo.equals(other.portNo));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.portNo == null ? 0 : this.portNo.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.portNo == null ? 0 : this.portNo.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnPortCounterStatsRequestVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnPortCounterStatsRequestVer13 message) {
            bb.writeByte(4);
            bb.writeByte(18);
            bb.writeShort(28);
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(-1);
            OFStatsRequestFlagsSerializerVer13.writeTo(bb, message.flags);
            bb.writeZero(4);
            bb.writeInt(6035143);
            bb.writeInt(8);
            message.portNo.write4Bytes(bb);
        }
    }

    static class OFBsnPortCounterStatsRequestVer13Funnel
    implements Funnel<OFBsnPortCounterStatsRequestVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnPortCounterStatsRequestVer13Funnel() {
        }

        public void funnel(OFBsnPortCounterStatsRequestVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)18);
            sink.putShort((short)28);
            sink.putLong(message.xid);
            sink.putShort((short)-1);
            OFStatsRequestFlagsSerializerVer13.putTo(message.flags, sink);
            sink.putInt(6035143);
            sink.putInt(8);
            message.portNo.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnPortCounterStatsRequest> {
        Reader() {
        }

        @Override
        public OFBsnPortCounterStatsRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 18) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REQUEST(18), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 28) {
                throw new OFParseError("Wrong length: Expected=28(28), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != -1) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.EXPERIMENTER(65535), got=" + statsType);
            }
            Set<OFStatsRequestFlags> flags = OFStatsRequestFlagsSerializerVer13.readFrom(bb);
            bb.skipBytes(4);
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 8) {
                throw new OFParseError("Wrong subtype: Expected=0x8L(0x8L), got=" + subtype);
            }
            OFPort portNo = OFPort.read4Bytes(bb);
            OFBsnPortCounterStatsRequestVer13 bsnPortCounterStatsRequestVer13 = new OFBsnPortCounterStatsRequestVer13(xid, flags, portNo);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnPortCounterStatsRequestVer13);
            }
            return bsnPortCounterStatsRequestVer13;
        }
    }

    static class Builder
    implements OFBsnPortCounterStatsRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;
        private boolean portNoSet;
        private OFPort portNo;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnPortCounterStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.EXPERIMENTER;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBsnPortCounterStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 8L;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFBsnPortCounterStatsRequest.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public OFBsnPortCounterStatsRequest build() {
            OFPort portNo;
            Set<OFStatsRequestFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsRequestFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : DEFAULT_PORT_NO;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            return new OFBsnPortCounterStatsRequestVer13(xid, flags, portNo);
        }
    }

    static class BuilderWithParent
    implements OFBsnPortCounterStatsRequest.Builder {
        final OFBsnPortCounterStatsRequestVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;
        private boolean portNoSet;
        private OFPort portNo;

        BuilderWithParent(OFBsnPortCounterStatsRequestVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnPortCounterStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.EXPERIMENTER;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBsnPortCounterStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 8L;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFBsnPortCounterStatsRequest.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public OFBsnPortCounterStatsRequest build() {
            OFPort portNo;
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : this.parentMessage.portNo;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            return new OFBsnPortCounterStatsRequestVer13(xid, flags, portNo);
        }
    }
}

