/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnGenericStatsRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFStatsRequestFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlv;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnTlvVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFStatsRequestFlagsSerializerVer13;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnGenericStatsRequestVer13
implements OFBsnGenericStatsRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnGenericStatsRequestVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 88;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsRequestFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final String DEFAULT_NAME = "";
    private static final List<OFBsnTlv> DEFAULT_TLVS = ImmutableList.of();
    private final long xid;
    private final Set<OFStatsRequestFlags> flags;
    private final String name;
    private final List<OFBsnTlv> tlvs;
    static final OFBsnGenericStatsRequestVer13 DEFAULT = new OFBsnGenericStatsRequestVer13(0L, DEFAULT_FLAGS, "", DEFAULT_TLVS);
    static final Reader READER = new Reader();
    static final OFBsnGenericStatsRequestVer13Funnel FUNNEL = new OFBsnGenericStatsRequestVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnGenericStatsRequestVer13(long xid, Set<OFStatsRequestFlags> flags, String name, List<OFBsnTlv> tlvs) {
        if (flags == null) {
            throw new NullPointerException("OFBsnGenericStatsRequestVer13: property flags cannot be null");
        }
        if (name == null) {
            throw new NullPointerException("OFBsnGenericStatsRequestVer13: property name cannot be null");
        }
        if (tlvs == null) {
            throw new NullPointerException("OFBsnGenericStatsRequestVer13: property tlvs cannot be null");
        }
        this.xid = xid;
        this.flags = flags;
        this.name = name;
        this.tlvs = tlvs;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REQUEST;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.EXPERIMENTER;
    }

    @Override
    public Set<OFStatsRequestFlags> getFlags() {
        return this.flags;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 16L;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<OFBsnTlv> getTlvs() {
        return this.tlvs;
    }

    @Override
    public OFBsnGenericStatsRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnGenericStatsRequestVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("name=").append(this.name);
        b.append(", ");
        b.append("tlvs=").append(this.tlvs);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGenericStatsRequestVer13 other = (OFBsnGenericStatsRequestVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.tlvs == null ? other.tlvs != null : !this.tlvs.equals(other.tlvs));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGenericStatsRequestVer13 other = (OFBsnGenericStatsRequestVer13)obj;
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.tlvs == null ? other.tlvs != null : !this.tlvs.equals(other.tlvs));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.tlvs == null ? 0 : this.tlvs.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.tlvs == null ? 0 : this.tlvs.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnGenericStatsRequestVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnGenericStatsRequestVer13 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(4);
            bb.writeByte(18);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(-1);
            OFStatsRequestFlagsSerializerVer13.writeTo(bb, message.flags);
            bb.writeZero(4);
            bb.writeInt(6035143);
            bb.writeInt(16);
            ChannelUtils.writeFixedLengthString(bb, message.name, 64);
            ChannelUtils.writeList(bb, message.tlvs);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBsnGenericStatsRequestVer13Funnel
    implements Funnel<OFBsnGenericStatsRequestVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnGenericStatsRequestVer13Funnel() {
        }

        public void funnel(OFBsnGenericStatsRequestVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)18);
            sink.putLong(message.xid);
            sink.putShort((short)-1);
            OFStatsRequestFlagsSerializerVer13.putTo(message.flags, sink);
            sink.putInt(6035143);
            sink.putInt(16);
            sink.putUnencodedChars((CharSequence)message.name);
            FunnelUtils.putList(message.tlvs, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnGenericStatsRequest> {
        Reader() {
        }

        @Override
        public OFBsnGenericStatsRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 18) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REQUEST(18), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 88) {
                throw new OFParseError("Wrong length: Expected to be >= 88, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != -1) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.EXPERIMENTER(65535), got=" + statsType);
            }
            Set<OFStatsRequestFlags> flags = OFStatsRequestFlagsSerializerVer13.readFrom(bb);
            bb.skipBytes(4);
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 16) {
                throw new OFParseError("Wrong subtype: Expected=0x10L(0x10L), got=" + subtype);
            }
            String name = ChannelUtils.readFixedLengthString(bb, 64);
            List<OFBsnTlv> tlvs = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFBsnTlvVer13.READER);
            OFBsnGenericStatsRequestVer13 bsnGenericStatsRequestVer13 = new OFBsnGenericStatsRequestVer13(xid, flags, name, tlvs);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnGenericStatsRequestVer13);
            }
            return bsnGenericStatsRequestVer13;
        }
    }

    static class Builder
    implements OFBsnGenericStatsRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;
        private boolean nameSet;
        private String name;
        private boolean tlvsSet;
        private List<OFBsnTlv> tlvs;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnGenericStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.EXPERIMENTER;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBsnGenericStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 16L;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public OFBsnGenericStatsRequest.Builder setName(String name) {
            this.name = name;
            this.nameSet = true;
            return this;
        }

        @Override
        public List<OFBsnTlv> getTlvs() {
            return this.tlvs;
        }

        @Override
        public OFBsnGenericStatsRequest.Builder setTlvs(List<OFBsnTlv> tlvs) {
            this.tlvs = tlvs;
            this.tlvsSet = true;
            return this;
        }

        @Override
        public OFBsnGenericStatsRequest build() {
            List<OFBsnTlv> tlvs;
            String name;
            Set<OFStatsRequestFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsRequestFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            String string = name = this.nameSet ? this.name : OFBsnGenericStatsRequestVer13.DEFAULT_NAME;
            if (name == null) {
                throw new NullPointerException("Property name must not be null");
            }
            List<OFBsnTlv> list = tlvs = this.tlvsSet ? this.tlvs : DEFAULT_TLVS;
            if (tlvs == null) {
                throw new NullPointerException("Property tlvs must not be null");
            }
            return new OFBsnGenericStatsRequestVer13(xid, flags, name, tlvs);
        }
    }

    static class BuilderWithParent
    implements OFBsnGenericStatsRequest.Builder {
        final OFBsnGenericStatsRequestVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;
        private boolean nameSet;
        private String name;
        private boolean tlvsSet;
        private List<OFBsnTlv> tlvs;

        BuilderWithParent(OFBsnGenericStatsRequestVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnGenericStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.EXPERIMENTER;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBsnGenericStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 16L;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public OFBsnGenericStatsRequest.Builder setName(String name) {
            this.name = name;
            this.nameSet = true;
            return this;
        }

        @Override
        public List<OFBsnTlv> getTlvs() {
            return this.tlvs;
        }

        @Override
        public OFBsnGenericStatsRequest.Builder setTlvs(List<OFBsnTlv> tlvs) {
            this.tlvs = tlvs;
            this.tlvsSet = true;
            return this;
        }

        @Override
        public OFBsnGenericStatsRequest build() {
            List tlvs;
            String name;
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            String string = name = this.nameSet ? this.name : this.parentMessage.name;
            if (name == null) {
                throw new NullPointerException("Property name must not be null");
            }
            List list = tlvs = this.tlvsSet ? this.tlvs : this.parentMessage.tlvs;
            if (tlvs == null) {
                throw new NullPointerException("Property tlvs must not be null");
            }
            return new OFBsnGenericStatsRequestVer13(xid, flags, name, tlvs);
        }
    }
}

