/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFAsyncConfigProp;
import org.projectfloodlight.openflow.protocol.OFAsyncGetRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFAsyncGetRequestVer13
implements OFAsyncGetRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFAsyncGetRequestVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 32;
    private static final long DEFAULT_XID = 0L;
    private static final long DEFAULT_PACKET_IN_MASK_EQUAL_MASTER = 0L;
    private static final long DEFAULT_PACKET_IN_MASK_SLAVE = 0L;
    private static final long DEFAULT_PORT_STATUS_MASK_EQUAL_MASTER = 0L;
    private static final long DEFAULT_PORT_STATUS_MASK_SLAVE = 0L;
    private static final long DEFAULT_FLOW_REMOVED_MASK_EQUAL_MASTER = 0L;
    private static final long DEFAULT_FLOW_REMOVED_MASK_SLAVE = 0L;
    private final long xid;
    private final long packetInMaskEqualMaster;
    private final long packetInMaskSlave;
    private final long portStatusMaskEqualMaster;
    private final long portStatusMaskSlave;
    private final long flowRemovedMaskEqualMaster;
    private final long flowRemovedMaskSlave;
    static final OFAsyncGetRequestVer13 DEFAULT = new OFAsyncGetRequestVer13(0L, 0L, 0L, 0L, 0L, 0L, 0L);
    static final Reader READER = new Reader();
    static final OFAsyncGetRequestVer13Funnel FUNNEL = new OFAsyncGetRequestVer13Funnel();
    static final Writer WRITER = new Writer();

    OFAsyncGetRequestVer13(long xid, long packetInMaskEqualMaster, long packetInMaskSlave, long portStatusMaskEqualMaster, long portStatusMaskSlave, long flowRemovedMaskEqualMaster, long flowRemovedMaskSlave) {
        this.xid = xid;
        this.packetInMaskEqualMaster = packetInMaskEqualMaster;
        this.packetInMaskSlave = packetInMaskSlave;
        this.portStatusMaskEqualMaster = portStatusMaskEqualMaster;
        this.portStatusMaskSlave = portStatusMaskSlave;
        this.flowRemovedMaskEqualMaster = flowRemovedMaskEqualMaster;
        this.flowRemovedMaskSlave = flowRemovedMaskSlave;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.GET_ASYNC_REQUEST;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getPacketInMaskEqualMaster() {
        return this.packetInMaskEqualMaster;
    }

    @Override
    public long getPacketInMaskSlave() {
        return this.packetInMaskSlave;
    }

    @Override
    public long getPortStatusMaskEqualMaster() {
        return this.portStatusMaskEqualMaster;
    }

    @Override
    public long getPortStatusMaskSlave() {
        return this.portStatusMaskSlave;
    }

    @Override
    public long getFlowRemovedMaskEqualMaster() {
        return this.flowRemovedMaskEqualMaster;
    }

    @Override
    public long getFlowRemovedMaskSlave() {
        return this.flowRemovedMaskSlave;
    }

    @Override
    public List<OFAsyncConfigProp> getProperties() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property properties not supported in version 1.3");
    }

    @Override
    public OFAsyncGetRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFAsyncGetRequestVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("packetInMaskEqualMaster=").append(this.packetInMaskEqualMaster);
        b.append(", ");
        b.append("packetInMaskSlave=").append(this.packetInMaskSlave);
        b.append(", ");
        b.append("portStatusMaskEqualMaster=").append(this.portStatusMaskEqualMaster);
        b.append(", ");
        b.append("portStatusMaskSlave=").append(this.portStatusMaskSlave);
        b.append(", ");
        b.append("flowRemovedMaskEqualMaster=").append(this.flowRemovedMaskEqualMaster);
        b.append(", ");
        b.append("flowRemovedMaskSlave=").append(this.flowRemovedMaskSlave);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFAsyncGetRequestVer13 other = (OFAsyncGetRequestVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.packetInMaskEqualMaster != other.packetInMaskEqualMaster) {
            return false;
        }
        if (this.packetInMaskSlave != other.packetInMaskSlave) {
            return false;
        }
        if (this.portStatusMaskEqualMaster != other.portStatusMaskEqualMaster) {
            return false;
        }
        if (this.portStatusMaskSlave != other.portStatusMaskSlave) {
            return false;
        }
        if (this.flowRemovedMaskEqualMaster != other.flowRemovedMaskEqualMaster) {
            return false;
        }
        return this.flowRemovedMaskSlave == other.flowRemovedMaskSlave;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFAsyncGetRequestVer13 other = (OFAsyncGetRequestVer13)obj;
        if (this.packetInMaskEqualMaster != other.packetInMaskEqualMaster) {
            return false;
        }
        if (this.packetInMaskSlave != other.packetInMaskSlave) {
            return false;
        }
        if (this.portStatusMaskEqualMaster != other.portStatusMaskEqualMaster) {
            return false;
        }
        if (this.portStatusMaskSlave != other.portStatusMaskSlave) {
            return false;
        }
        if (this.flowRemovedMaskEqualMaster != other.flowRemovedMaskEqualMaster) {
            return false;
        }
        return this.flowRemovedMaskSlave == other.flowRemovedMaskSlave;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * (int)(this.packetInMaskEqualMaster ^ this.packetInMaskEqualMaster >>> 32);
        result = 31 * (int)(this.packetInMaskSlave ^ this.packetInMaskSlave >>> 32);
        result = 31 * (int)(this.portStatusMaskEqualMaster ^ this.portStatusMaskEqualMaster >>> 32);
        result = 31 * (int)(this.portStatusMaskSlave ^ this.portStatusMaskSlave >>> 32);
        result = 31 * (int)(this.flowRemovedMaskEqualMaster ^ this.flowRemovedMaskEqualMaster >>> 32);
        result = 31 * (int)(this.flowRemovedMaskSlave ^ this.flowRemovedMaskSlave >>> 32);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.packetInMaskEqualMaster ^ this.packetInMaskEqualMaster >>> 32);
        result = 31 * (int)(this.packetInMaskSlave ^ this.packetInMaskSlave >>> 32);
        result = 31 * (int)(this.portStatusMaskEqualMaster ^ this.portStatusMaskEqualMaster >>> 32);
        result = 31 * (int)(this.portStatusMaskSlave ^ this.portStatusMaskSlave >>> 32);
        result = 31 * (int)(this.flowRemovedMaskEqualMaster ^ this.flowRemovedMaskEqualMaster >>> 32);
        result = 31 * (int)(this.flowRemovedMaskSlave ^ this.flowRemovedMaskSlave >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFAsyncGetRequestVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFAsyncGetRequestVer13 message) {
            bb.writeByte(4);
            bb.writeByte(26);
            bb.writeShort(32);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(U32.t(message.packetInMaskEqualMaster));
            bb.writeInt(U32.t(message.packetInMaskSlave));
            bb.writeInt(U32.t(message.portStatusMaskEqualMaster));
            bb.writeInt(U32.t(message.portStatusMaskSlave));
            bb.writeInt(U32.t(message.flowRemovedMaskEqualMaster));
            bb.writeInt(U32.t(message.flowRemovedMaskSlave));
        }
    }

    static class OFAsyncGetRequestVer13Funnel
    implements Funnel<OFAsyncGetRequestVer13> {
        private static final long serialVersionUID = 1L;

        OFAsyncGetRequestVer13Funnel() {
        }

        public void funnel(OFAsyncGetRequestVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)26);
            sink.putShort((short)32);
            sink.putLong(message.xid);
            sink.putLong(message.packetInMaskEqualMaster);
            sink.putLong(message.packetInMaskSlave);
            sink.putLong(message.portStatusMaskEqualMaster);
            sink.putLong(message.portStatusMaskSlave);
            sink.putLong(message.flowRemovedMaskEqualMaster);
            sink.putLong(message.flowRemovedMaskSlave);
        }
    }

    static class Reader
    implements OFMessageReader<OFAsyncGetRequest> {
        Reader() {
        }

        @Override
        public OFAsyncGetRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 26) {
                throw new OFParseError("Wrong type: Expected=OFType.GET_ASYNC_REQUEST(26), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 32) {
                throw new OFParseError("Wrong length: Expected=32(32), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            long packetInMaskEqualMaster = U32.f(bb.readInt());
            long packetInMaskSlave = U32.f(bb.readInt());
            long portStatusMaskEqualMaster = U32.f(bb.readInt());
            long portStatusMaskSlave = U32.f(bb.readInt());
            long flowRemovedMaskEqualMaster = U32.f(bb.readInt());
            long flowRemovedMaskSlave = U32.f(bb.readInt());
            OFAsyncGetRequestVer13 asyncGetRequestVer13 = new OFAsyncGetRequestVer13(xid, packetInMaskEqualMaster, packetInMaskSlave, portStatusMaskEqualMaster, portStatusMaskSlave, flowRemovedMaskEqualMaster, flowRemovedMaskSlave);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)asyncGetRequestVer13);
            }
            return asyncGetRequestVer13;
        }
    }

    static class Builder
    implements OFAsyncGetRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean packetInMaskEqualMasterSet;
        private long packetInMaskEqualMaster;
        private boolean packetInMaskSlaveSet;
        private long packetInMaskSlave;
        private boolean portStatusMaskEqualMasterSet;
        private long portStatusMaskEqualMaster;
        private boolean portStatusMaskSlaveSet;
        private long portStatusMaskSlave;
        private boolean flowRemovedMaskEqualMasterSet;
        private long flowRemovedMaskEqualMaster;
        private boolean flowRemovedMaskSlaveSet;
        private long flowRemovedMaskSlave;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.GET_ASYNC_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFAsyncGetRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getPacketInMaskEqualMaster() {
            return this.packetInMaskEqualMaster;
        }

        @Override
        public OFAsyncGetRequest.Builder setPacketInMaskEqualMaster(long packetInMaskEqualMaster) {
            this.packetInMaskEqualMaster = packetInMaskEqualMaster;
            this.packetInMaskEqualMasterSet = true;
            return this;
        }

        @Override
        public long getPacketInMaskSlave() {
            return this.packetInMaskSlave;
        }

        @Override
        public OFAsyncGetRequest.Builder setPacketInMaskSlave(long packetInMaskSlave) {
            this.packetInMaskSlave = packetInMaskSlave;
            this.packetInMaskSlaveSet = true;
            return this;
        }

        @Override
        public long getPortStatusMaskEqualMaster() {
            return this.portStatusMaskEqualMaster;
        }

        @Override
        public OFAsyncGetRequest.Builder setPortStatusMaskEqualMaster(long portStatusMaskEqualMaster) {
            this.portStatusMaskEqualMaster = portStatusMaskEqualMaster;
            this.portStatusMaskEqualMasterSet = true;
            return this;
        }

        @Override
        public long getPortStatusMaskSlave() {
            return this.portStatusMaskSlave;
        }

        @Override
        public OFAsyncGetRequest.Builder setPortStatusMaskSlave(long portStatusMaskSlave) {
            this.portStatusMaskSlave = portStatusMaskSlave;
            this.portStatusMaskSlaveSet = true;
            return this;
        }

        @Override
        public long getFlowRemovedMaskEqualMaster() {
            return this.flowRemovedMaskEqualMaster;
        }

        @Override
        public OFAsyncGetRequest.Builder setFlowRemovedMaskEqualMaster(long flowRemovedMaskEqualMaster) {
            this.flowRemovedMaskEqualMaster = flowRemovedMaskEqualMaster;
            this.flowRemovedMaskEqualMasterSet = true;
            return this;
        }

        @Override
        public long getFlowRemovedMaskSlave() {
            return this.flowRemovedMaskSlave;
        }

        @Override
        public OFAsyncGetRequest.Builder setFlowRemovedMaskSlave(long flowRemovedMaskSlave) {
            this.flowRemovedMaskSlave = flowRemovedMaskSlave;
            this.flowRemovedMaskSlaveSet = true;
            return this;
        }

        @Override
        public List<OFAsyncConfigProp> getProperties() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property properties not supported in version 1.3");
        }

        @Override
        public OFAsyncGetRequest.Builder setProperties(List<OFAsyncConfigProp> properties) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property properties not supported in version 1.3");
        }

        @Override
        public OFAsyncGetRequest build() {
            long xid = this.xidSet ? this.xid : 0L;
            long packetInMaskEqualMaster = this.packetInMaskEqualMasterSet ? this.packetInMaskEqualMaster : 0L;
            long packetInMaskSlave = this.packetInMaskSlaveSet ? this.packetInMaskSlave : 0L;
            long portStatusMaskEqualMaster = this.portStatusMaskEqualMasterSet ? this.portStatusMaskEqualMaster : 0L;
            long portStatusMaskSlave = this.portStatusMaskSlaveSet ? this.portStatusMaskSlave : 0L;
            long flowRemovedMaskEqualMaster = this.flowRemovedMaskEqualMasterSet ? this.flowRemovedMaskEqualMaster : 0L;
            long flowRemovedMaskSlave = this.flowRemovedMaskSlaveSet ? this.flowRemovedMaskSlave : 0L;
            return new OFAsyncGetRequestVer13(xid, packetInMaskEqualMaster, packetInMaskSlave, portStatusMaskEqualMaster, portStatusMaskSlave, flowRemovedMaskEqualMaster, flowRemovedMaskSlave);
        }
    }

    static class BuilderWithParent
    implements OFAsyncGetRequest.Builder {
        final OFAsyncGetRequestVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean packetInMaskEqualMasterSet;
        private long packetInMaskEqualMaster;
        private boolean packetInMaskSlaveSet;
        private long packetInMaskSlave;
        private boolean portStatusMaskEqualMasterSet;
        private long portStatusMaskEqualMaster;
        private boolean portStatusMaskSlaveSet;
        private long portStatusMaskSlave;
        private boolean flowRemovedMaskEqualMasterSet;
        private long flowRemovedMaskEqualMaster;
        private boolean flowRemovedMaskSlaveSet;
        private long flowRemovedMaskSlave;

        BuilderWithParent(OFAsyncGetRequestVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.GET_ASYNC_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFAsyncGetRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getPacketInMaskEqualMaster() {
            return this.packetInMaskEqualMaster;
        }

        @Override
        public OFAsyncGetRequest.Builder setPacketInMaskEqualMaster(long packetInMaskEqualMaster) {
            this.packetInMaskEqualMaster = packetInMaskEqualMaster;
            this.packetInMaskEqualMasterSet = true;
            return this;
        }

        @Override
        public long getPacketInMaskSlave() {
            return this.packetInMaskSlave;
        }

        @Override
        public OFAsyncGetRequest.Builder setPacketInMaskSlave(long packetInMaskSlave) {
            this.packetInMaskSlave = packetInMaskSlave;
            this.packetInMaskSlaveSet = true;
            return this;
        }

        @Override
        public long getPortStatusMaskEqualMaster() {
            return this.portStatusMaskEqualMaster;
        }

        @Override
        public OFAsyncGetRequest.Builder setPortStatusMaskEqualMaster(long portStatusMaskEqualMaster) {
            this.portStatusMaskEqualMaster = portStatusMaskEqualMaster;
            this.portStatusMaskEqualMasterSet = true;
            return this;
        }

        @Override
        public long getPortStatusMaskSlave() {
            return this.portStatusMaskSlave;
        }

        @Override
        public OFAsyncGetRequest.Builder setPortStatusMaskSlave(long portStatusMaskSlave) {
            this.portStatusMaskSlave = portStatusMaskSlave;
            this.portStatusMaskSlaveSet = true;
            return this;
        }

        @Override
        public long getFlowRemovedMaskEqualMaster() {
            return this.flowRemovedMaskEqualMaster;
        }

        @Override
        public OFAsyncGetRequest.Builder setFlowRemovedMaskEqualMaster(long flowRemovedMaskEqualMaster) {
            this.flowRemovedMaskEqualMaster = flowRemovedMaskEqualMaster;
            this.flowRemovedMaskEqualMasterSet = true;
            return this;
        }

        @Override
        public long getFlowRemovedMaskSlave() {
            return this.flowRemovedMaskSlave;
        }

        @Override
        public OFAsyncGetRequest.Builder setFlowRemovedMaskSlave(long flowRemovedMaskSlave) {
            this.flowRemovedMaskSlave = flowRemovedMaskSlave;
            this.flowRemovedMaskSlaveSet = true;
            return this;
        }

        @Override
        public List<OFAsyncConfigProp> getProperties() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property properties not supported in version 1.3");
        }

        @Override
        public OFAsyncGetRequest.Builder setProperties(List<OFAsyncConfigProp> properties) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property properties not supported in version 1.3");
        }

        @Override
        public OFAsyncGetRequest build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            long packetInMaskEqualMaster = this.packetInMaskEqualMasterSet ? this.packetInMaskEqualMaster : this.parentMessage.packetInMaskEqualMaster;
            long packetInMaskSlave = this.packetInMaskSlaveSet ? this.packetInMaskSlave : this.parentMessage.packetInMaskSlave;
            long portStatusMaskEqualMaster = this.portStatusMaskEqualMasterSet ? this.portStatusMaskEqualMaster : this.parentMessage.portStatusMaskEqualMaster;
            long portStatusMaskSlave = this.portStatusMaskSlaveSet ? this.portStatusMaskSlave : this.parentMessage.portStatusMaskSlave;
            long flowRemovedMaskEqualMaster = this.flowRemovedMaskEqualMasterSet ? this.flowRemovedMaskEqualMaster : this.parentMessage.flowRemovedMaskEqualMaster;
            long flowRemovedMaskSlave = this.flowRemovedMaskSlaveSet ? this.flowRemovedMaskSlave : this.parentMessage.flowRemovedMaskSlave;
            return new OFAsyncGetRequestVer13(xid, packetInMaskEqualMaster, packetInMaskSlave, portStatusMaskEqualMaster, portStatusMaskSlave, flowRemovedMaskEqualMaster, flowRemovedMaskSlave);
        }
    }
}

