/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmConnTrackingNwDst;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmConnTrackingNwDstVer12
implements OFOxmConnTrackingNwDst {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmConnTrackingNwDstVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 8;
    private static final U32 DEFAULT_VALUE = U32.ZERO;
    private final U32 value;
    static final OFOxmConnTrackingNwDstVer12 DEFAULT = new OFOxmConnTrackingNwDstVer12(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmConnTrackingNwDstVer12Funnel FUNNEL = new OFOxmConnTrackingNwDstVer12Funnel();
    static final Writer WRITER = new Writer();

    OFOxmConnTrackingNwDstVer12(U32 value) {
        if (value == null) {
            throw new NullPointerException("OFOxmConnTrackingNwDstVer12: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 127492L;
    }

    @Override
    public U32 getValue() {
        return this.value;
    }

    @Override
    public MatchField<U32> getMatchField() {
        return MatchField.CONN_TRACKING_NW_DST;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<U32> getCanonical() {
        return this;
    }

    @Override
    public U32 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.2");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFOxmConnTrackingNwDst.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmConnTrackingNwDstVer12(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmConnTrackingNwDstVer12 other = (OFOxmConnTrackingNwDstVer12)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmConnTrackingNwDstVer12> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmConnTrackingNwDstVer12 message) {
            bb.writeInt(127492);
            bb.writeInt(message.value.getRaw());
        }
    }

    static class OFOxmConnTrackingNwDstVer12Funnel
    implements Funnel<OFOxmConnTrackingNwDstVer12> {
        private static final long serialVersionUID = 1L;

        OFOxmConnTrackingNwDstVer12Funnel() {
        }

        public void funnel(OFOxmConnTrackingNwDstVer12 message, PrimitiveSink sink) {
            sink.putInt(127492);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmConnTrackingNwDst> {
        Reader() {
        }

        @Override
        public OFOxmConnTrackingNwDst readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 127492) {
                throw new OFParseError("Wrong typeLen: Expected=0x1f204L(0x1f204L), got=" + typeLen);
            }
            U32 value = U32.of(bb.readInt());
            OFOxmConnTrackingNwDstVer12 oxmConnTrackingNwDstVer12 = new OFOxmConnTrackingNwDstVer12(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmConnTrackingNwDstVer12);
            }
            return oxmConnTrackingNwDstVer12;
        }
    }

    static class Builder
    implements OFOxmConnTrackingNwDst.Builder {
        private boolean valueSet;
        private U32 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 127492L;
        }

        @Override
        public U32 getValue() {
            return this.value;
        }

        @Override
        public OFOxmConnTrackingNwDst.Builder setValue(U32 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U32> getMatchField() {
            return MatchField.CONN_TRACKING_NW_DST;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U32> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public U32 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmConnTrackingNwDst build() {
            U32 value;
            U32 u32 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmConnTrackingNwDstVer12(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmConnTrackingNwDst.Builder {
        final OFOxmConnTrackingNwDstVer12 parentMessage;
        private boolean valueSet;
        private U32 value;

        BuilderWithParent(OFOxmConnTrackingNwDstVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 127492L;
        }

        @Override
        public U32 getValue() {
            return this.value;
        }

        @Override
        public OFOxmConnTrackingNwDst.Builder setValue(U32 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U32> getMatchField() {
            return MatchField.CONN_TRACKING_NW_DST;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U32> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public U32 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmConnTrackingNwDst build() {
            U32 value;
            U32 u32 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmConnTrackingNwDstVer12(value);
        }
    }
}

