/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFGroupMod;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.ver12.OFGroupAddVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFGroupDeleteVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFGroupModifyVer12;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

abstract class OFGroupModVer12 {
    static final byte WIRE_VERSION = 3;
    static final int MINIMUM_LENGTH = 16;
    public static final Reader READER = new Reader();

    OFGroupModVer12() {
    }

    static class Reader
    implements OFMessageReader<OFGroupMod> {
        Reader() {
        }

        @Override
        public OFGroupMod readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 16) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 3) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_12(3), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 15) {
                throw new OFParseError("Wrong type: Expected=OFType.GROUP_MOD(15), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            U32.f(bb.readInt());
            short command = bb.readShort();
            bb.readerIndex(start);
            switch (command) {
                case 0: {
                    return OFGroupAddVer12.READER.readFrom(bb);
                }
                case 2: {
                    return OFGroupDeleteVer12.READER.readFrom(bb);
                }
                case 1: {
                    return OFGroupModifyVer12.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator command of class OFGroupModVer12: " + command);
        }
    }
}

