/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnPduRxReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnPduRxReplyVer12
implements OFBsnPduRxReply {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnPduRxReplyVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 25;
    private static final long DEFAULT_XID = 0L;
    private static final long DEFAULT_STATUS = 0L;
    private static final OFPort DEFAULT_PORT_NO = OFPort.ANY;
    private static final short DEFAULT_SLOT_NUM = 0;
    private final long xid;
    private final long status;
    private final OFPort portNo;
    private final short slotNum;
    static final OFBsnPduRxReplyVer12 DEFAULT = new OFBsnPduRxReplyVer12(0L, 0L, DEFAULT_PORT_NO, 0);
    static final Reader READER = new Reader();
    static final OFBsnPduRxReplyVer12Funnel FUNNEL = new OFBsnPduRxReplyVer12Funnel();
    static final Writer WRITER = new Writer();

    OFBsnPduRxReplyVer12(long xid, long status, OFPort portNo, short slotNum) {
        if (portNo == null) {
            throw new NullPointerException("OFBsnPduRxReplyVer12: property portNo cannot be null");
        }
        this.xid = xid;
        this.status = status;
        this.portNo = portNo;
        this.slotNum = slotNum;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 34L;
    }

    @Override
    public long getStatus() {
        return this.status;
    }

    @Override
    public OFPort getPortNo() {
        return this.portNo;
    }

    @Override
    public short getSlotNum() {
        return this.slotNum;
    }

    @Override
    public OFBsnPduRxReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnPduRxReplyVer12(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("status=").append(this.status);
        b.append(", ");
        b.append("portNo=").append(this.portNo);
        b.append(", ");
        b.append("slotNum=").append(this.slotNum);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnPduRxReplyVer12 other = (OFBsnPduRxReplyVer12)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.status != other.status) {
            return false;
        }
        if (this.portNo == null ? other.portNo != null : !this.portNo.equals(other.portNo)) {
            return false;
        }
        return this.slotNum == other.slotNum;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnPduRxReplyVer12 other = (OFBsnPduRxReplyVer12)obj;
        if (this.status != other.status) {
            return false;
        }
        if (this.portNo == null ? other.portNo != null : !this.portNo.equals(other.portNo)) {
            return false;
        }
        return this.slotNum == other.slotNum;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * (int)(this.status ^ this.status >>> 32);
        result = 31 * result + (this.portNo == null ? 0 : this.portNo.hashCode());
        result = 31 * result + this.slotNum;
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.status ^ this.status >>> 32);
        result = 31 * result + (this.portNo == null ? 0 : this.portNo.hashCode());
        result = 31 * result + this.slotNum;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnPduRxReplyVer12> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnPduRxReplyVer12 message) {
            bb.writeByte(3);
            bb.writeByte(4);
            bb.writeShort(25);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(34);
            bb.writeInt(U32.t(message.status));
            message.portNo.write4Bytes(bb);
            bb.writeByte((int)U8.t(message.slotNum));
        }
    }

    static class OFBsnPduRxReplyVer12Funnel
    implements Funnel<OFBsnPduRxReplyVer12> {
        private static final long serialVersionUID = 1L;

        OFBsnPduRxReplyVer12Funnel() {
        }

        public void funnel(OFBsnPduRxReplyVer12 message, PrimitiveSink sink) {
            sink.putByte((byte)3);
            sink.putByte((byte)4);
            sink.putShort((short)25);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(34);
            sink.putLong(message.status);
            message.portNo.putTo(sink);
            sink.putShort(message.slotNum);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnPduRxReply> {
        Reader() {
        }

        @Override
        public OFBsnPduRxReply readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 3) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_12(3), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 25) {
                throw new OFParseError("Wrong length: Expected=25(25), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 34) {
                throw new OFParseError("Wrong subtype: Expected=0x22L(0x22L), got=" + subtype);
            }
            long status = U32.f(bb.readInt());
            OFPort portNo = OFPort.read4Bytes(bb);
            short slotNum = U8.f(bb.readByte());
            OFBsnPduRxReplyVer12 bsnPduRxReplyVer12 = new OFBsnPduRxReplyVer12(xid, status, portNo, slotNum);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnPduRxReplyVer12);
            }
            return bsnPduRxReplyVer12;
        }
    }

    static class Builder
    implements OFBsnPduRxReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean statusSet;
        private long status;
        private boolean portNoSet;
        private OFPort portNo;
        private boolean slotNumSet;
        private short slotNum;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnPduRxReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 34L;
        }

        @Override
        public long getStatus() {
            return this.status;
        }

        @Override
        public OFBsnPduRxReply.Builder setStatus(long status) {
            this.status = status;
            this.statusSet = true;
            return this;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFBsnPduRxReply.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public short getSlotNum() {
            return this.slotNum;
        }

        @Override
        public OFBsnPduRxReply.Builder setSlotNum(short slotNum) {
            this.slotNum = slotNum;
            this.slotNumSet = true;
            return this;
        }

        @Override
        public OFBsnPduRxReply build() {
            OFPort portNo;
            long xid = this.xidSet ? this.xid : 0L;
            long status = this.statusSet ? this.status : 0L;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : DEFAULT_PORT_NO;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            short slotNum = this.slotNumSet ? this.slotNum : (short)0;
            return new OFBsnPduRxReplyVer12(xid, status, portNo, slotNum);
        }
    }

    static class BuilderWithParent
    implements OFBsnPduRxReply.Builder {
        final OFBsnPduRxReplyVer12 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean statusSet;
        private long status;
        private boolean portNoSet;
        private OFPort portNo;
        private boolean slotNumSet;
        private short slotNum;

        BuilderWithParent(OFBsnPduRxReplyVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnPduRxReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 34L;
        }

        @Override
        public long getStatus() {
            return this.status;
        }

        @Override
        public OFBsnPduRxReply.Builder setStatus(long status) {
            this.status = status;
            this.statusSet = true;
            return this;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFBsnPduRxReply.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public short getSlotNum() {
            return this.slotNum;
        }

        @Override
        public OFBsnPduRxReply.Builder setSlotNum(short slotNum) {
            this.slotNum = slotNum;
            this.slotNumSet = true;
            return this;
        }

        @Override
        public OFBsnPduRxReply build() {
            OFPort portNo;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            long status = this.statusSet ? this.status : this.parentMessage.status;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : this.parentMessage.portNo;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            short slotNum = this.slotNumSet ? this.slotNum : this.parentMessage.slotNum;
            return new OFBsnPduRxReplyVer12(xid, status, portNo, slotNum);
        }
    }
}

