/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFAggregateStatsReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFStatsReplyFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.stat.Stat;
import org.projectfloodlight.openflow.protocol.ver11.OFStatsReplyFlagsSerializerVer11;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFAggregateStatsReplyVer11
implements OFAggregateStatsReply {
    private static final Logger logger = LoggerFactory.getLogger(OFAggregateStatsReplyVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int LENGTH = 40;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsReplyFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final U64 DEFAULT_PACKET_COUNT = U64.ZERO;
    private static final U64 DEFAULT_BYTE_COUNT = U64.ZERO;
    private static final long DEFAULT_FLOW_COUNT = 0L;
    private final long xid;
    private final Set<OFStatsReplyFlags> flags;
    private final U64 packetCount;
    private final U64 byteCount;
    private final long flowCount;
    static final OFAggregateStatsReplyVer11 DEFAULT = new OFAggregateStatsReplyVer11(0L, DEFAULT_FLAGS, DEFAULT_PACKET_COUNT, DEFAULT_BYTE_COUNT, 0L);
    static final Reader READER = new Reader();
    static final OFAggregateStatsReplyVer11Funnel FUNNEL = new OFAggregateStatsReplyVer11Funnel();
    static final Writer WRITER = new Writer();

    OFAggregateStatsReplyVer11(long xid, Set<OFStatsReplyFlags> flags, U64 packetCount, U64 byteCount, long flowCount) {
        if (flags == null) {
            throw new NullPointerException("OFAggregateStatsReplyVer11: property flags cannot be null");
        }
        if (packetCount == null) {
            throw new NullPointerException("OFAggregateStatsReplyVer11: property packetCount cannot be null");
        }
        if (byteCount == null) {
            throw new NullPointerException("OFAggregateStatsReplyVer11: property byteCount cannot be null");
        }
        this.xid = xid;
        this.flags = flags;
        this.packetCount = packetCount;
        this.byteCount = byteCount;
        this.flowCount = flowCount;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REPLY;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.AGGREGATE;
    }

    @Override
    public Set<OFStatsReplyFlags> getFlags() {
        return this.flags;
    }

    @Override
    public U64 getPacketCount() {
        return this.packetCount;
    }

    @Override
    public U64 getByteCount() {
        return this.byteCount;
    }

    @Override
    public long getFlowCount() {
        return this.flowCount;
    }

    @Override
    public Stat getStats() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property stats not supported in version 1.1");
    }

    @Override
    public OFAggregateStatsReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFAggregateStatsReplyVer11(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("packetCount=").append(this.packetCount);
        b.append(", ");
        b.append("byteCount=").append(this.byteCount);
        b.append(", ");
        b.append("flowCount=").append(this.flowCount);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFAggregateStatsReplyVer11 other = (OFAggregateStatsReplyVer11)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        if (this.packetCount == null ? other.packetCount != null : !this.packetCount.equals(other.packetCount)) {
            return false;
        }
        if (this.byteCount == null ? other.byteCount != null : !this.byteCount.equals(other.byteCount)) {
            return false;
        }
        return this.flowCount == other.flowCount;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFAggregateStatsReplyVer11 other = (OFAggregateStatsReplyVer11)obj;
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        if (this.packetCount == null ? other.packetCount != null : !this.packetCount.equals(other.packetCount)) {
            return false;
        }
        if (this.byteCount == null ? other.byteCount != null : !this.byteCount.equals(other.byteCount)) {
            return false;
        }
        return this.flowCount == other.flowCount;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.packetCount == null ? 0 : this.packetCount.hashCode());
        result = 31 * result + (this.byteCount == null ? 0 : this.byteCount.hashCode());
        result = 31 * (int)(this.flowCount ^ this.flowCount >>> 32);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.packetCount == null ? 0 : this.packetCount.hashCode());
        result = 31 * result + (this.byteCount == null ? 0 : this.byteCount.hashCode());
        result = 31 * (int)(this.flowCount ^ this.flowCount >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFAggregateStatsReplyVer11> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFAggregateStatsReplyVer11 message) {
            bb.writeByte(2);
            bb.writeByte(19);
            bb.writeShort(40);
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(2);
            OFStatsReplyFlagsSerializerVer11.writeTo(bb, message.flags);
            bb.writeZero(4);
            bb.writeLong(message.packetCount.getValue());
            bb.writeLong(message.byteCount.getValue());
            bb.writeInt(U32.t(message.flowCount));
            bb.writeZero(4);
        }
    }

    static class OFAggregateStatsReplyVer11Funnel
    implements Funnel<OFAggregateStatsReplyVer11> {
        private static final long serialVersionUID = 1L;

        OFAggregateStatsReplyVer11Funnel() {
        }

        public void funnel(OFAggregateStatsReplyVer11 message, PrimitiveSink sink) {
            sink.putByte((byte)2);
            sink.putByte((byte)19);
            sink.putShort((short)40);
            sink.putLong(message.xid);
            sink.putShort((short)2);
            OFStatsReplyFlagsSerializerVer11.putTo(message.flags, sink);
            message.packetCount.putTo(sink);
            message.byteCount.putTo(sink);
            sink.putLong(message.flowCount);
        }
    }

    static class Reader
    implements OFMessageReader<OFAggregateStatsReply> {
        Reader() {
        }

        @Override
        public OFAggregateStatsReply readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 2) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_11(2), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 19) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REPLY(19), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 40) {
                throw new OFParseError("Wrong length: Expected=40(40), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != 2) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.AGGREGATE(2), got=" + statsType);
            }
            Set<OFStatsReplyFlags> flags = OFStatsReplyFlagsSerializerVer11.readFrom(bb);
            bb.skipBytes(4);
            U64 packetCount = U64.ofRaw(bb.readLong());
            U64 byteCount = U64.ofRaw(bb.readLong());
            long flowCount = U32.f(bb.readInt());
            bb.skipBytes(4);
            OFAggregateStatsReplyVer11 aggregateStatsReplyVer11 = new OFAggregateStatsReplyVer11(xid, flags, packetCount, byteCount, flowCount);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)aggregateStatsReplyVer11);
            }
            return aggregateStatsReplyVer11;
        }
    }

    static class Builder
    implements OFAggregateStatsReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsReplyFlags> flags;
        private boolean packetCountSet;
        private U64 packetCount;
        private boolean byteCountSet;
        private U64 byteCount;
        private boolean flowCountSet;
        private long flowCount;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFAggregateStatsReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.AGGREGATE;
        }

        @Override
        public Set<OFStatsReplyFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFAggregateStatsReply.Builder setFlags(Set<OFStatsReplyFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public U64 getPacketCount() {
            return this.packetCount;
        }

        @Override
        public OFAggregateStatsReply.Builder setPacketCount(U64 packetCount) {
            this.packetCount = packetCount;
            this.packetCountSet = true;
            return this;
        }

        @Override
        public U64 getByteCount() {
            return this.byteCount;
        }

        @Override
        public OFAggregateStatsReply.Builder setByteCount(U64 byteCount) {
            this.byteCount = byteCount;
            this.byteCountSet = true;
            return this;
        }

        @Override
        public long getFlowCount() {
            return this.flowCount;
        }

        @Override
        public OFAggregateStatsReply.Builder setFlowCount(long flowCount) {
            this.flowCount = flowCount;
            this.flowCountSet = true;
            return this;
        }

        @Override
        public Stat getStats() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property stats not supported in version 1.1");
        }

        @Override
        public OFAggregateStatsReply.Builder setStats(Stat stats) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property stats not supported in version 1.1");
        }

        @Override
        public OFAggregateStatsReply build() {
            U64 byteCount;
            U64 packetCount;
            Set<OFStatsReplyFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsReplyFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            U64 u64 = packetCount = this.packetCountSet ? this.packetCount : DEFAULT_PACKET_COUNT;
            if (packetCount == null) {
                throw new NullPointerException("Property packetCount must not be null");
            }
            U64 u642 = byteCount = this.byteCountSet ? this.byteCount : DEFAULT_BYTE_COUNT;
            if (byteCount == null) {
                throw new NullPointerException("Property byteCount must not be null");
            }
            long flowCount = this.flowCountSet ? this.flowCount : 0L;
            return new OFAggregateStatsReplyVer11(xid, flags, packetCount, byteCount, flowCount);
        }
    }

    static class BuilderWithParent
    implements OFAggregateStatsReply.Builder {
        final OFAggregateStatsReplyVer11 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsReplyFlags> flags;
        private boolean packetCountSet;
        private U64 packetCount;
        private boolean byteCountSet;
        private U64 byteCount;
        private boolean flowCountSet;
        private long flowCount;

        BuilderWithParent(OFAggregateStatsReplyVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REPLY;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFAggregateStatsReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.AGGREGATE;
        }

        @Override
        public Set<OFStatsReplyFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFAggregateStatsReply.Builder setFlags(Set<OFStatsReplyFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public U64 getPacketCount() {
            return this.packetCount;
        }

        @Override
        public OFAggregateStatsReply.Builder setPacketCount(U64 packetCount) {
            this.packetCount = packetCount;
            this.packetCountSet = true;
            return this;
        }

        @Override
        public U64 getByteCount() {
            return this.byteCount;
        }

        @Override
        public OFAggregateStatsReply.Builder setByteCount(U64 byteCount) {
            this.byteCount = byteCount;
            this.byteCountSet = true;
            return this;
        }

        @Override
        public long getFlowCount() {
            return this.flowCount;
        }

        @Override
        public OFAggregateStatsReply.Builder setFlowCount(long flowCount) {
            this.flowCount = flowCount;
            this.flowCountSet = true;
            return this;
        }

        @Override
        public Stat getStats() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property stats not supported in version 1.1");
        }

        @Override
        public OFAggregateStatsReply.Builder setStats(Stat stats) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property stats not supported in version 1.1");
        }

        @Override
        public OFAggregateStatsReply build() {
            U64 byteCount;
            U64 packetCount;
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            U64 u64 = packetCount = this.packetCountSet ? this.packetCount : this.parentMessage.packetCount;
            if (packetCount == null) {
                throw new NullPointerException("Property packetCount must not be null");
            }
            U64 u642 = byteCount = this.byteCountSet ? this.byteCount : this.parentMessage.byteCount;
            if (byteCount == null) {
                throw new NullPointerException("Property byteCount must not be null");
            }
            long flowCount = this.flowCountSet ? this.flowCount : this.parentMessage.flowCount;
            return new OFAggregateStatsReplyVer11(xid, flags, packetCount, byteCount, flowCount);
        }
    }
}

