/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionNiciraDecTtl;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionNiciraDecTtlVer11
implements OFActionNiciraDecTtl {
    private static final Logger logger = LoggerFactory.getLogger(OFActionNiciraDecTtlVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int LENGTH = 16;
    static final OFActionNiciraDecTtlVer11 DEFAULT = new OFActionNiciraDecTtlVer11();
    static final OFActionNiciraDecTtlVer11 INSTANCE = new OFActionNiciraDecTtlVer11();
    static final Reader READER = new Reader();
    static final OFActionNiciraDecTtlVer11Funnel FUNNEL = new OFActionNiciraDecTtlVer11Funnel();
    static final Writer WRITER = new Writer();

    private OFActionNiciraDecTtlVer11() {
    }

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 8992L;
    }

    @Override
    public int getSubtype() {
        return 18;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFActionNiciraDecTtl.Builder createBuilder() {
        throw new UnsupportedOperationException("OFActionNiciraDecTtlVer11 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionNiciraDecTtlVer11(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionNiciraDecTtlVer11> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionNiciraDecTtlVer11 message) {
            bb.writeShort(-1);
            bb.writeShort(16);
            bb.writeInt(8992);
            bb.writeShort(18);
            bb.writeZero(2);
            bb.writeZero(4);
        }
    }

    static class OFActionNiciraDecTtlVer11Funnel
    implements Funnel<OFActionNiciraDecTtlVer11> {
        private static final long serialVersionUID = 1L;

        OFActionNiciraDecTtlVer11Funnel() {
        }

        public void funnel(OFActionNiciraDecTtlVer11 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)16);
            sink.putInt(8992);
            sink.putShort((short)18);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionNiciraDecTtl> {
        Reader() {
        }

        @Override
        public OFActionNiciraDecTtl readFrom(ByteBuf bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 8992) {
                throw new OFParseError("Wrong experimenter: Expected=0x2320L(0x2320L), got=" + experimenter);
            }
            short subtype = bb.readShort();
            if (subtype != 18) {
                throw new OFParseError("Wrong subtype: Expected=0x12(0x12), got=" + subtype);
            }
            bb.skipBytes(2);
            bb.skipBytes(4);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

