/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPacketIn;
import org.projectfloodlight.openflow.protocol.OFPacketInReason;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.protocol.ver10.OFPacketInReasonSerializerVer10;
import org.projectfloodlight.openflow.types.OFBufferId;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPacketInVer10
implements OFPacketIn {
    private static final Logger logger = LoggerFactory.getLogger(OFPacketInVer10.class);
    static final byte WIRE_VERSION = 1;
    static final int MINIMUM_LENGTH = 18;
    private static final long DEFAULT_XID = 0L;
    private static final OFBufferId DEFAULT_BUFFER_ID = OFBufferId.NO_BUFFER;
    private static final int DEFAULT_TOTAL_LEN = 0;
    private static final OFPort DEFAULT_IN_PORT = OFPort.ANY;
    private static final byte[] DEFAULT_DATA = new byte[0];
    private final long xid;
    private final OFBufferId bufferId;
    private final int totalLen;
    private final OFPort inPort;
    private final OFPacketInReason reason;
    private final byte[] data;
    static final Reader READER = new Reader();
    static final OFPacketInVer10Funnel FUNNEL = new OFPacketInVer10Funnel();
    static final Writer WRITER = new Writer();

    OFPacketInVer10(long xid, OFBufferId bufferId, int totalLen, OFPort inPort, OFPacketInReason reason, byte[] data) {
        if (bufferId == null) {
            throw new NullPointerException("OFPacketInVer10: property bufferId cannot be null");
        }
        if (inPort == null) {
            throw new NullPointerException("OFPacketInVer10: property inPort cannot be null");
        }
        if (reason == null) {
            throw new NullPointerException("OFPacketInVer10: property reason cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("OFPacketInVer10: property data cannot be null");
        }
        this.xid = xid;
        this.bufferId = bufferId;
        this.totalLen = totalLen;
        this.inPort = inPort;
        this.reason = reason;
        this.data = data;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_10;
    }

    @Override
    public OFType getType() {
        return OFType.PACKET_IN;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFBufferId getBufferId() {
        return this.bufferId;
    }

    @Override
    public int getTotalLen() {
        return this.totalLen;
    }

    @Override
    public OFPacketInReason getReason() {
        return this.reason;
    }

    @Override
    public TableId getTableId() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property tableId not supported in version 1.0");
    }

    @Override
    public U64 getCookie() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property cookie not supported in version 1.0");
    }

    @Override
    public Match getMatch() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property match not supported in version 1.0");
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public OFPort getInPort() {
        return this.inPort;
    }

    @Override
    public OFPort getInPhyPort() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property inPhyPort not supported in version 1.0");
    }

    @Override
    public OFPacketIn.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPacketInVer10(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("bufferId=").append(this.bufferId);
        b.append(", ");
        b.append("totalLen=").append(this.totalLen);
        b.append(", ");
        b.append("inPort=").append(this.inPort);
        b.append(", ");
        b.append("reason=").append((Object)this.reason);
        b.append(", ");
        b.append("data=").append(Arrays.toString(this.data));
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPacketInVer10 other = (OFPacketInVer10)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.bufferId == null ? other.bufferId != null : !this.bufferId.equals(other.bufferId)) {
            return false;
        }
        if (this.totalLen != other.totalLen) {
            return false;
        }
        if (this.inPort == null ? other.inPort != null : !this.inPort.equals(other.inPort)) {
            return false;
        }
        if (this.reason == null ? other.reason != null : !this.reason.equals((Object)other.reason)) {
            return false;
        }
        return Arrays.equals(this.data, other.data);
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPacketInVer10 other = (OFPacketInVer10)obj;
        if (this.bufferId == null ? other.bufferId != null : !this.bufferId.equals(other.bufferId)) {
            return false;
        }
        if (this.totalLen != other.totalLen) {
            return false;
        }
        if (this.inPort == null ? other.inPort != null : !this.inPort.equals(other.inPort)) {
            return false;
        }
        if (this.reason == null ? other.reason != null : !this.reason.equals((Object)other.reason)) {
            return false;
        }
        return Arrays.equals(this.data, other.data);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.bufferId == null ? 0 : this.bufferId.hashCode());
        result = 31 * result + this.totalLen;
        result = 31 * result + (this.inPort == null ? 0 : this.inPort.hashCode());
        result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bufferId == null ? 0 : this.bufferId.hashCode());
        result = 31 * result + this.totalLen;
        result = 31 * result + (this.inPort == null ? 0 : this.inPort.hashCode());
        result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPacketInVer10> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFPacketInVer10 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(1);
            bb.writeByte(10);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(message.bufferId.getInt());
            bb.writeShort((int)U16.t(message.totalLen));
            message.inPort.write2Bytes(bb);
            OFPacketInReasonSerializerVer10.writeTo(bb, message.reason);
            bb.writeZero(1);
            bb.writeBytes(message.data);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFPacketInVer10Funnel
    implements Funnel<OFPacketInVer10> {
        private static final long serialVersionUID = 1L;

        OFPacketInVer10Funnel() {
        }

        public void funnel(OFPacketInVer10 message, PrimitiveSink sink) {
            sink.putByte((byte)1);
            sink.putByte((byte)10);
            sink.putLong(message.xid);
            message.bufferId.putTo(sink);
            sink.putInt(message.totalLen);
            message.inPort.putTo(sink);
            OFPacketInReasonSerializerVer10.putTo(message.reason, sink);
            sink.putBytes(message.data);
        }
    }

    static class Reader
    implements OFMessageReader<OFPacketIn> {
        Reader() {
        }

        @Override
        public OFPacketIn readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 1) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_10(1), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 10) {
                throw new OFParseError("Wrong type: Expected=OFType.PACKET_IN(10), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 18) {
                throw new OFParseError("Wrong length: Expected to be >= 18, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            OFBufferId bufferId = OFBufferId.of(bb.readInt());
            int totalLen = U16.f(bb.readShort());
            OFPort inPort = OFPort.read2Bytes(bb);
            OFPacketInReason reason = OFPacketInReasonSerializerVer10.readFrom(bb);
            bb.skipBytes(1);
            byte[] data = ChannelUtils.readBytes(bb, length - (bb.readerIndex() - start));
            OFPacketInVer10 packetInVer10 = new OFPacketInVer10(xid, bufferId, totalLen, inPort, reason, data);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)packetInVer10);
            }
            return packetInVer10;
        }
    }

    static class Builder
    implements OFPacketIn.Builder {
        private boolean xidSet;
        private long xid;
        private boolean bufferIdSet;
        private OFBufferId bufferId;
        private boolean totalLenSet;
        private int totalLen;
        private boolean inPortSet;
        private OFPort inPort;
        private boolean reasonSet;
        private OFPacketInReason reason;
        private boolean dataSet;
        private byte[] data;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFType getType() {
            return OFType.PACKET_IN;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFPacketIn.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFBufferId getBufferId() {
            return this.bufferId;
        }

        @Override
        public OFPacketIn.Builder setBufferId(OFBufferId bufferId) {
            this.bufferId = bufferId;
            this.bufferIdSet = true;
            return this;
        }

        @Override
        public int getTotalLen() {
            return this.totalLen;
        }

        @Override
        public OFPacketIn.Builder setTotalLen(int totalLen) {
            this.totalLen = totalLen;
            this.totalLenSet = true;
            return this;
        }

        @Override
        public OFPacketInReason getReason() {
            return this.reason;
        }

        @Override
        public OFPacketIn.Builder setReason(OFPacketInReason reason) {
            this.reason = reason;
            this.reasonSet = true;
            return this;
        }

        @Override
        public TableId getTableId() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property tableId not supported in version 1.0");
        }

        @Override
        public OFPacketIn.Builder setTableId(TableId tableId) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property tableId not supported in version 1.0");
        }

        @Override
        public U64 getCookie() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property cookie not supported in version 1.0");
        }

        @Override
        public OFPacketIn.Builder setCookie(U64 cookie) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property cookie not supported in version 1.0");
        }

        @Override
        public Match getMatch() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property match not supported in version 1.0");
        }

        @Override
        public OFPacketIn.Builder setMatch(Match match) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property match not supported in version 1.0");
        }

        @Override
        public byte[] getData() {
            return this.data;
        }

        @Override
        public OFPacketIn.Builder setData(byte[] data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFPort getInPort() {
            return this.inPort;
        }

        @Override
        public OFPacketIn.Builder setInPort(OFPort inPort) {
            this.inPort = inPort;
            this.inPortSet = true;
            return this;
        }

        @Override
        public OFPort getInPhyPort() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property inPhyPort not supported in version 1.0");
        }

        @Override
        public OFPacketIn.Builder setInPhyPort(OFPort inPhyPort) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property inPhyPort not supported in version 1.0");
        }

        @Override
        public OFPacketIn build() {
            byte[] data;
            OFPort inPort;
            OFBufferId bufferId;
            long xid = this.xidSet ? this.xid : 0L;
            OFBufferId oFBufferId = bufferId = this.bufferIdSet ? this.bufferId : DEFAULT_BUFFER_ID;
            if (bufferId == null) {
                throw new NullPointerException("Property bufferId must not be null");
            }
            int totalLen = this.totalLenSet ? this.totalLen : 0;
            OFPort oFPort = inPort = this.inPortSet ? this.inPort : DEFAULT_IN_PORT;
            if (inPort == null) {
                throw new NullPointerException("Property inPort must not be null");
            }
            if (!this.reasonSet) {
                throw new IllegalStateException("Property reason doesn't have default value -- must be set");
            }
            if (this.reason == null) {
                throw new NullPointerException("Property reason must not be null");
            }
            byte[] byArray = data = this.dataSet ? this.data : DEFAULT_DATA;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFPacketInVer10(xid, bufferId, totalLen, inPort, this.reason, data);
        }
    }

    static class BuilderWithParent
    implements OFPacketIn.Builder {
        final OFPacketInVer10 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean bufferIdSet;
        private OFBufferId bufferId;
        private boolean totalLenSet;
        private int totalLen;
        private boolean inPortSet;
        private OFPort inPort;
        private boolean reasonSet;
        private OFPacketInReason reason;
        private boolean dataSet;
        private byte[] data;

        BuilderWithParent(OFPacketInVer10 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFType getType() {
            return OFType.PACKET_IN;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFPacketIn.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFBufferId getBufferId() {
            return this.bufferId;
        }

        @Override
        public OFPacketIn.Builder setBufferId(OFBufferId bufferId) {
            this.bufferId = bufferId;
            this.bufferIdSet = true;
            return this;
        }

        @Override
        public int getTotalLen() {
            return this.totalLen;
        }

        @Override
        public OFPacketIn.Builder setTotalLen(int totalLen) {
            this.totalLen = totalLen;
            this.totalLenSet = true;
            return this;
        }

        @Override
        public OFPacketInReason getReason() {
            return this.reason;
        }

        @Override
        public OFPacketIn.Builder setReason(OFPacketInReason reason) {
            this.reason = reason;
            this.reasonSet = true;
            return this;
        }

        @Override
        public TableId getTableId() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property tableId not supported in version 1.0");
        }

        @Override
        public OFPacketIn.Builder setTableId(TableId tableId) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property tableId not supported in version 1.0");
        }

        @Override
        public U64 getCookie() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property cookie not supported in version 1.0");
        }

        @Override
        public OFPacketIn.Builder setCookie(U64 cookie) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property cookie not supported in version 1.0");
        }

        @Override
        public Match getMatch() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property match not supported in version 1.0");
        }

        @Override
        public OFPacketIn.Builder setMatch(Match match) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property match not supported in version 1.0");
        }

        @Override
        public byte[] getData() {
            return this.data;
        }

        @Override
        public OFPacketIn.Builder setData(byte[] data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFPort getInPort() {
            return this.inPort;
        }

        @Override
        public OFPacketIn.Builder setInPort(OFPort inPort) {
            this.inPort = inPort;
            this.inPortSet = true;
            return this;
        }

        @Override
        public OFPort getInPhyPort() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property inPhyPort not supported in version 1.0");
        }

        @Override
        public OFPacketIn.Builder setInPhyPort(OFPort inPhyPort) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property inPhyPort not supported in version 1.0");
        }

        @Override
        public OFPacketIn build() {
            byte[] data;
            OFPacketInReason reason;
            OFPort inPort;
            OFBufferId bufferId;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            OFBufferId oFBufferId = bufferId = this.bufferIdSet ? this.bufferId : this.parentMessage.bufferId;
            if (bufferId == null) {
                throw new NullPointerException("Property bufferId must not be null");
            }
            int totalLen = this.totalLenSet ? this.totalLen : this.parentMessage.totalLen;
            OFPort oFPort = inPort = this.inPortSet ? this.inPort : this.parentMessage.inPort;
            if (inPort == null) {
                throw new NullPointerException("Property inPort must not be null");
            }
            OFPacketInReason oFPacketInReason = reason = this.reasonSet ? this.reason : this.parentMessage.reason;
            if (reason == null) {
                throw new NullPointerException("Property reason must not be null");
            }
            byte[] byArray = data = this.dataSet ? this.data : this.parentMessage.data;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFPacketInVer10(xid, bufferId, totalLen, inPort, reason, data);
        }
    }
}

