/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMatchV1;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.types.ArpOpcode;
import org.projectfloodlight.openflow.types.EthType;
import org.projectfloodlight.openflow.types.ICMPv4Code;
import org.projectfloodlight.openflow.types.ICMPv4Type;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.IPv4AddressWithMask;
import org.projectfloodlight.openflow.types.IpDscp;
import org.projectfloodlight.openflow.types.IpProtocol;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.Masked;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.OFValueType;
import org.projectfloodlight.openflow.types.OFVlanVidMatch;
import org.projectfloodlight.openflow.types.TransportPort;
import org.projectfloodlight.openflow.types.VlanPcp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFMatchV1Ver10
implements OFMatchV1 {
    private static final Logger logger = LoggerFactory.getLogger(OFMatchV1Ver10.class);
    static final byte WIRE_VERSION = 1;
    static final int LENGTH = 40;
    private static final int DEFAULT_WILDCARDS = 0x3FFFFF;
    private static final OFPort DEFAULT_IN_PORT = OFPort.ZERO;
    private static final MacAddress DEFAULT_ETH_SRC = MacAddress.NONE;
    private static final MacAddress DEFAULT_ETH_DST = MacAddress.NONE;
    private static final OFVlanVidMatch DEFAULT_VLAN_VID = OFVlanVidMatch.NONE;
    private static final VlanPcp DEFAULT_VLAN_PCP = VlanPcp.NONE;
    private static final EthType DEFAULT_ETH_TYPE = EthType.NONE;
    private static final IpDscp DEFAULT_IP_DSCP = IpDscp.NONE;
    private static final IpProtocol DEFAULT_IP_PROTO = IpProtocol.NONE;
    private static final IPv4Address DEFAULT_IPV4_SRC = IPv4Address.NONE;
    private static final IPv4Address DEFAULT_IPV4_DST = IPv4Address.NONE;
    private static final TransportPort DEFAULT_TCP_SRC = TransportPort.NONE;
    private static final TransportPort DEFAULT_TCP_DST = TransportPort.NONE;
    private final int wildcards;
    private final OFPort inPort;
    private final MacAddress ethSrc;
    private final MacAddress ethDst;
    private final OFVlanVidMatch vlanVid;
    private final VlanPcp vlanPcp;
    private final EthType ethType;
    private final IpDscp ipDscp;
    private final IpProtocol ipProto;
    private final IPv4Address ipv4Src;
    private final IPv4Address ipv4Dst;
    private final TransportPort tcpSrc;
    private final TransportPort tcpDst;
    static final OFMatchV1Ver10 DEFAULT = new OFMatchV1Ver10(0x3FFFFF, DEFAULT_IN_PORT, DEFAULT_ETH_SRC, DEFAULT_ETH_DST, DEFAULT_VLAN_VID, DEFAULT_VLAN_PCP, DEFAULT_ETH_TYPE, DEFAULT_IP_DSCP, DEFAULT_IP_PROTO, DEFAULT_IPV4_SRC, DEFAULT_IPV4_DST, DEFAULT_TCP_SRC, DEFAULT_TCP_DST);
    public static final int OFPFW_ALL = 0x3FFFFF;
    public static final int OFPFW_IN_PORT = 1;
    public static final int OFPFW_DL_VLAN = 2;
    public static final int OFPFW_DL_SRC = 4;
    public static final int OFPFW_DL_DST = 8;
    public static final int OFPFW_DL_TYPE = 16;
    public static final int OFPFW_NW_PROTO = 32;
    public static final int OFPFW_TP_SRC = 64;
    public static final int OFPFW_TP_DST = 128;
    public static final int OFPFW_NW_SRC_SHIFT = 8;
    public static final int OFPFW_NW_SRC_BITS = 6;
    public static final int OFPFW_NW_SRC_MASK = 16128;
    public static final int OFPFW_NW_SRC_ALL = 8192;
    public static final int OFPFW_NW_DST_SHIFT = 14;
    public static final int OFPFW_NW_DST_BITS = 6;
    public static final int OFPFW_NW_DST_MASK = 1032192;
    public static final int OFPFW_NW_DST_ALL = 524288;
    public static final int OFPFW_DL_VLAN_PCP = 0x100000;
    public static final int OFPFW_NW_TOS = 0x200000;
    static final Reader READER = new Reader();
    static final OFMatchV1Ver10Funnel FUNNEL = new OFMatchV1Ver10Funnel();
    static final Writer WRITER = new Writer();

    OFMatchV1Ver10(int wildcards, OFPort inPort, MacAddress ethSrc, MacAddress ethDst, OFVlanVidMatch vlanVid, VlanPcp vlanPcp, EthType ethType, IpDscp ipDscp, IpProtocol ipProto, IPv4Address ipv4Src, IPv4Address ipv4Dst, TransportPort tcpSrc, TransportPort tcpDst) {
        if (inPort == null) {
            throw new NullPointerException("OFMatchV1Ver10: property inPort cannot be null");
        }
        if (ethSrc == null) {
            throw new NullPointerException("OFMatchV1Ver10: property ethSrc cannot be null");
        }
        if (ethDst == null) {
            throw new NullPointerException("OFMatchV1Ver10: property ethDst cannot be null");
        }
        if (vlanVid == null) {
            throw new NullPointerException("OFMatchV1Ver10: property vlanVid cannot be null");
        }
        if (vlanPcp == null) {
            throw new NullPointerException("OFMatchV1Ver10: property vlanPcp cannot be null");
        }
        if (ethType == null) {
            throw new NullPointerException("OFMatchV1Ver10: property ethType cannot be null");
        }
        if (ipDscp == null) {
            throw new NullPointerException("OFMatchV1Ver10: property ipDscp cannot be null");
        }
        if (ipProto == null) {
            throw new NullPointerException("OFMatchV1Ver10: property ipProto cannot be null");
        }
        if (ipv4Src == null) {
            throw new NullPointerException("OFMatchV1Ver10: property ipv4Src cannot be null");
        }
        if (ipv4Dst == null) {
            throw new NullPointerException("OFMatchV1Ver10: property ipv4Dst cannot be null");
        }
        if (tcpSrc == null) {
            throw new NullPointerException("OFMatchV1Ver10: property tcpSrc cannot be null");
        }
        if (tcpDst == null) {
            throw new NullPointerException("OFMatchV1Ver10: property tcpDst cannot be null");
        }
        this.wildcards = wildcards;
        this.inPort = inPort;
        this.ethSrc = ethSrc;
        this.ethDst = ethDst;
        this.vlanVid = vlanVid;
        this.vlanPcp = vlanPcp;
        this.ethType = ethType;
        this.ipDscp = ipDscp;
        this.ipProto = ipProto;
        this.ipv4Src = ipv4Src;
        this.ipv4Dst = ipv4Dst;
        this.tcpSrc = tcpSrc;
        this.tcpDst = tcpDst;
    }

    @Override
    public int getWildcards() {
        return this.wildcards;
    }

    @Override
    public OFPort getInPort() {
        return this.inPort;
    }

    @Override
    public MacAddress getEthSrc() {
        return this.ethSrc;
    }

    @Override
    public MacAddress getEthDst() {
        return this.ethDst;
    }

    @Override
    public OFVlanVidMatch getVlanVid() {
        return this.vlanVid;
    }

    @Override
    public VlanPcp getVlanPcp() {
        return this.vlanPcp;
    }

    @Override
    public EthType getEthType() {
        return this.ethType;
    }

    @Override
    public IpDscp getIpDscp() {
        return this.ipDscp;
    }

    @Override
    public IpProtocol getIpProto() {
        return this.ipProto;
    }

    @Override
    public IPv4Address getIpv4Src() {
        return this.ipv4Src;
    }

    @Override
    public IPv4Address getIpv4Dst() {
        return this.ipv4Dst;
    }

    @Override
    public TransportPort getTcpSrc() {
        return this.tcpSrc;
    }

    @Override
    public TransportPort getTcpDst() {
        return this.tcpDst;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_10;
    }

    @Override
    public <F extends OFValueType<F>> F get(MatchField<F> field) throws UnsupportedOperationException {
        OFValueType<OFPort> result;
        if (this.isFullyWildcarded(field)) {
            return null;
        }
        if (!field.arePrerequisitesOK(this)) {
            return null;
        }
        switch (field.id) {
            case IN_PORT: {
                result = this.inPort;
                break;
            }
            case ETH_DST: {
                result = this.ethDst;
                break;
            }
            case ETH_SRC: {
                result = this.ethSrc;
                break;
            }
            case ETH_TYPE: {
                result = this.ethType;
                break;
            }
            case VLAN_VID: {
                result = this.vlanVid;
                break;
            }
            case VLAN_PCP: {
                result = this.vlanPcp;
                break;
            }
            case ARP_OP: {
                result = ArpOpcode.of(this.ipProto.getIpProtocolNumber());
                break;
            }
            case ARP_SPA: {
                result = this.ipv4Src;
                break;
            }
            case ARP_TPA: {
                result = this.ipv4Dst;
                break;
            }
            case IP_DSCP: {
                result = this.ipDscp;
                break;
            }
            case IP_PROTO: {
                result = this.ipProto;
                break;
            }
            case IPV4_SRC: {
                result = this.ipv4Src;
                break;
            }
            case IPV4_DST: {
                result = this.ipv4Dst;
                break;
            }
            case TCP_SRC: {
                result = this.tcpSrc;
                break;
            }
            case TCP_DST: {
                result = this.tcpDst;
                break;
            }
            case UDP_SRC: {
                result = this.tcpSrc;
                break;
            }
            case UDP_DST: {
                result = this.tcpDst;
                break;
            }
            case SCTP_SRC: {
                result = this.tcpSrc;
                break;
            }
            case SCTP_DST: {
                result = this.tcpDst;
                break;
            }
            case ICMPV4_TYPE: {
                result = ICMPv4Type.of((short)this.tcpSrc.getPort());
                break;
            }
            case ICMPV4_CODE: {
                result = ICMPv4Code.of((short)this.tcpDst.getPort());
                break;
            }
            default: {
                throw new UnsupportedOperationException("OFMatch does not support matching on field " + field.getName());
            }
        }
        return (F)result;
    }

    @Override
    public <F extends OFValueType<F>> Masked<F> getMasked(MatchField<F> field) throws UnsupportedOperationException {
        IPv4AddressWithMask result;
        if (!this.isPartiallyMasked(field)) {
            return null;
        }
        if (!field.arePrerequisitesOK(this)) {
            return null;
        }
        switch (field.id) {
            case ARP_SPA: 
            case IPV4_SRC: {
                int srcBitMask = -1 << 32 - this.getIpv4SrcCidrMaskLen();
                result = IPv4AddressWithMask.of(this.ipv4Src, IPv4Address.of(srcBitMask));
                break;
            }
            case ARP_TPA: 
            case IPV4_DST: {
                int dstBitMask = -1 << 32 - this.getIpv4DstCidrMaskLen();
                result = IPv4AddressWithMask.of(this.ipv4Dst, IPv4Address.of(dstBitMask));
                break;
            }
            default: {
                throw new UnsupportedOperationException("OFMatch does not support masked matching on field " + field.getName());
            }
        }
        return result;
    }

    @Override
    public boolean supports(MatchField<?> field) {
        switch (field.id) {
            case IN_PORT: 
            case ETH_DST: 
            case ETH_SRC: 
            case ETH_TYPE: 
            case VLAN_VID: 
            case VLAN_PCP: 
            case ARP_OP: 
            case ARP_SPA: 
            case ARP_TPA: 
            case IP_DSCP: 
            case IP_PROTO: 
            case IPV4_SRC: 
            case IPV4_DST: 
            case TCP_SRC: 
            case TCP_DST: 
            case UDP_SRC: 
            case UDP_DST: 
            case SCTP_SRC: 
            case SCTP_DST: 
            case ICMPV4_TYPE: 
            case ICMPV4_CODE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsMasked(MatchField<?> field) {
        switch (field.id) {
            case ARP_SPA: 
            case ARP_TPA: 
            case IPV4_SRC: 
            case IPV4_DST: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isExact(MatchField<?> field) {
        if (!field.arePrerequisitesOK(this)) {
            return false;
        }
        switch (field.id) {
            case IN_PORT: {
                return (this.wildcards & 1) == 0;
            }
            case ETH_DST: {
                return (this.wildcards & 8) == 0;
            }
            case ETH_SRC: {
                return (this.wildcards & 4) == 0;
            }
            case ETH_TYPE: {
                return (this.wildcards & 0x10) == 0;
            }
            case VLAN_VID: {
                return (this.wildcards & 2) == 0;
            }
            case VLAN_PCP: {
                return (this.wildcards & 0x100000) == 0;
            }
            case ARP_OP: {
                return (this.wildcards & 0x20) == 0;
            }
            case ARP_SPA: {
                return this.getIpv4SrcCidrMaskLen() >= 32;
            }
            case ARP_TPA: {
                return this.getIpv4DstCidrMaskLen() >= 32;
            }
            case IP_DSCP: {
                return (this.wildcards & 0x200000) == 0;
            }
            case IP_PROTO: {
                return (this.wildcards & 0x20) == 0;
            }
            case IPV4_SRC: {
                return this.getIpv4SrcCidrMaskLen() >= 32;
            }
            case IPV4_DST: {
                return this.getIpv4DstCidrMaskLen() >= 32;
            }
            case TCP_SRC: {
                return (this.wildcards & 0x40) == 0;
            }
            case TCP_DST: {
                return (this.wildcards & 0x80) == 0;
            }
            case UDP_SRC: {
                return (this.wildcards & 0x40) == 0;
            }
            case UDP_DST: {
                return (this.wildcards & 0x80) == 0;
            }
            case SCTP_SRC: {
                return (this.wildcards & 0x40) == 0;
            }
            case SCTP_DST: {
                return (this.wildcards & 0x80) == 0;
            }
            case ICMPV4_TYPE: {
                return (this.wildcards & 0x40) == 0;
            }
            case ICMPV4_CODE: {
                return (this.wildcards & 0x80) == 0;
            }
        }
        throw new UnsupportedOperationException("OFMatch does not support matching on field " + field.getName());
    }

    public int getIpv4DstCidrMaskLen() {
        return Math.max(32 - ((this.wildcards & 0xFC000) >> 14), 0);
    }

    public int getIpv4SrcCidrMaskLen() {
        return Math.max(32 - ((this.wildcards & 0x3F00) >> 8), 0);
    }

    @Override
    public boolean isFullyWildcarded(MatchField<?> field) {
        if (!field.arePrerequisitesOK(this)) {
            return true;
        }
        switch (field.id) {
            case IN_PORT: {
                return (this.wildcards & 1) != 0;
            }
            case ETH_DST: {
                return (this.wildcards & 8) != 0;
            }
            case ETH_SRC: {
                return (this.wildcards & 4) != 0;
            }
            case ETH_TYPE: {
                return (this.wildcards & 0x10) != 0;
            }
            case VLAN_VID: {
                return (this.wildcards & 2) != 0;
            }
            case VLAN_PCP: {
                return (this.wildcards & 0x100000) != 0;
            }
            case ARP_OP: {
                return (this.wildcards & 0x20) != 0;
            }
            case ARP_SPA: {
                return this.getIpv4SrcCidrMaskLen() <= 0;
            }
            case ARP_TPA: {
                return this.getIpv4DstCidrMaskLen() <= 0;
            }
            case IP_DSCP: {
                return (this.wildcards & 0x200000) != 0;
            }
            case IP_PROTO: {
                return (this.wildcards & 0x20) != 0;
            }
            case TCP_SRC: {
                return (this.wildcards & 0x40) != 0;
            }
            case TCP_DST: {
                return (this.wildcards & 0x80) != 0;
            }
            case UDP_SRC: {
                return (this.wildcards & 0x40) != 0;
            }
            case UDP_DST: {
                return (this.wildcards & 0x80) != 0;
            }
            case SCTP_SRC: {
                return (this.wildcards & 0x40) != 0;
            }
            case SCTP_DST: {
                return (this.wildcards & 0x80) != 0;
            }
            case ICMPV4_TYPE: {
                return (this.wildcards & 0x40) != 0;
            }
            case ICMPV4_CODE: {
                return (this.wildcards & 0x80) != 0;
            }
            case IPV4_SRC: {
                return this.getIpv4SrcCidrMaskLen() <= 0;
            }
            case IPV4_DST: {
                return this.getIpv4DstCidrMaskLen() <= 0;
            }
        }
        throw new UnsupportedOperationException("OFMatch does not support matching on field " + field.getName());
    }

    @Override
    public boolean isPartiallyMasked(MatchField<?> field) {
        if (!field.arePrerequisitesOK(this)) {
            return false;
        }
        switch (field.id) {
            case ARP_SPA: 
            case IPV4_SRC: {
                int srcCidrLen = this.getIpv4SrcCidrMaskLen();
                return srcCidrLen > 0 && srcCidrLen < 32;
            }
            case ARP_TPA: 
            case IPV4_DST: {
                int dstCidrLen = this.getIpv4DstCidrMaskLen();
                return dstCidrLen > 0 && dstCidrLen < 32;
            }
        }
        return false;
    }

    @Override
    public Iterable<MatchField<?>> getMatchFields() {
        ImmutableList.Builder builder = ImmutableList.builder();
        if ((this.wildcards & 1) == 0) {
            builder.add(MatchField.IN_PORT);
        }
        if ((this.wildcards & 2) == 0) {
            builder.add(MatchField.VLAN_VID);
        }
        if ((this.wildcards & 4) == 0) {
            builder.add(MatchField.ETH_SRC);
        }
        if ((this.wildcards & 8) == 0) {
            builder.add(MatchField.ETH_DST);
        }
        if ((this.wildcards & 0x10) == 0) {
            builder.add(MatchField.ETH_TYPE);
        }
        if ((this.wildcards & 0x20) == 0) {
            if (this.ethType == EthType.ARP) {
                builder.add(MatchField.ARP_OP);
            } else if (this.ethType == EthType.IPv4) {
                builder.add(MatchField.IP_PROTO);
            } else {
                throw new UnsupportedOperationException("Unsupported Ethertype for matching on network protocol " + this.ethType);
            }
        }
        if ((this.wildcards & 0x40) == 0) {
            if (this.ipProto == IpProtocol.UDP) {
                builder.add(MatchField.UDP_SRC);
            } else if (this.ipProto == IpProtocol.TCP) {
                builder.add(MatchField.TCP_SRC);
            } else if (this.ipProto == IpProtocol.SCTP) {
                builder.add(MatchField.SCTP_SRC);
            } else if (this.ipProto == IpProtocol.ICMP) {
                builder.add(MatchField.ICMPV4_TYPE);
            } else {
                throw new UnsupportedOperationException("Unsupported IP protocol for matching on source port " + this.ipProto);
            }
        }
        if ((this.wildcards & 0x80) == 0) {
            if (this.ipProto == IpProtocol.UDP) {
                builder.add(MatchField.UDP_DST);
            } else if (this.ipProto == IpProtocol.TCP) {
                builder.add(MatchField.TCP_DST);
            } else if (this.ipProto == IpProtocol.SCTP) {
                builder.add(MatchField.SCTP_DST);
            } else if (this.ipProto == IpProtocol.ICMP) {
                builder.add(MatchField.ICMPV4_CODE);
            } else {
                throw new UnsupportedOperationException("Unsupported IP protocol for matching on destination port " + this.ipProto);
            }
        }
        if ((this.wildcards & 0x3F00) >> 8 < 32) {
            if (this.ethType == EthType.ARP) {
                builder.add(MatchField.ARP_SPA);
            } else if (this.ethType == EthType.IPv4) {
                builder.add(MatchField.IPV4_SRC);
            } else {
                throw new UnsupportedOperationException("Unsupported Ethertype for matching on source IP " + this.ethType);
            }
        }
        if ((this.wildcards & 0xFC000) >> 14 < 32) {
            if (this.ethType == EthType.ARP) {
                builder.add(MatchField.ARP_TPA);
            } else if (this.ethType == EthType.IPv4) {
                builder.add(MatchField.IPV4_DST);
            } else {
                throw new UnsupportedOperationException("Unsupported Ethertype for matching on destination IP " + this.ethType);
            }
        }
        if ((this.wildcards & 0x100000) == 0) {
            builder.add(MatchField.VLAN_PCP);
        }
        if ((this.wildcards & 0x200000) == 0) {
            builder.add(MatchField.IP_DSCP);
        }
        return builder.build();
    }

    @Override
    public OFMatchV1.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFMatchV1Ver10(");
        boolean first = true;
        for (MatchField<?> field : this.getMatchFields()) {
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            String name = field.getName();
            b.append(name).append('=').append(this.get(field));
            if (!this.isPartiallyMasked(field)) continue;
            b.append('/').append(this.getMasked(field).getMask());
        }
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFMatchV1Ver10 other = (OFMatchV1Ver10)obj;
        if (this.wildcards != other.wildcards) {
            return false;
        }
        if (this.inPort == null ? other.inPort != null : !this.inPort.equals(other.inPort)) {
            return false;
        }
        if (this.ethSrc == null ? other.ethSrc != null : !this.ethSrc.equals(other.ethSrc)) {
            return false;
        }
        if (this.ethDst == null ? other.ethDst != null : !this.ethDst.equals(other.ethDst)) {
            return false;
        }
        if (this.vlanVid == null ? other.vlanVid != null : !this.vlanVid.equals(other.vlanVid)) {
            return false;
        }
        if (this.vlanPcp == null ? other.vlanPcp != null : !this.vlanPcp.equals(other.vlanPcp)) {
            return false;
        }
        if (this.ethType == null ? other.ethType != null : !this.ethType.equals(other.ethType)) {
            return false;
        }
        if (this.ipDscp == null ? other.ipDscp != null : !this.ipDscp.equals(other.ipDscp)) {
            return false;
        }
        if (this.ipProto == null ? other.ipProto != null : !this.ipProto.equals(other.ipProto)) {
            return false;
        }
        if (this.ipv4Src == null ? other.ipv4Src != null : !this.ipv4Src.equals(other.ipv4Src)) {
            return false;
        }
        if (this.ipv4Dst == null ? other.ipv4Dst != null : !this.ipv4Dst.equals(other.ipv4Dst)) {
            return false;
        }
        if (this.tcpSrc == null ? other.tcpSrc != null : !this.tcpSrc.equals(other.tcpSrc)) {
            return false;
        }
        return !(this.tcpDst == null ? other.tcpDst != null : !this.tcpDst.equals(other.tcpDst));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.wildcards;
        result = 31 * result + (this.inPort == null ? 0 : this.inPort.hashCode());
        result = 31 * result + (this.ethSrc == null ? 0 : this.ethSrc.hashCode());
        result = 31 * result + (this.ethDst == null ? 0 : this.ethDst.hashCode());
        result = 31 * result + (this.vlanVid == null ? 0 : this.vlanVid.hashCode());
        result = 31 * result + (this.vlanPcp == null ? 0 : this.vlanPcp.hashCode());
        result = 31 * result + (this.ethType == null ? 0 : this.ethType.hashCode());
        result = 31 * result + (this.ipDscp == null ? 0 : this.ipDscp.hashCode());
        result = 31 * result + (this.ipProto == null ? 0 : this.ipProto.hashCode());
        result = 31 * result + (this.ipv4Src == null ? 0 : this.ipv4Src.hashCode());
        result = 31 * result + (this.ipv4Dst == null ? 0 : this.ipv4Dst.hashCode());
        result = 31 * result + (this.tcpSrc == null ? 0 : this.tcpSrc.hashCode());
        result = 31 * result + (this.tcpDst == null ? 0 : this.tcpDst.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFMatchV1Ver10> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFMatchV1Ver10 message) {
            bb.writeInt(message.wildcards);
            message.inPort.write2Bytes(bb);
            message.ethSrc.write6Bytes(bb);
            message.ethDst.write6Bytes(bb);
            message.vlanVid.write2BytesOF10(bb);
            message.vlanPcp.writeByte(bb);
            bb.writeZero(1);
            message.ethType.write2Bytes(bb);
            message.ipDscp.writeByte(bb);
            message.ipProto.writeByte(bb);
            bb.writeZero(2);
            message.ipv4Src.write4Bytes(bb);
            message.ipv4Dst.write4Bytes(bb);
            message.tcpSrc.write2Bytes(bb);
            message.tcpDst.write2Bytes(bb);
        }
    }

    static class OFMatchV1Ver10Funnel
    implements Funnel<OFMatchV1Ver10> {
        private static final long serialVersionUID = 1L;

        OFMatchV1Ver10Funnel() {
        }

        public void funnel(OFMatchV1Ver10 message, PrimitiveSink sink) {
            sink.putInt(message.wildcards);
            message.inPort.putTo(sink);
            message.ethSrc.putTo(sink);
            message.ethDst.putTo(sink);
            message.vlanVid.putTo(sink);
            message.vlanPcp.putTo(sink);
            message.ethType.putTo(sink);
            message.ipDscp.putTo(sink);
            message.ipProto.putTo(sink);
            message.ipv4Src.putTo(sink);
            message.ipv4Dst.putTo(sink);
            message.tcpSrc.putTo(sink);
            message.tcpDst.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFMatchV1> {
        Reader() {
        }

        @Override
        public OFMatchV1 readFrom(ByteBuf bb) throws OFParseError {
            int wildcards = bb.readInt();
            OFPort inPort = OFPort.read2Bytes(bb);
            MacAddress ethSrc = MacAddress.read6Bytes(bb);
            MacAddress ethDst = MacAddress.read6Bytes(bb);
            OFVlanVidMatch vlanVid = OFVlanVidMatch.read2BytesOF10(bb);
            VlanPcp vlanPcp = VlanPcp.readByte(bb);
            bb.skipBytes(1);
            EthType ethType = EthType.read2Bytes(bb);
            IpDscp ipDscp = IpDscp.readByte(bb);
            IpProtocol ipProto = IpProtocol.readByte(bb);
            bb.skipBytes(2);
            IPv4Address ipv4Src = IPv4Address.read4Bytes(bb);
            IPv4Address ipv4Dst = IPv4Address.read4Bytes(bb);
            TransportPort tcpSrc = TransportPort.read2Bytes(bb);
            TransportPort tcpDst = TransportPort.read2Bytes(bb);
            if (ethType.equals(EthType.IPv4)) {
                if (ipProto.equals(IpProtocol.TCP) || ipProto.equals(IpProtocol.UDP) || ipProto.equals(IpProtocol.ICMP)) {
                    if ((wildcards & 0x2000) != 0) {
                        wildcards |= 0x3F00;
                    }
                    if ((wildcards & 0x80000) != 0) {
                        wildcards |= 0xFC000;
                    }
                } else {
                    if ((wildcards & 0x2000) != 0) {
                        wildcards |= 0x3F00;
                    }
                    if ((wildcards & 0x80000) != 0) {
                        wildcards |= 0xFC000;
                    }
                    wildcards |= 0xC0;
                    tcpSrc = TransportPort.NONE;
                    tcpDst = TransportPort.NONE;
                }
            } else if (ethType.equals(EthType.ARP)) {
                if ((wildcards & 0x2000) != 0) {
                    wildcards |= 0x3F00;
                }
                if ((wildcards & 0x80000) != 0) {
                    wildcards |= 0xFC000;
                }
                wildcards |= 0x2000C0;
                ipDscp = IpDscp.NONE;
                tcpSrc = TransportPort.NONE;
                tcpDst = TransportPort.NONE;
            } else {
                wildcards |= 0x2FFFE0;
                ipDscp = IpDscp.NONE;
                ipProto = IpProtocol.NONE;
                ipv4Src = IPv4Address.NONE;
                ipv4Dst = IPv4Address.NONE;
                tcpSrc = TransportPort.NONE;
                tcpDst = TransportPort.NONE;
            }
            OFMatchV1Ver10 matchV1Ver10 = new OFMatchV1Ver10(wildcards, inPort, ethSrc, ethDst, vlanVid, vlanPcp, ethType, ipDscp, ipProto, ipv4Src, ipv4Dst, tcpSrc, tcpDst);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)matchV1Ver10);
            }
            return matchV1Ver10;
        }
    }

    static class Builder
    implements OFMatchV1.Builder {
        private boolean wildcardsSet;
        private int wildcards;
        private boolean inPortSet;
        private OFPort inPort;
        private boolean ethSrcSet;
        private MacAddress ethSrc;
        private boolean ethDstSet;
        private MacAddress ethDst;
        private boolean vlanVidSet;
        private OFVlanVidMatch vlanVid;
        private boolean vlanPcpSet;
        private VlanPcp vlanPcp;
        private boolean ethTypeSet;
        private EthType ethType;
        private boolean ipDscpSet;
        private IpDscp ipDscp;
        private boolean ipProtoSet;
        private IpProtocol ipProto;
        private boolean ipv4SrcSet;
        private IPv4Address ipv4Src;
        private boolean ipv4DstSet;
        private IPv4Address ipv4Dst;
        private boolean tcpSrcSet;
        private TransportPort tcpSrc;
        private boolean tcpDstSet;
        private TransportPort tcpDst;

        Builder() {
        }

        @Override
        public int getWildcards() {
            return this.wildcards;
        }

        @Override
        public OFMatchV1.Builder setWildcards(int wildcards) {
            this.wildcards = wildcards;
            this.wildcardsSet = true;
            return this;
        }

        @Override
        public OFPort getInPort() {
            return this.inPort;
        }

        @Override
        public OFMatchV1.Builder setInPort(OFPort inPort) {
            this.inPort = inPort;
            this.inPortSet = true;
            return this;
        }

        @Override
        public MacAddress getEthSrc() {
            return this.ethSrc;
        }

        @Override
        public OFMatchV1.Builder setEthSrc(MacAddress ethSrc) {
            this.ethSrc = ethSrc;
            this.ethSrcSet = true;
            return this;
        }

        @Override
        public MacAddress getEthDst() {
            return this.ethDst;
        }

        @Override
        public OFMatchV1.Builder setEthDst(MacAddress ethDst) {
            this.ethDst = ethDst;
            this.ethDstSet = true;
            return this;
        }

        @Override
        public OFVlanVidMatch getVlanVid() {
            return this.vlanVid;
        }

        @Override
        public OFMatchV1.Builder setVlanVid(OFVlanVidMatch vlanVid) {
            this.vlanVid = vlanVid;
            this.vlanVidSet = true;
            return this;
        }

        @Override
        public VlanPcp getVlanPcp() {
            return this.vlanPcp;
        }

        @Override
        public OFMatchV1.Builder setVlanPcp(VlanPcp vlanPcp) {
            this.vlanPcp = vlanPcp;
            this.vlanPcpSet = true;
            return this;
        }

        @Override
        public EthType getEthType() {
            return this.ethType;
        }

        @Override
        public OFMatchV1.Builder setEthType(EthType ethType) {
            this.ethType = ethType;
            this.ethTypeSet = true;
            return this;
        }

        @Override
        public IpDscp getIpDscp() {
            return this.ipDscp;
        }

        @Override
        public OFMatchV1.Builder setIpDscp(IpDscp ipDscp) {
            this.ipDscp = ipDscp;
            this.ipDscpSet = true;
            return this;
        }

        @Override
        public IpProtocol getIpProto() {
            return this.ipProto;
        }

        @Override
        public OFMatchV1.Builder setIpProto(IpProtocol ipProto) {
            this.ipProto = ipProto;
            this.ipProtoSet = true;
            return this;
        }

        @Override
        public IPv4Address getIpv4Src() {
            return this.ipv4Src;
        }

        @Override
        public OFMatchV1.Builder setIpv4Src(IPv4Address ipv4Src) {
            this.ipv4Src = ipv4Src;
            this.ipv4SrcSet = true;
            return this;
        }

        @Override
        public IPv4Address getIpv4Dst() {
            return this.ipv4Dst;
        }

        @Override
        public OFMatchV1.Builder setIpv4Dst(IPv4Address ipv4Dst) {
            this.ipv4Dst = ipv4Dst;
            this.ipv4DstSet = true;
            return this;
        }

        @Override
        public TransportPort getTcpSrc() {
            return this.tcpSrc;
        }

        @Override
        public OFMatchV1.Builder setTcpSrc(TransportPort tcpSrc) {
            this.tcpSrc = tcpSrc;
            this.tcpSrcSet = true;
            return this;
        }

        @Override
        public TransportPort getTcpDst() {
            return this.tcpDst;
        }

        @Override
        public OFMatchV1.Builder setTcpDst(TransportPort tcpDst) {
            this.tcpDst = tcpDst;
            this.tcpDstSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFMatchV1 build() {
            TransportPort tcpDst;
            TransportPort tcpSrc;
            IPv4Address ipv4Dst;
            IPv4Address ipv4Src;
            IpProtocol ipProto;
            IpDscp ipDscp;
            EthType ethType;
            VlanPcp vlanPcp;
            OFVlanVidMatch vlanVid;
            MacAddress ethDst;
            MacAddress ethSrc;
            OFPort inPort;
            int wildcards = this.wildcardsSet ? this.wildcards : 0x3FFFFF;
            OFPort oFPort = inPort = this.inPortSet ? this.inPort : DEFAULT_IN_PORT;
            if (inPort == null) {
                throw new NullPointerException("Property inPort must not be null");
            }
            MacAddress macAddress = ethSrc = this.ethSrcSet ? this.ethSrc : DEFAULT_ETH_SRC;
            if (ethSrc == null) {
                throw new NullPointerException("Property ethSrc must not be null");
            }
            MacAddress macAddress2 = ethDst = this.ethDstSet ? this.ethDst : DEFAULT_ETH_DST;
            if (ethDst == null) {
                throw new NullPointerException("Property ethDst must not be null");
            }
            OFVlanVidMatch oFVlanVidMatch = vlanVid = this.vlanVidSet ? this.vlanVid : DEFAULT_VLAN_VID;
            if (vlanVid == null) {
                throw new NullPointerException("Property vlanVid must not be null");
            }
            VlanPcp vlanPcp2 = vlanPcp = this.vlanPcpSet ? this.vlanPcp : DEFAULT_VLAN_PCP;
            if (vlanPcp == null) {
                throw new NullPointerException("Property vlanPcp must not be null");
            }
            EthType ethType2 = ethType = this.ethTypeSet ? this.ethType : DEFAULT_ETH_TYPE;
            if (ethType == null) {
                throw new NullPointerException("Property ethType must not be null");
            }
            IpDscp ipDscp2 = ipDscp = this.ipDscpSet ? this.ipDscp : DEFAULT_IP_DSCP;
            if (ipDscp == null) {
                throw new NullPointerException("Property ipDscp must not be null");
            }
            IpProtocol ipProtocol = ipProto = this.ipProtoSet ? this.ipProto : DEFAULT_IP_PROTO;
            if (ipProto == null) {
                throw new NullPointerException("Property ipProto must not be null");
            }
            IPv4Address iPv4Address = ipv4Src = this.ipv4SrcSet ? this.ipv4Src : DEFAULT_IPV4_SRC;
            if (ipv4Src == null) {
                throw new NullPointerException("Property ipv4Src must not be null");
            }
            IPv4Address iPv4Address2 = ipv4Dst = this.ipv4DstSet ? this.ipv4Dst : DEFAULT_IPV4_DST;
            if (ipv4Dst == null) {
                throw new NullPointerException("Property ipv4Dst must not be null");
            }
            TransportPort transportPort = tcpSrc = this.tcpSrcSet ? this.tcpSrc : DEFAULT_TCP_SRC;
            if (tcpSrc == null) {
                throw new NullPointerException("Property tcpSrc must not be null");
            }
            TransportPort transportPort2 = tcpDst = this.tcpDstSet ? this.tcpDst : DEFAULT_TCP_DST;
            if (tcpDst == null) {
                throw new NullPointerException("Property tcpDst must not be null");
            }
            if (ethType.equals(EthType.IPv4)) {
                if (ipProto.equals(IpProtocol.TCP) || ipProto.equals(IpProtocol.UDP) || ipProto.equals(IpProtocol.ICMP)) {
                    if ((wildcards & 0x2000) != 0) {
                        wildcards |= 0x3F00;
                    }
                    if ((wildcards & 0x80000) != 0) {
                        wildcards |= 0xFC000;
                    }
                } else {
                    if ((wildcards & 0x2000) != 0) {
                        wildcards |= 0x3F00;
                    }
                    if ((wildcards & 0x80000) != 0) {
                        wildcards |= 0xFC000;
                    }
                    wildcards |= 0xC0;
                    tcpSrc = TransportPort.NONE;
                    tcpDst = TransportPort.NONE;
                }
            } else if (ethType.equals(EthType.ARP)) {
                if ((wildcards & 0x2000) != 0) {
                    wildcards |= 0x3F00;
                }
                if ((wildcards & 0x80000) != 0) {
                    wildcards |= 0xFC000;
                }
                wildcards |= 0x2000C0;
                ipDscp = IpDscp.NONE;
                tcpSrc = TransportPort.NONE;
                tcpDst = TransportPort.NONE;
            } else {
                wildcards |= 0x2FFFE0;
                ipDscp = IpDscp.NONE;
                ipProto = IpProtocol.NONE;
                ipv4Src = IPv4Address.NONE;
                ipv4Dst = IPv4Address.NONE;
                tcpSrc = TransportPort.NONE;
                tcpDst = TransportPort.NONE;
            }
            return new OFMatchV1Ver10(wildcards, inPort, ethSrc, ethDst, vlanVid, vlanPcp, ethType, ipDscp, ipProto, ipv4Src, ipv4Dst, tcpSrc, tcpDst);
        }

        @Override
        public <F extends OFValueType<F>> F get(MatchField<F> field) throws UnsupportedOperationException {
            OFValueType<OFPort> result;
            if (this.isFullyWildcarded(field)) {
                return null;
            }
            switch (field.id) {
                case IN_PORT: {
                    result = this.inPort;
                    break;
                }
                case ETH_DST: {
                    result = this.ethDst;
                    break;
                }
                case ETH_SRC: {
                    result = this.ethSrc;
                    break;
                }
                case ETH_TYPE: {
                    result = this.ethType;
                    break;
                }
                case VLAN_VID: {
                    result = this.vlanVid;
                    break;
                }
                case VLAN_PCP: {
                    result = this.vlanPcp;
                    break;
                }
                case ARP_OP: {
                    result = ArpOpcode.of(this.ipProto.getIpProtocolNumber());
                    break;
                }
                case ARP_SPA: {
                    result = this.ipv4Src;
                    break;
                }
                case ARP_TPA: {
                    result = this.ipv4Dst;
                    break;
                }
                case IP_DSCP: {
                    result = this.ipDscp;
                    break;
                }
                case IP_PROTO: {
                    result = this.ipProto;
                    break;
                }
                case IPV4_SRC: {
                    result = this.ipv4Src;
                    break;
                }
                case IPV4_DST: {
                    result = this.ipv4Dst;
                    break;
                }
                case TCP_SRC: {
                    result = this.tcpSrc;
                    break;
                }
                case TCP_DST: {
                    result = this.tcpDst;
                    break;
                }
                case UDP_SRC: {
                    result = this.tcpSrc;
                    break;
                }
                case UDP_DST: {
                    result = this.tcpDst;
                    break;
                }
                case SCTP_SRC: {
                    result = this.tcpSrc;
                    break;
                }
                case SCTP_DST: {
                    result = this.tcpDst;
                    break;
                }
                case ICMPV4_TYPE: {
                    result = ICMPv4Type.of((short)this.tcpSrc.getPort());
                    break;
                }
                case ICMPV4_CODE: {
                    result = ICMPv4Code.of((short)this.tcpDst.getPort());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("OFMatch does not support matching on field " + field.getName());
                }
            }
            return (F)result;
        }

        @Override
        public <F extends OFValueType<F>> Masked<F> getMasked(MatchField<F> field) throws UnsupportedOperationException {
            IPv4AddressWithMask result;
            if (!this.isPartiallyMasked(field)) {
                return null;
            }
            switch (field.id) {
                case ARP_SPA: 
                case IPV4_SRC: {
                    int srcBitMask = -1 << 32 - this.getIpv4SrcCidrMaskLen();
                    result = IPv4AddressWithMask.of(this.ipv4Src, IPv4Address.of(srcBitMask));
                    break;
                }
                case ARP_TPA: 
                case IPV4_DST: {
                    int dstMaskedBits = Math.min(32, (this.wildcards & 0xFC000) >> 14);
                    int dstBitMask = -1 << 32 - this.getIpv4DstCidrMaskLen();
                    result = IPv4AddressWithMask.of(this.ipv4Dst, IPv4Address.of(dstBitMask));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("OFMatch does not support masked matching on field " + field.getName());
                }
            }
            return result;
        }

        @Override
        public boolean supports(MatchField<?> field) {
            switch (field.id) {
                case IN_PORT: 
                case ETH_DST: 
                case ETH_SRC: 
                case ETH_TYPE: 
                case VLAN_VID: 
                case VLAN_PCP: 
                case ARP_OP: 
                case ARP_SPA: 
                case ARP_TPA: 
                case IP_DSCP: 
                case IP_PROTO: 
                case IPV4_SRC: 
                case IPV4_DST: 
                case TCP_SRC: 
                case TCP_DST: 
                case UDP_SRC: 
                case UDP_DST: 
                case SCTP_SRC: 
                case SCTP_DST: 
                case ICMPV4_TYPE: 
                case ICMPV4_CODE: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean supportsMasked(MatchField<?> field) {
            switch (field.id) {
                case ARP_SPA: 
                case ARP_TPA: 
                case IPV4_SRC: 
                case IPV4_DST: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isExact(MatchField<?> field) {
            switch (field.id) {
                case IN_PORT: {
                    return (this.wildcards & 1) == 0;
                }
                case ETH_DST: {
                    return (this.wildcards & 8) == 0;
                }
                case ETH_SRC: {
                    return (this.wildcards & 4) == 0;
                }
                case ETH_TYPE: {
                    return (this.wildcards & 0x10) == 0;
                }
                case VLAN_VID: {
                    return (this.wildcards & 2) == 0;
                }
                case VLAN_PCP: {
                    return (this.wildcards & 0x100000) == 0;
                }
                case ARP_OP: {
                    return (this.wildcards & 0x20) == 0;
                }
                case ARP_SPA: {
                    return this.getIpv4SrcCidrMaskLen() >= 32;
                }
                case ARP_TPA: {
                    return this.getIpv4DstCidrMaskLen() >= 32;
                }
                case IP_DSCP: {
                    return (this.wildcards & 0x200000) == 0;
                }
                case IP_PROTO: {
                    return (this.wildcards & 0x20) == 0;
                }
                case IPV4_SRC: {
                    return this.getIpv4SrcCidrMaskLen() >= 32;
                }
                case IPV4_DST: {
                    return this.getIpv4DstCidrMaskLen() >= 32;
                }
                case TCP_SRC: {
                    return (this.wildcards & 0x40) == 0;
                }
                case TCP_DST: {
                    return (this.wildcards & 0x80) == 0;
                }
                case UDP_SRC: {
                    return (this.wildcards & 0x40) == 0;
                }
                case UDP_DST: {
                    return (this.wildcards & 0x80) == 0;
                }
                case SCTP_SRC: {
                    return (this.wildcards & 0x40) == 0;
                }
                case SCTP_DST: {
                    return (this.wildcards & 0x80) == 0;
                }
                case ICMPV4_TYPE: {
                    return (this.wildcards & 0x40) == 0;
                }
                case ICMPV4_CODE: {
                    return (this.wildcards & 0x80) == 0;
                }
            }
            throw new UnsupportedOperationException("OFMatch does not support matching on field " + field.getName());
        }

        public int getIpv4DstCidrMaskLen() {
            return Math.max(32 - ((this.wildcards & 0xFC000) >> 14), 0);
        }

        public int getIpv4SrcCidrMaskLen() {
            return Math.max(32 - ((this.wildcards & 0x3F00) >> 8), 0);
        }

        @Override
        public boolean isFullyWildcarded(MatchField<?> field) {
            switch (field.id) {
                case IN_PORT: {
                    return (this.wildcards & 1) != 0;
                }
                case ETH_DST: {
                    return (this.wildcards & 8) != 0;
                }
                case ETH_SRC: {
                    return (this.wildcards & 4) != 0;
                }
                case ETH_TYPE: {
                    return (this.wildcards & 0x10) != 0;
                }
                case VLAN_VID: {
                    return (this.wildcards & 2) != 0;
                }
                case VLAN_PCP: {
                    return (this.wildcards & 0x100000) != 0;
                }
                case ARP_OP: {
                    return (this.wildcards & 0x20) != 0;
                }
                case ARP_SPA: {
                    return this.getIpv4SrcCidrMaskLen() <= 0;
                }
                case ARP_TPA: {
                    return this.getIpv4DstCidrMaskLen() <= 0;
                }
                case IP_DSCP: {
                    return (this.wildcards & 0x200000) != 0;
                }
                case IP_PROTO: {
                    return (this.wildcards & 0x20) != 0;
                }
                case TCP_SRC: {
                    return (this.wildcards & 0x40) != 0;
                }
                case TCP_DST: {
                    return (this.wildcards & 0x80) != 0;
                }
                case UDP_SRC: {
                    return (this.wildcards & 0x40) != 0;
                }
                case UDP_DST: {
                    return (this.wildcards & 0x80) != 0;
                }
                case SCTP_SRC: {
                    return (this.wildcards & 0x40) != 0;
                }
                case SCTP_DST: {
                    return (this.wildcards & 0x80) != 0;
                }
                case ICMPV4_TYPE: {
                    return (this.wildcards & 0x40) != 0;
                }
                case ICMPV4_CODE: {
                    return (this.wildcards & 0x80) != 0;
                }
                case IPV4_SRC: {
                    return this.getIpv4SrcCidrMaskLen() <= 0;
                }
                case IPV4_DST: {
                    return this.getIpv4DstCidrMaskLen() <= 0;
                }
            }
            throw new UnsupportedOperationException("OFMatch does not support matching on field " + field.getName());
        }

        @Override
        public boolean isPartiallyMasked(MatchField<?> field) {
            switch (field.id) {
                case ARP_SPA: 
                case IPV4_SRC: {
                    int srcCidrLen = this.getIpv4SrcCidrMaskLen();
                    return srcCidrLen > 0 && srcCidrLen < 32;
                }
                case ARP_TPA: 
                case IPV4_DST: {
                    int dstCidrLen = this.getIpv4DstCidrMaskLen();
                    return dstCidrLen > 0 && dstCidrLen < 32;
                }
            }
            throw new UnsupportedOperationException("OFMatch does not support masked matching on field " + field.getName());
        }

        private final void initWildcards() {
            if (!this.wildcardsSet) {
                this.wildcards = 0x3FFFFF;
                this.wildcardsSet = true;
            }
        }

        @Override
        public <F extends OFValueType<F>> Match.Builder setExact(MatchField<F> field, F value) {
            this.initWildcards();
            F val = value;
            switch (field.id) {
                case ETH_DST: {
                    this.setEthDst((MacAddress)value);
                    this.wildcards &= 0xFFFFFFF7;
                    break;
                }
                case ETH_SRC: {
                    this.setEthSrc((MacAddress)value);
                    this.wildcards &= 0xFFFFFFFB;
                    break;
                }
                case ETH_TYPE: {
                    this.setEthType((EthType)value);
                    this.wildcards &= 0xFFFFFFEF;
                    break;
                }
                case ICMPV4_CODE: {
                    this.setTcpDst(TransportPort.of(((ICMPv4Code)value).getCode()));
                    this.wildcards &= 0xFFFFFF7F;
                    break;
                }
                case ICMPV4_TYPE: {
                    this.setTcpSrc(TransportPort.of(((ICMPv4Type)value).getType()));
                    this.wildcards &= 0xFFFFFFBF;
                    break;
                }
                case IN_PORT: {
                    this.setInPort((OFPort)value);
                    this.wildcards &= 0xFFFFFFFE;
                    break;
                }
                case ARP_OP: {
                    this.setIpProto(IpProtocol.of((short)((ArpOpcode)value).getOpcode()));
                    this.wildcards &= 0xFFFFFFDF;
                    break;
                }
                case ARP_TPA: 
                case IPV4_DST: {
                    this.setIpv4Dst((IPv4Address)value);
                    this.wildcards &= 0xFFF03FFF;
                    break;
                }
                case ARP_SPA: 
                case IPV4_SRC: {
                    this.setIpv4Src((IPv4Address)value);
                    this.wildcards &= 0xFFFFC0FF;
                    break;
                }
                case IP_DSCP: {
                    this.setIpDscp((IpDscp)value);
                    this.wildcards &= 0xFFDFFFFF;
                    break;
                }
                case IP_PROTO: {
                    this.setIpProto((IpProtocol)value);
                    this.wildcards &= 0xFFFFFFDF;
                    break;
                }
                case SCTP_DST: {
                    this.setTcpDst((TransportPort)value);
                    this.wildcards &= 0xFFFFFF7F;
                    break;
                }
                case SCTP_SRC: {
                    this.setTcpSrc((TransportPort)value);
                    this.wildcards &= 0xFFFFFFBF;
                    break;
                }
                case TCP_DST: {
                    this.setTcpDst((TransportPort)value);
                    this.wildcards &= 0xFFFFFF7F;
                    break;
                }
                case TCP_SRC: {
                    this.setTcpSrc((TransportPort)value);
                    this.wildcards &= 0xFFFFFFBF;
                    break;
                }
                case UDP_DST: {
                    this.setTcpDst((TransportPort)value);
                    this.wildcards &= 0xFFFFFF7F;
                    break;
                }
                case UDP_SRC: {
                    this.setTcpSrc((TransportPort)value);
                    this.wildcards &= 0xFFFFFFBF;
                    break;
                }
                case VLAN_PCP: {
                    this.setVlanPcp((VlanPcp)value);
                    this.wildcards &= 0xFFEFFFFF;
                    break;
                }
                case VLAN_VID: {
                    this.setVlanVid((OFVlanVidMatch)value);
                    this.wildcards &= 0xFFFFFFFD;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("OFMatch does not support matching on field " + field.getName());
                }
            }
            return this;
        }

        @Override
        public <F extends OFValueType<F>> Match.Builder setMasked(MatchField<F> field, F value, F mask) {
            this.initWildcards();
            block0 : switch (field.id) {
                case ARP_SPA: 
                case ARP_TPA: 
                case IPV4_SRC: 
                case IPV4_DST: {
                    F valObj = value;
                    F masObj = mask;
                    IPv4Address ip = (IPv4Address)valObj;
                    int maskval = ((IPv4Address)masObj).getInt();
                    if (Integer.bitCount(~maskval + 1) != 1) {
                        throw new UnsupportedOperationException("OFMatch only supports CIDR masks for IPv4");
                    }
                    int maskLen = 32 - Integer.bitCount(maskval);
                    switch (field.id) {
                        case ARP_TPA: 
                        case IPV4_DST: {
                            this.setIpv4Dst(ip);
                            this.wildcards = this.wildcards & 0xFFF03FFF | maskLen << 14;
                            break block0;
                        }
                        case ARP_SPA: 
                        case IPV4_SRC: {
                            this.setIpv4Src(ip);
                            this.wildcards = this.wildcards & 0xFFFFC0FF | maskLen << 8;
                            break block0;
                        }
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("OFMatch does not support masked matching on field " + field.getName());
                }
            }
            return this;
        }

        @Override
        public <F extends OFValueType<F>> Match.Builder setMasked(MatchField<F> field, Masked<F> valueWithMask) throws UnsupportedOperationException {
            return this.setMasked(field, valueWithMask.getValue(), valueWithMask.getMask());
        }

        @Override
        public <F extends OFValueType<F>> Match.Builder wildcard(MatchField<F> field) {
            this.initWildcards();
            switch (field.id) {
                case ETH_DST: {
                    this.setEthDst(MacAddress.NONE);
                    this.wildcards |= 8;
                    break;
                }
                case ETH_SRC: {
                    this.setEthSrc(MacAddress.NONE);
                    this.wildcards |= 4;
                    break;
                }
                case ETH_TYPE: {
                    this.setEthType(EthType.NONE);
                    this.wildcards |= 0x10;
                    break;
                }
                case TCP_DST: 
                case UDP_DST: 
                case SCTP_DST: 
                case ICMPV4_CODE: {
                    this.setTcpDst(TransportPort.NONE);
                    this.wildcards |= 0x80;
                    break;
                }
                case TCP_SRC: 
                case UDP_SRC: 
                case SCTP_SRC: 
                case ICMPV4_TYPE: {
                    this.setTcpSrc(TransportPort.NONE);
                    this.wildcards |= 0x40;
                    break;
                }
                case IN_PORT: {
                    this.setInPort(OFPort.of(0));
                    this.wildcards |= 1;
                    break;
                }
                case ARP_TPA: 
                case IPV4_DST: {
                    this.setIpv4Dst(IPv4Address.NONE);
                    this.wildcards |= 0xFC000;
                    break;
                }
                case ARP_SPA: 
                case IPV4_SRC: {
                    this.setIpv4Src(IPv4Address.NONE);
                    this.wildcards |= 0x3F00;
                    break;
                }
                case IP_DSCP: {
                    this.setIpDscp(IpDscp.NONE);
                    this.wildcards |= 0x200000;
                    break;
                }
                case IP_PROTO: {
                    this.setIpProto(IpProtocol.NONE);
                    this.wildcards |= 0x20;
                    break;
                }
                case VLAN_PCP: {
                    this.setVlanPcp(VlanPcp.NONE);
                    this.wildcards |= 0x100000;
                    break;
                }
                case VLAN_VID: {
                    this.setVlanVid(OFVlanVidMatch.NONE);
                    this.wildcards |= 2;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("OFMatch does not support matching on field " + field.getName());
                }
            }
            return this;
        }
    }

    static class BuilderWithParent
    implements OFMatchV1.Builder {
        final OFMatchV1Ver10 parentMessage;
        private boolean wildcardsSet;
        private int wildcards;
        private boolean inPortSet;
        private OFPort inPort;
        private boolean ethSrcSet;
        private MacAddress ethSrc;
        private boolean ethDstSet;
        private MacAddress ethDst;
        private boolean vlanVidSet;
        private OFVlanVidMatch vlanVid;
        private boolean vlanPcpSet;
        private VlanPcp vlanPcp;
        private boolean ethTypeSet;
        private EthType ethType;
        private boolean ipDscpSet;
        private IpDscp ipDscp;
        private boolean ipProtoSet;
        private IpProtocol ipProto;
        private boolean ipv4SrcSet;
        private IPv4Address ipv4Src;
        private boolean ipv4DstSet;
        private IPv4Address ipv4Dst;
        private boolean tcpSrcSet;
        private TransportPort tcpSrc;
        private boolean tcpDstSet;
        private TransportPort tcpDst;

        BuilderWithParent(OFMatchV1Ver10 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getWildcards() {
            return this.wildcards;
        }

        @Override
        public OFMatchV1.Builder setWildcards(int wildcards) {
            this.wildcards = wildcards;
            this.wildcardsSet = true;
            return this;
        }

        @Override
        public OFPort getInPort() {
            return this.inPort;
        }

        @Override
        public OFMatchV1.Builder setInPort(OFPort inPort) {
            this.inPort = inPort;
            this.inPortSet = true;
            return this;
        }

        @Override
        public MacAddress getEthSrc() {
            return this.ethSrc;
        }

        @Override
        public OFMatchV1.Builder setEthSrc(MacAddress ethSrc) {
            this.ethSrc = ethSrc;
            this.ethSrcSet = true;
            return this;
        }

        @Override
        public MacAddress getEthDst() {
            return this.ethDst;
        }

        @Override
        public OFMatchV1.Builder setEthDst(MacAddress ethDst) {
            this.ethDst = ethDst;
            this.ethDstSet = true;
            return this;
        }

        @Override
        public OFVlanVidMatch getVlanVid() {
            return this.vlanVid;
        }

        @Override
        public OFMatchV1.Builder setVlanVid(OFVlanVidMatch vlanVid) {
            this.vlanVid = vlanVid;
            this.vlanVidSet = true;
            return this;
        }

        @Override
        public VlanPcp getVlanPcp() {
            return this.vlanPcp;
        }

        @Override
        public OFMatchV1.Builder setVlanPcp(VlanPcp vlanPcp) {
            this.vlanPcp = vlanPcp;
            this.vlanPcpSet = true;
            return this;
        }

        @Override
        public EthType getEthType() {
            return this.ethType;
        }

        @Override
        public OFMatchV1.Builder setEthType(EthType ethType) {
            this.ethType = ethType;
            this.ethTypeSet = true;
            return this;
        }

        @Override
        public IpDscp getIpDscp() {
            return this.ipDscp;
        }

        @Override
        public OFMatchV1.Builder setIpDscp(IpDscp ipDscp) {
            this.ipDscp = ipDscp;
            this.ipDscpSet = true;
            return this;
        }

        @Override
        public IpProtocol getIpProto() {
            return this.ipProto;
        }

        @Override
        public OFMatchV1.Builder setIpProto(IpProtocol ipProto) {
            this.ipProto = ipProto;
            this.ipProtoSet = true;
            return this;
        }

        @Override
        public IPv4Address getIpv4Src() {
            return this.ipv4Src;
        }

        @Override
        public OFMatchV1.Builder setIpv4Src(IPv4Address ipv4Src) {
            this.ipv4Src = ipv4Src;
            this.ipv4SrcSet = true;
            return this;
        }

        @Override
        public IPv4Address getIpv4Dst() {
            return this.ipv4Dst;
        }

        @Override
        public OFMatchV1.Builder setIpv4Dst(IPv4Address ipv4Dst) {
            this.ipv4Dst = ipv4Dst;
            this.ipv4DstSet = true;
            return this;
        }

        @Override
        public TransportPort getTcpSrc() {
            return this.tcpSrc;
        }

        @Override
        public OFMatchV1.Builder setTcpSrc(TransportPort tcpSrc) {
            this.tcpSrc = tcpSrc;
            this.tcpSrcSet = true;
            return this;
        }

        @Override
        public TransportPort getTcpDst() {
            return this.tcpDst;
        }

        @Override
        public OFMatchV1.Builder setTcpDst(TransportPort tcpDst) {
            this.tcpDst = tcpDst;
            this.tcpDstSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFMatchV1 build() {
            TransportPort tcpDst;
            TransportPort tcpSrc;
            IPv4Address ipv4Dst;
            IPv4Address ipv4Src;
            IpProtocol ipProto;
            IpDscp ipDscp;
            EthType ethType;
            VlanPcp vlanPcp;
            OFVlanVidMatch vlanVid;
            MacAddress ethDst;
            MacAddress ethSrc;
            OFPort inPort;
            int wildcards = this.wildcardsSet ? this.wildcards : this.parentMessage.wildcards;
            OFPort oFPort = inPort = this.inPortSet ? this.inPort : this.parentMessage.inPort;
            if (inPort == null) {
                throw new NullPointerException("Property inPort must not be null");
            }
            MacAddress macAddress = ethSrc = this.ethSrcSet ? this.ethSrc : this.parentMessage.ethSrc;
            if (ethSrc == null) {
                throw new NullPointerException("Property ethSrc must not be null");
            }
            MacAddress macAddress2 = ethDst = this.ethDstSet ? this.ethDst : this.parentMessage.ethDst;
            if (ethDst == null) {
                throw new NullPointerException("Property ethDst must not be null");
            }
            OFVlanVidMatch oFVlanVidMatch = vlanVid = this.vlanVidSet ? this.vlanVid : this.parentMessage.vlanVid;
            if (vlanVid == null) {
                throw new NullPointerException("Property vlanVid must not be null");
            }
            VlanPcp vlanPcp2 = vlanPcp = this.vlanPcpSet ? this.vlanPcp : this.parentMessage.vlanPcp;
            if (vlanPcp == null) {
                throw new NullPointerException("Property vlanPcp must not be null");
            }
            EthType ethType2 = ethType = this.ethTypeSet ? this.ethType : this.parentMessage.ethType;
            if (ethType == null) {
                throw new NullPointerException("Property ethType must not be null");
            }
            IpDscp ipDscp2 = ipDscp = this.ipDscpSet ? this.ipDscp : this.parentMessage.ipDscp;
            if (ipDscp == null) {
                throw new NullPointerException("Property ipDscp must not be null");
            }
            IpProtocol ipProtocol = ipProto = this.ipProtoSet ? this.ipProto : this.parentMessage.ipProto;
            if (ipProto == null) {
                throw new NullPointerException("Property ipProto must not be null");
            }
            IPv4Address iPv4Address = ipv4Src = this.ipv4SrcSet ? this.ipv4Src : this.parentMessage.ipv4Src;
            if (ipv4Src == null) {
                throw new NullPointerException("Property ipv4Src must not be null");
            }
            IPv4Address iPv4Address2 = ipv4Dst = this.ipv4DstSet ? this.ipv4Dst : this.parentMessage.ipv4Dst;
            if (ipv4Dst == null) {
                throw new NullPointerException("Property ipv4Dst must not be null");
            }
            TransportPort transportPort = tcpSrc = this.tcpSrcSet ? this.tcpSrc : this.parentMessage.tcpSrc;
            if (tcpSrc == null) {
                throw new NullPointerException("Property tcpSrc must not be null");
            }
            TransportPort transportPort2 = tcpDst = this.tcpDstSet ? this.tcpDst : this.parentMessage.tcpDst;
            if (tcpDst == null) {
                throw new NullPointerException("Property tcpDst must not be null");
            }
            if (ethType.equals(EthType.IPv4)) {
                if (ipProto.equals(IpProtocol.TCP) || ipProto.equals(IpProtocol.UDP) || ipProto.equals(IpProtocol.ICMP)) {
                    if ((wildcards & 0x2000) != 0) {
                        wildcards |= 0x3F00;
                    }
                    if ((wildcards & 0x80000) != 0) {
                        wildcards |= 0xFC000;
                    }
                } else {
                    if ((wildcards & 0x2000) != 0) {
                        wildcards |= 0x3F00;
                    }
                    if ((wildcards & 0x80000) != 0) {
                        wildcards |= 0xFC000;
                    }
                    wildcards |= 0xC0;
                    tcpSrc = TransportPort.NONE;
                    tcpDst = TransportPort.NONE;
                }
            } else if (ethType.equals(EthType.ARP)) {
                if ((wildcards & 0x2000) != 0) {
                    wildcards |= 0x3F00;
                }
                if ((wildcards & 0x80000) != 0) {
                    wildcards |= 0xFC000;
                }
                wildcards |= 0x2000C0;
                ipDscp = IpDscp.NONE;
                tcpSrc = TransportPort.NONE;
                tcpDst = TransportPort.NONE;
            } else {
                wildcards |= 0x2FFFE0;
                ipDscp = IpDscp.NONE;
                ipProto = IpProtocol.NONE;
                ipv4Src = IPv4Address.NONE;
                ipv4Dst = IPv4Address.NONE;
                tcpSrc = TransportPort.NONE;
                tcpDst = TransportPort.NONE;
            }
            return new OFMatchV1Ver10(wildcards, inPort, ethSrc, ethDst, vlanVid, vlanPcp, ethType, ipDscp, ipProto, ipv4Src, ipv4Dst, tcpSrc, tcpDst);
        }

        @Override
        public <F extends OFValueType<F>> F get(MatchField<F> field) throws UnsupportedOperationException {
            OFValueType<OFPort> result;
            if (this.isFullyWildcarded(field)) {
                return null;
            }
            switch (field.id) {
                case IN_PORT: {
                    result = this.inPort;
                    break;
                }
                case ETH_DST: {
                    result = this.ethDst;
                    break;
                }
                case ETH_SRC: {
                    result = this.ethSrc;
                    break;
                }
                case ETH_TYPE: {
                    result = this.ethType;
                    break;
                }
                case VLAN_VID: {
                    result = this.vlanVid;
                    break;
                }
                case VLAN_PCP: {
                    result = this.vlanPcp;
                    break;
                }
                case ARP_OP: {
                    result = ArpOpcode.of(this.ipProto.getIpProtocolNumber());
                    break;
                }
                case ARP_SPA: {
                    result = this.ipv4Src;
                    break;
                }
                case ARP_TPA: {
                    result = this.ipv4Dst;
                    break;
                }
                case IP_DSCP: {
                    result = this.ipDscp;
                    break;
                }
                case IP_PROTO: {
                    result = this.ipProto;
                    break;
                }
                case IPV4_SRC: {
                    result = this.ipv4Src;
                    break;
                }
                case IPV4_DST: {
                    result = this.ipv4Dst;
                    break;
                }
                case TCP_SRC: {
                    result = this.tcpSrc;
                    break;
                }
                case TCP_DST: {
                    result = this.tcpDst;
                    break;
                }
                case UDP_SRC: {
                    result = this.tcpSrc;
                    break;
                }
                case UDP_DST: {
                    result = this.tcpDst;
                    break;
                }
                case SCTP_SRC: {
                    result = this.tcpSrc;
                    break;
                }
                case SCTP_DST: {
                    result = this.tcpDst;
                    break;
                }
                case ICMPV4_TYPE: {
                    result = ICMPv4Type.of((short)this.tcpSrc.getPort());
                    break;
                }
                case ICMPV4_CODE: {
                    result = ICMPv4Code.of((short)this.tcpDst.getPort());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("OFMatch does not support matching on field " + field.getName());
                }
            }
            return (F)result;
        }

        @Override
        public <F extends OFValueType<F>> Masked<F> getMasked(MatchField<F> field) throws UnsupportedOperationException {
            IPv4AddressWithMask result;
            if (!this.isPartiallyMasked(field)) {
                return null;
            }
            switch (field.id) {
                case ARP_SPA: 
                case IPV4_SRC: {
                    int srcBitMask = -1 << 32 - this.getIpv4SrcCidrMaskLen();
                    result = IPv4AddressWithMask.of(this.ipv4Src, IPv4Address.of(srcBitMask));
                    break;
                }
                case ARP_TPA: 
                case IPV4_DST: {
                    int dstMaskedBits = Math.min(32, (this.wildcards & 0xFC000) >> 14);
                    int dstBitMask = -1 << 32 - this.getIpv4DstCidrMaskLen();
                    result = IPv4AddressWithMask.of(this.ipv4Dst, IPv4Address.of(dstBitMask));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("OFMatch does not support masked matching on field " + field.getName());
                }
            }
            return result;
        }

        @Override
        public boolean supports(MatchField<?> field) {
            switch (field.id) {
                case IN_PORT: 
                case ETH_DST: 
                case ETH_SRC: 
                case ETH_TYPE: 
                case VLAN_VID: 
                case VLAN_PCP: 
                case ARP_OP: 
                case ARP_SPA: 
                case ARP_TPA: 
                case IP_DSCP: 
                case IP_PROTO: 
                case IPV4_SRC: 
                case IPV4_DST: 
                case TCP_SRC: 
                case TCP_DST: 
                case UDP_SRC: 
                case UDP_DST: 
                case SCTP_SRC: 
                case SCTP_DST: 
                case ICMPV4_TYPE: 
                case ICMPV4_CODE: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean supportsMasked(MatchField<?> field) {
            switch (field.id) {
                case ARP_SPA: 
                case ARP_TPA: 
                case IPV4_SRC: 
                case IPV4_DST: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isExact(MatchField<?> field) {
            switch (field.id) {
                case IN_PORT: {
                    return (this.wildcards & 1) == 0;
                }
                case ETH_DST: {
                    return (this.wildcards & 8) == 0;
                }
                case ETH_SRC: {
                    return (this.wildcards & 4) == 0;
                }
                case ETH_TYPE: {
                    return (this.wildcards & 0x10) == 0;
                }
                case VLAN_VID: {
                    return (this.wildcards & 2) == 0;
                }
                case VLAN_PCP: {
                    return (this.wildcards & 0x100000) == 0;
                }
                case ARP_OP: {
                    return (this.wildcards & 0x20) == 0;
                }
                case ARP_SPA: {
                    return this.getIpv4SrcCidrMaskLen() >= 32;
                }
                case ARP_TPA: {
                    return this.getIpv4DstCidrMaskLen() >= 32;
                }
                case IP_DSCP: {
                    return (this.wildcards & 0x200000) == 0;
                }
                case IP_PROTO: {
                    return (this.wildcards & 0x20) == 0;
                }
                case IPV4_SRC: {
                    return this.getIpv4SrcCidrMaskLen() >= 32;
                }
                case IPV4_DST: {
                    return this.getIpv4DstCidrMaskLen() >= 32;
                }
                case TCP_SRC: {
                    return (this.wildcards & 0x40) == 0;
                }
                case TCP_DST: {
                    return (this.wildcards & 0x80) == 0;
                }
                case UDP_SRC: {
                    return (this.wildcards & 0x40) == 0;
                }
                case UDP_DST: {
                    return (this.wildcards & 0x80) == 0;
                }
                case SCTP_SRC: {
                    return (this.wildcards & 0x40) == 0;
                }
                case SCTP_DST: {
                    return (this.wildcards & 0x80) == 0;
                }
                case ICMPV4_TYPE: {
                    return (this.wildcards & 0x40) == 0;
                }
                case ICMPV4_CODE: {
                    return (this.wildcards & 0x80) == 0;
                }
            }
            throw new UnsupportedOperationException("OFMatch does not support matching on field " + field.getName());
        }

        public int getIpv4DstCidrMaskLen() {
            return Math.max(32 - ((this.wildcards & 0xFC000) >> 14), 0);
        }

        public int getIpv4SrcCidrMaskLen() {
            return Math.max(32 - ((this.wildcards & 0x3F00) >> 8), 0);
        }

        @Override
        public boolean isFullyWildcarded(MatchField<?> field) {
            switch (field.id) {
                case IN_PORT: {
                    return (this.wildcards & 1) != 0;
                }
                case ETH_DST: {
                    return (this.wildcards & 8) != 0;
                }
                case ETH_SRC: {
                    return (this.wildcards & 4) != 0;
                }
                case ETH_TYPE: {
                    return (this.wildcards & 0x10) != 0;
                }
                case VLAN_VID: {
                    return (this.wildcards & 2) != 0;
                }
                case VLAN_PCP: {
                    return (this.wildcards & 0x100000) != 0;
                }
                case ARP_OP: {
                    return (this.wildcards & 0x20) != 0;
                }
                case ARP_SPA: {
                    return this.getIpv4SrcCidrMaskLen() <= 0;
                }
                case ARP_TPA: {
                    return this.getIpv4DstCidrMaskLen() <= 0;
                }
                case IP_DSCP: {
                    return (this.wildcards & 0x200000) != 0;
                }
                case IP_PROTO: {
                    return (this.wildcards & 0x20) != 0;
                }
                case TCP_SRC: {
                    return (this.wildcards & 0x40) != 0;
                }
                case TCP_DST: {
                    return (this.wildcards & 0x80) != 0;
                }
                case UDP_SRC: {
                    return (this.wildcards & 0x40) != 0;
                }
                case UDP_DST: {
                    return (this.wildcards & 0x80) != 0;
                }
                case SCTP_SRC: {
                    return (this.wildcards & 0x40) != 0;
                }
                case SCTP_DST: {
                    return (this.wildcards & 0x80) != 0;
                }
                case ICMPV4_TYPE: {
                    return (this.wildcards & 0x40) != 0;
                }
                case ICMPV4_CODE: {
                    return (this.wildcards & 0x80) != 0;
                }
                case IPV4_SRC: {
                    return this.getIpv4SrcCidrMaskLen() <= 0;
                }
                case IPV4_DST: {
                    return this.getIpv4DstCidrMaskLen() <= 0;
                }
            }
            throw new UnsupportedOperationException("OFMatch does not support matching on field " + field.getName());
        }

        @Override
        public boolean isPartiallyMasked(MatchField<?> field) {
            switch (field.id) {
                case ARP_SPA: 
                case IPV4_SRC: {
                    int srcCidrLen = this.getIpv4SrcCidrMaskLen();
                    return srcCidrLen > 0 && srcCidrLen < 32;
                }
                case ARP_TPA: 
                case IPV4_DST: {
                    int dstCidrLen = this.getIpv4DstCidrMaskLen();
                    return dstCidrLen > 0 && dstCidrLen < 32;
                }
            }
            throw new UnsupportedOperationException("OFMatch does not support masked matching on field " + field.getName());
        }

        private final void initWildcards() {
            if (!this.wildcardsSet) {
                this.wildcards = this.parentMessage.wildcards;
                this.wildcardsSet = true;
            }
        }

        @Override
        public <F extends OFValueType<F>> Match.Builder setExact(MatchField<F> field, F value) {
            this.initWildcards();
            F val = value;
            switch (field.id) {
                case ETH_DST: {
                    this.setEthDst((MacAddress)value);
                    this.wildcards &= 0xFFFFFFF7;
                    break;
                }
                case ETH_SRC: {
                    this.setEthSrc((MacAddress)value);
                    this.wildcards &= 0xFFFFFFFB;
                    break;
                }
                case ETH_TYPE: {
                    this.setEthType((EthType)value);
                    this.wildcards &= 0xFFFFFFEF;
                    break;
                }
                case ICMPV4_CODE: {
                    this.setTcpDst(TransportPort.of(((ICMPv4Code)value).getCode()));
                    this.wildcards &= 0xFFFFFF7F;
                    break;
                }
                case ICMPV4_TYPE: {
                    this.setTcpSrc(TransportPort.of(((ICMPv4Type)value).getType()));
                    this.wildcards &= 0xFFFFFFBF;
                    break;
                }
                case IN_PORT: {
                    this.setInPort((OFPort)value);
                    this.wildcards &= 0xFFFFFFFE;
                    break;
                }
                case ARP_OP: {
                    this.setIpProto(IpProtocol.of((short)((ArpOpcode)value).getOpcode()));
                    this.wildcards &= 0xFFFFFFDF;
                    break;
                }
                case ARP_TPA: 
                case IPV4_DST: {
                    this.setIpv4Dst((IPv4Address)value);
                    this.wildcards &= 0xFFF03FFF;
                    break;
                }
                case ARP_SPA: 
                case IPV4_SRC: {
                    this.setIpv4Src((IPv4Address)value);
                    this.wildcards &= 0xFFFFC0FF;
                    break;
                }
                case IP_DSCP: {
                    this.setIpDscp((IpDscp)value);
                    this.wildcards &= 0xFFDFFFFF;
                    break;
                }
                case IP_PROTO: {
                    this.setIpProto((IpProtocol)value);
                    this.wildcards &= 0xFFFFFFDF;
                    break;
                }
                case SCTP_DST: {
                    this.setTcpDst((TransportPort)value);
                    this.wildcards &= 0xFFFFFF7F;
                    break;
                }
                case SCTP_SRC: {
                    this.setTcpSrc((TransportPort)value);
                    this.wildcards &= 0xFFFFFFBF;
                    break;
                }
                case TCP_DST: {
                    this.setTcpDst((TransportPort)value);
                    this.wildcards &= 0xFFFFFF7F;
                    break;
                }
                case TCP_SRC: {
                    this.setTcpSrc((TransportPort)value);
                    this.wildcards &= 0xFFFFFFBF;
                    break;
                }
                case UDP_DST: {
                    this.setTcpDst((TransportPort)value);
                    this.wildcards &= 0xFFFFFF7F;
                    break;
                }
                case UDP_SRC: {
                    this.setTcpSrc((TransportPort)value);
                    this.wildcards &= 0xFFFFFFBF;
                    break;
                }
                case VLAN_PCP: {
                    this.setVlanPcp((VlanPcp)value);
                    this.wildcards &= 0xFFEFFFFF;
                    break;
                }
                case VLAN_VID: {
                    this.setVlanVid((OFVlanVidMatch)value);
                    this.wildcards &= 0xFFFFFFFD;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("OFMatch does not support matching on field " + field.getName());
                }
            }
            return this;
        }

        @Override
        public <F extends OFValueType<F>> Match.Builder setMasked(MatchField<F> field, F value, F mask) {
            this.initWildcards();
            block0 : switch (field.id) {
                case ARP_SPA: 
                case ARP_TPA: 
                case IPV4_SRC: 
                case IPV4_DST: {
                    F valObj = value;
                    F masObj = mask;
                    IPv4Address ip = (IPv4Address)valObj;
                    int maskval = ((IPv4Address)masObj).getInt();
                    if (Integer.bitCount(~maskval + 1) != 1) {
                        throw new UnsupportedOperationException("OFMatch only supports CIDR masks for IPv4");
                    }
                    int maskLen = 32 - Integer.bitCount(maskval);
                    switch (field.id) {
                        case ARP_TPA: 
                        case IPV4_DST: {
                            this.setIpv4Dst(ip);
                            this.wildcards = this.wildcards & 0xFFF03FFF | maskLen << 14;
                            break block0;
                        }
                        case ARP_SPA: 
                        case IPV4_SRC: {
                            this.setIpv4Src(ip);
                            this.wildcards = this.wildcards & 0xFFFFC0FF | maskLen << 8;
                            break block0;
                        }
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("OFMatch does not support masked matching on field " + field.getName());
                }
            }
            return this;
        }

        @Override
        public <F extends OFValueType<F>> Match.Builder setMasked(MatchField<F> field, Masked<F> valueWithMask) throws UnsupportedOperationException {
            return this.setMasked(field, valueWithMask.getValue(), valueWithMask.getMask());
        }

        @Override
        public <F extends OFValueType<F>> Match.Builder wildcard(MatchField<F> field) {
            this.initWildcards();
            switch (field.id) {
                case ETH_DST: {
                    this.setEthDst(MacAddress.NONE);
                    this.wildcards |= 8;
                    break;
                }
                case ETH_SRC: {
                    this.setEthSrc(MacAddress.NONE);
                    this.wildcards |= 4;
                    break;
                }
                case ETH_TYPE: {
                    this.setEthType(EthType.NONE);
                    this.wildcards |= 0x10;
                    break;
                }
                case TCP_DST: 
                case UDP_DST: 
                case SCTP_DST: 
                case ICMPV4_CODE: {
                    this.setTcpDst(TransportPort.NONE);
                    this.wildcards |= 0x80;
                    break;
                }
                case TCP_SRC: 
                case UDP_SRC: 
                case SCTP_SRC: 
                case ICMPV4_TYPE: {
                    this.setTcpSrc(TransportPort.NONE);
                    this.wildcards |= 0x40;
                    break;
                }
                case IN_PORT: {
                    this.setInPort(OFPort.of(0));
                    this.wildcards |= 1;
                    break;
                }
                case ARP_TPA: 
                case IPV4_DST: {
                    this.setIpv4Dst(IPv4Address.NONE);
                    this.wildcards |= 0xFC000;
                    break;
                }
                case ARP_SPA: 
                case IPV4_SRC: {
                    this.setIpv4Src(IPv4Address.NONE);
                    this.wildcards |= 0x3F00;
                    break;
                }
                case IP_DSCP: {
                    this.setIpDscp(IpDscp.NONE);
                    this.wildcards |= 0x200000;
                    break;
                }
                case IP_PROTO: {
                    this.setIpProto(IpProtocol.NONE);
                    this.wildcards |= 0x20;
                    break;
                }
                case VLAN_PCP: {
                    this.setVlanPcp(VlanPcp.NONE);
                    this.wildcards |= 0x100000;
                    break;
                }
                case VLAN_VID: {
                    this.setVlanVid(OFVlanVidMatch.NONE);
                    this.wildcards |= 2;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("OFMatch does not support matching on field " + field.getName());
                }
            }
            return this;
        }
    }
}

