/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnHybridGetRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnHybridGetRequestVer10
implements OFBsnHybridGetRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnHybridGetRequestVer10.class);
    static final byte WIRE_VERSION = 1;
    static final int LENGTH = 16;
    private static final long DEFAULT_XID = 0L;
    private final long xid;
    static final OFBsnHybridGetRequestVer10 DEFAULT = new OFBsnHybridGetRequestVer10(0L);
    static final Reader READER = new Reader();
    static final OFBsnHybridGetRequestVer10Funnel FUNNEL = new OFBsnHybridGetRequestVer10Funnel();
    static final Writer WRITER = new Writer();

    OFBsnHybridGetRequestVer10(long xid) {
        this.xid = xid;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_10;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 27L;
    }

    @Override
    public OFBsnHybridGetRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnHybridGetRequestVer10(");
        b.append("xid=").append(this.xid);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnHybridGetRequestVer10 other = (OFBsnHybridGetRequestVer10)obj;
        return this.xid == other.xid;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnHybridGetRequestVer10 other = (OFBsnHybridGetRequestVer10)obj;
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnHybridGetRequestVer10> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnHybridGetRequestVer10 message) {
            bb.writeByte(1);
            bb.writeByte(4);
            bb.writeShort(16);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(27);
        }
    }

    static class OFBsnHybridGetRequestVer10Funnel
    implements Funnel<OFBsnHybridGetRequestVer10> {
        private static final long serialVersionUID = 1L;

        OFBsnHybridGetRequestVer10Funnel() {
        }

        public void funnel(OFBsnHybridGetRequestVer10 message, PrimitiveSink sink) {
            sink.putByte((byte)1);
            sink.putByte((byte)4);
            sink.putShort((short)16);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(27);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnHybridGetRequest> {
        Reader() {
        }

        @Override
        public OFBsnHybridGetRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 1) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_10(1), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 27) {
                throw new OFParseError("Wrong subtype: Expected=0x1bL(0x1bL), got=" + subtype);
            }
            OFBsnHybridGetRequestVer10 bsnHybridGetRequestVer10 = new OFBsnHybridGetRequestVer10(xid);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnHybridGetRequestVer10);
            }
            return bsnHybridGetRequestVer10;
        }
    }

    static class Builder
    implements OFBsnHybridGetRequest.Builder {
        private boolean xidSet;
        private long xid;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnHybridGetRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 27L;
        }

        @Override
        public OFBsnHybridGetRequest build() {
            long xid = this.xidSet ? this.xid : 0L;
            return new OFBsnHybridGetRequestVer10(xid);
        }
    }

    static class BuilderWithParent
    implements OFBsnHybridGetRequest.Builder {
        final OFBsnHybridGetRequestVer10 parentMessage;
        private boolean xidSet;
        private long xid;

        BuilderWithParent(OFBsnHybridGetRequestVer10 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnHybridGetRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 27L;
        }

        @Override
        public OFBsnHybridGetRequest build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            return new OFBsnHybridGetRequestVer10(xid);
        }
    }
}

