/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.protocol.match;

import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.projectfloodlight.openflow.protocol.OFFactories;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.types.EthType;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.OFValueType;

@RunWith(value=Parameterized.class)
public class OFMatchPrerequisitesTest {
    private final OFFactory factory;

    @Parameterized.Parameters(name="{index}.ChannelHandlerVersion={0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({OFVersion.OF_10}, {OFVersion.OF_13}, {OFVersion.OF_14});
    }

    public OFMatchPrerequisitesTest(OFVersion version) {
        this.factory = OFFactories.getFactory((OFVersion)version);
    }

    @Test
    public void testPreRequisitesNotMet() {
        Match match = this.factory.buildMatch().setExact(MatchField.ETH_TYPE, (OFValueType)EthType.IPv6).setExact(MatchField.IPV4_SRC, (OFValueType)IPv4Address.of((String)"1.2.3.4")).build();
        Assert.assertThat((Object)match.get(MatchField.ETH_TYPE), (Matcher)CoreMatchers.equalTo((Object)EthType.IPv6));
        Assert.assertThat((Object)match.isExact(MatchField.ETH_TYPE), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)match.isPartiallyMasked(MatchField.ETH_TYPE), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)match.isFullyWildcarded(MatchField.ETH_TYPE), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)match.get(MatchField.IPV4_SRC), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)match.isExact(MatchField.IPV4_SRC), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)match.isPartiallyMasked(MatchField.IPV4_SRC), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)match.isFullyWildcarded(MatchField.IPV4_SRC), (Matcher)CoreMatchers.equalTo((Object)true));
        Iterable matchFields = match.getMatchFields();
        Assert.assertThat((Object)matchFields, (Matcher)Matchers.iterableWithSize((int)1));
        Assert.assertThat((Object)matchFields, (Matcher)Matchers.contains((Object[])new MatchField[]{MatchField.ETH_TYPE}));
    }

    @Test
    public void testPreRequisitesMet() {
        Match match = this.factory.buildMatch().setExact(MatchField.ETH_TYPE, (OFValueType)EthType.IPv4).setExact(MatchField.IPV4_SRC, (OFValueType)IPv4Address.of((String)"1.2.3.4")).build();
        Assert.assertThat((Object)match.get(MatchField.ETH_TYPE), (Matcher)CoreMatchers.equalTo((Object)EthType.IPv4));
        Assert.assertThat((Object)match.isExact(MatchField.ETH_TYPE), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)match.isPartiallyMasked(MatchField.ETH_TYPE), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)match.isFullyWildcarded(MatchField.ETH_TYPE), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)match.get(MatchField.IPV4_SRC), (Matcher)CoreMatchers.equalTo((Object)IPv4Address.of((String)"1.2.3.4")));
        Assert.assertThat((Object)match.isExact(MatchField.IPV4_SRC), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)match.isPartiallyMasked(MatchField.IPV4_SRC), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)match.isFullyWildcarded(MatchField.IPV4_SRC), (Matcher)CoreMatchers.equalTo((Object)false));
        Iterable matchFields = match.getMatchFields();
        Assert.assertThat((Object)matchFields, (Matcher)Matchers.iterableWithSize((int)2));
        Assert.assertThat((Object)matchFields, (Matcher)Matchers.contains((Object[])new MatchField[]{MatchField.ETH_TYPE, MatchField.IPV4_SRC}));
    }
}

