/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.protocol;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactories;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmIpv4Src;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmIpv4SrcMasked;
import org.projectfloodlight.openflow.protocol.oxm.OFOxms;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.IPv4AddressWithMask;

public class OFOxmTest {
    private OFOxms oxms;

    @Before
    public void setup() {
        this.oxms = OFFactories.getFactory((OFVersion)OFVersion.OF_13).oxms();
    }

    @Test
    public void testGetCanonicalFullMask() {
        IPv4AddressWithMask empty = IPv4AddressWithMask.of((String)"0.0.0.0/0");
        Assert.assertEquals((Object)IPv4Address.FULL_MASK, (Object)empty.getMask());
        OFOxmIpv4SrcMasked ipv4SrcMasked = this.oxms.ipv4SrcMasked((IPv4Address)empty.getValue(), (IPv4Address)empty.getMask());
        Assert.assertNull((Object)ipv4SrcMasked.getCanonical());
    }

    @Test
    public void testGetCanonicalNoMask() {
        IPv4AddressWithMask fullIp = IPv4AddressWithMask.of((String)"1.2.3.4/32");
        Assert.assertEquals((Object)IPv4Address.NO_MASK, (Object)fullIp.getMask());
        OFOxmIpv4SrcMasked ipv4SrcMasked = this.oxms.ipv4SrcMasked((IPv4Address)fullIp.getValue(), (IPv4Address)fullIp.getMask());
        Assert.assertTrue((boolean)ipv4SrcMasked.isMasked());
        Assert.assertEquals((Object)IPv4Address.NO_MASK, (Object)ipv4SrcMasked.getMask());
        OFOxm canonical = ipv4SrcMasked.getCanonical();
        Assert.assertThat((Object)canonical, (Matcher)CoreMatchers.instanceOf(OFOxmIpv4Src.class));
        Assert.assertFalse((boolean)canonical.isMasked());
    }

    @Test
    public void testGetCanonicalNormalMask() {
        IPv4AddressWithMask ip = IPv4AddressWithMask.of((String)"1.2.3.0/24");
        OFOxmIpv4SrcMasked ipv4SrcMasked = this.oxms.ipv4SrcMasked((IPv4Address)ip.getValue(), (IPv4Address)ip.getMask());
        Assert.assertTrue((boolean)ipv4SrcMasked.isMasked());
        OFOxm canonical = ipv4SrcMasked.getCanonical();
        Assert.assertEquals((Object)ipv4SrcMasked, (Object)canonical);
    }
}

