/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.protocol;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFBundleAddMsg;
import org.projectfloodlight.openflow.protocol.OFFactories;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFFlowAdd;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.BundleId;

public class OFBundleAddTest {
    private final OFFactory factory = OFFactories.getFactory((OFVersion)OFVersion.OF_14);
    private OFFlowAdd flowAdd;

    @Before
    public void setup() {
        this.flowAdd = this.factory.buildFlowAdd().build();
    }

    @Test
    public void testBundleAddBuilder() {
        OFBundleAddMsg bundleAdd = this.createBundleAdd();
        Assert.assertThat((Object)bundleAdd.getXid(), (Matcher)CoreMatchers.equalTo((Object)this.flowAdd.getXid()));
    }

    private OFBundleAddMsg createBundleAdd() {
        return this.factory.buildBundleAddMsg().setBundleId(BundleId.of((int)1)).setData((OFMessage)this.flowAdd).build();
    }

    @Test
    public void testBundleAddBuilderWithParent() {
        OFBundleAddMsg bundleAdd = this.createBundleAdd();
        OFBundleAddMsg builtFromOtherMessage = bundleAdd.createBuilder().build();
        Assert.assertThat((Object)builtFromOtherMessage.getXid(), (Matcher)CoreMatchers.equalTo((Object)builtFromOtherMessage.getData().getXid()));
    }

    @Test
    public void testBundleAddBuilderWithParentOverwrite() {
        OFFlowAdd flowAdd2 = this.factory.buildFlowAdd().setXid(1234L).build();
        OFBundleAddMsg bundleAdd = this.createBundleAdd();
        OFBundleAddMsg builtFromOtherMessage = bundleAdd.createBuilder().setData((OFMessage)flowAdd2).build();
        Assert.assertThat((Object)builtFromOtherMessage.getXid(), (Matcher)CoreMatchers.equalTo((Object)flowAdd2.getXid()));
    }
}

