/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.types.IPAddress;
import org.projectfloodlight.openflow.types.IPAddressWithMask;
import org.projectfloodlight.openflow.types.IPVersion;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.IPv4AddressWithMask;
import org.projectfloodlight.openflow.types.OFValueType;

public class IPv4AddressTest {
    byte[][] testAddresses = new byte[][]{{1, 2, 3, 4}, {127, 0, 0, 1}, {-64, -88, 0, 100}, {-1, -1, -1, -1}};
    String[] testStrings = new String[]{"1.2.3.4", "127.0.0.1", "192.168.0.100", "255.255.255.255"};
    int[] testInts = new int[]{16909060, 2130706433, -1062731676, -1};
    String[] invalidIPs = new String[]{"", ".", "1.2..3.4", "1.2.3.4.", "257.11.225.1", "256.11.225.1", "-1.2.3.4", "1.2.3.4.5", "1.x.3.4", "1.2x.3.4"};
    String[] ipsWithMask = new String[]{"1.2.3.4/24", "192.168.130.140/255.255.192.0", "127.0.0.1/8", "8.8.8.8", "8.8.8.8/32", "0.0.0.0/0", "192.168.130.140/255.0.255.0", "1.2.3.4/0.127.0.255"};
    boolean[] hasMask = new boolean[]{true, true, true, false, false, true, true, true};
    byte[][][] ipsWithMaskValues = new byte[][][]{new byte[][]{{1, 2, 3, 4}, {-1, -1, -1, 0}}, new byte[][]{{-64, -88, -126, -116}, {-1, -1, -64, 0}}, new byte[][]{{127, 0, 0, 1}, {-1, 0, 0, 0}}, new byte[][]{{8, 8, 8, 8}, {-1, -1, -1, -1}}, new byte[][]{{8, 8, 8, 8}, {-1, -1, -1, -1}}, new byte[][]{{0, 0, 0, 0}, {0, 0, 0, 0}}, new byte[][]{{-64, -88, -126, -116}, {-1, 0, -1, 0}}, new byte[][]{{1, 2, 3, 4}, {0, 127, 0, -1}}};
    int[] ipsWithMaskLengths = new int[]{24, 18, 8, 32, 32, 0, -1, -1};
    String[] invalidIpsWithMask = new String[]{"asdf", "1.2.3.4/33", "1.2.3.4/34", "1.2.3.4/-1", "1.2.3.4/256.0.0.0", "1.256.3.4/255.255.0.0", "1.2.3.4/255.255.0.0.0"};

    @Test
    public void testLogicalOperatorsBroadcast() {
        Assert.assertTrue((boolean)IPv4Address.NO_MASK.not().equals((Object)IPv4Address.FULL_MASK));
        Assert.assertTrue((boolean)IPv4Address.NO_MASK.or(IPv4Address.FULL_MASK).equals((Object)IPv4Address.NO_MASK));
        Assert.assertTrue((boolean)IPv4Address.NO_MASK.and(IPv4Address.FULL_MASK).equals((Object)IPv4Address.FULL_MASK));
        Assert.assertTrue((boolean)IPv4Address.NO_MASK.isBroadcast());
        Assert.assertTrue((!IPv4Address.FULL_MASK.isBroadcast() ? 1 : 0) != 0);
    }

    @Test
    public void testMaskedSubnetBroadcast() {
        Assert.assertTrue((boolean)((IPv4Address)IPv4AddressWithMask.of((String)"10.10.10.1/24").getSubnetBroadcastAddress()).equals((Object)IPv4Address.of((String)"10.10.10.255")));
        Assert.assertTrue((boolean)IPv4AddressWithMask.of((String)"10.10.10.1/24").isSubnetBroadcastAddress((IPAddress)IPv4Address.of((String)"10.10.10.255")));
        Assert.assertTrue((!IPv4AddressWithMask.of((String)"10.10.10.1/24").isSubnetBroadcastAddress((IPAddress)IPv4Address.of((String)"10.10.10.254")) ? 1 : 0) != 0);
    }

    @Test
    public void testMaskedMatchesCidr() {
        String[] notContained;
        IPv4AddressWithMask slash28 = IPv4AddressWithMask.of((String)"10.0.42.16/28");
        for (String n : notContained = new String[]{"0.0.0.0", "11.0.42.16", "10.0.41.1", "10.0.42.0", "10.0.42.15", "10.0.42.32", "255.255.255.255"}) {
            Assert.assertThat((String)String.format("slash 28 %s should not contain address %s", slash28, n), (Object)slash28.matches((OFValueType)IPv4Address.of((String)n)), (Matcher)CoreMatchers.equalTo((Object)false));
        }
        for (int i = 16; i < 32; ++i) {
            IPv4Address c = IPv4Address.of((String)String.format("10.0.42.%d", i));
            Assert.assertThat((String)String.format("slash 28 %s should contain address %s", slash28, c), (Object)slash28.matches((OFValueType)c), (Matcher)CoreMatchers.equalTo((Object)true));
        }
    }

    @Test
    public void testMaskedMatchesArbitrary() {
        IPv4AddressWithMask slash28 = IPv4AddressWithMask.of((String)"1.2.1.4/255.255.5.255");
        String[] notContained = new String[]{"0.0.0.0", "1.2.3.5", "1.2.3.3", "1.2.0.4", "1.2.2.4", "1.2.4.4", "1.2.5.4", "1.2.6.4", "1.2.7.4", "1.2.8.4", "1.2.12.4", "1.2.13.4"};
        String[] contained = new String[]{"1.2.1.4", "1.2.3.4", "1.2.9.4", "1.2.11.4", "1.2.251.4"};
        for (String n : notContained) {
            Assert.assertThat((String)String.format("slash 28 %s should not contain address %s", slash28, n), (Object)slash28.matches((OFValueType)IPv4Address.of((String)n)), (Matcher)CoreMatchers.equalTo((Object)false));
        }
        for (String c : contained) {
            IPv4Address addr = IPv4Address.of((String)c);
            Assert.assertThat((String)String.format("slash 28 %s should contain address %s", slash28, addr), (Object)slash28.matches((OFValueType)addr), (Matcher)CoreMatchers.equalTo((Object)true));
        }
    }

    @Test
    public void testConstants() {
        byte[] zeros = new byte[]{0, 0, 0, 0};
        byte[] ones = new byte[]{-1, -1, -1, -1};
        Assert.assertTrue((boolean)IPv4Address.NONE.isCidrMask());
        Assert.assertEquals((long)0L, (long)IPv4Address.NONE.asCidrMaskLength());
        Assert.assertArrayEquals((byte[])zeros, (byte[])IPv4Address.NONE.getBytes());
        Assert.assertTrue((boolean)IPv4Address.NONE.isCidrMask());
        Assert.assertEquals((long)0L, (long)IPv4Address.NONE.asCidrMaskLength());
        Assert.assertArrayEquals((byte[])zeros, (byte[])IPv4Address.NONE.getBytes());
        Assert.assertTrue((boolean)IPv4Address.NO_MASK.isCidrMask());
        Assert.assertEquals((long)32L, (long)IPv4Address.NO_MASK.asCidrMaskLength());
        Assert.assertArrayEquals((byte[])ones, (byte[])IPv4Address.NO_MASK.getBytes());
        Assert.assertTrue((boolean)IPv4Address.NO_MASK.isCidrMask());
        Assert.assertEquals((long)32L, (long)IPv4Address.NO_MASK.asCidrMaskLength());
        Assert.assertArrayEquals((byte[])ones, (byte[])IPv4Address.NO_MASK.getBytes());
        Assert.assertTrue((boolean)IPv4Address.FULL_MASK.isCidrMask());
        Assert.assertEquals((long)0L, (long)IPv4Address.FULL_MASK.asCidrMaskLength());
        Assert.assertArrayEquals((byte[])zeros, (byte[])IPv4Address.FULL_MASK.getBytes());
        Assert.assertTrue((boolean)IPv4Address.FULL_MASK.isCidrMask());
        Assert.assertEquals((long)0L, (long)IPv4Address.FULL_MASK.asCidrMaskLength());
        Assert.assertArrayEquals((byte[])zeros, (byte[])IPv4Address.FULL_MASK.getBytes());
    }

    @Test
    public void testOfString() {
        for (int i = 0; i < this.testAddresses.length; ++i) {
            IPv4Address ip = IPv4Address.of((String)this.testStrings[i]);
            Assert.assertEquals((long)this.testInts[i], (long)ip.getInt());
            Assert.assertArrayEquals((byte[])this.testAddresses[i], (byte[])ip.getBytes());
            Assert.assertEquals((Object)this.testStrings[i], (Object)ip.toString());
        }
    }

    @Test
    public void testOfByteArray() {
        for (int i = 0; i < this.testAddresses.length; ++i) {
            IPv4Address ip = IPv4Address.of((byte[])this.testAddresses[i]);
            Assert.assertEquals((long)this.testInts[i], (long)ip.getInt());
            Assert.assertArrayEquals((byte[])this.testAddresses[i], (byte[])ip.getBytes());
            Assert.assertEquals((Object)this.testStrings[i], (Object)ip.toString());
        }
    }

    @Test
    public void testOf4Integers() {
        HashMap<IPv4Address, IPv4Address> map = new HashMap<IPv4Address, IPv4Address>();
        map.put(IPv4Address.of((int)0, (int)0, (int)0, (int)0), IPv4Address.of((int)0));
        map.put(IPv4Address.of((int)1, (int)2, (int)3, (int)4), IPv4Address.of((String)"1.2.3.4"));
        map.put(IPv4Address.of((int)6, (int)7, (int)8, (int)9), IPv4Address.of((String)"6.7.8.9"));
        map.put(IPv4Address.of((int)10, (int)1, (int)2, (int)3), IPv4Address.of((String)"10.1.2.3"));
        map.put(IPv4Address.of((int)10, (int)201, (int)202, (int)203), IPv4Address.of((String)"10.201.202.203"));
        map.put(IPv4Address.of((int)192, (int)168, (int)0, (int)101), IPv4Address.of((String)"192.168.0.101"));
        map.put(IPv4Address.of((int)211, (int)212, (int)213, (int)214), IPv4Address.of((String)"211.212.213.214"));
        map.put(IPv4Address.of((int)255, (int)255, (int)255, (int)255), IPv4Address.of((int)-1));
        for (Map.Entry entry : map.entrySet()) {
            Assert.assertThat(entry.getKey(), (Matcher)CoreMatchers.equalTo(entry.getValue()));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOf4IntegersExceptionNegative1() {
        IPv4Address.of((int)-3, (int)4, (int)5, (int)6);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOf4IntegersExceptionNegative2() {
        IPv4Address.of((int)3, (int)-4, (int)5, (int)6);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOf4IntegersExceptionNegative3() {
        IPv4Address.of((int)3, (int)4, (int)-5, (int)6);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOf4IntegersExceptionNegative4() {
        IPv4Address.of((int)3, (int)4, (int)5, (int)-6);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOf4IntegersExceptionNegative5() {
        IPv4Address.of((int)101, (int)102, (int)103, (int)-128);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOf4IntegersExceptionNegative6() {
        IPv4Address.of((int)101, (int)102, (int)103, (int)-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOf4IntegersExceptionNegative7() {
        IPv4Address.of((int)-1, (int)-1, (int)-1, (int)-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOf4IntegersExceptionTooBig1() {
        IPv4Address.of((int)1000, (int)2, (int)3, (int)4);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOf4IntegersExceptionTooBig2() {
        IPv4Address.of((int)1, (int)20000, (int)3, (int)4);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOf4IntegersExceptionTooBig3() {
        IPv4Address.of((int)1, (int)2, (int)300000, (int)4);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOf4IntegersExceptionTooBig4() {
        IPv4Address.of((int)1, (int)2, (int)3, (int)4000000);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOf4IntegersExceptionTooBig5() {
        IPv4Address.of((int)256, (int)256, (int)256, (int)256);
    }

    @Test
    public void testOfCidrMaskLength() {
        for (int i = 0; i <= 32; ++i) {
            Assert.assertEquals((long)IPv4Address.ofCidrMaskLength((int)i).asCidrMaskLength(), (long)i);
        }
        Assert.assertEquals((long)IPv4Address.ofCidrMaskLength((int)0).getInt(), (long)0L);
        Assert.assertEquals((long)IPv4Address.ofCidrMaskLength((int)1).getInt(), (long)Integer.MIN_VALUE);
        Assert.assertEquals((long)IPv4Address.ofCidrMaskLength((int)2).getInt(), (long)-1073741824L);
        Assert.assertEquals((long)IPv4Address.ofCidrMaskLength((int)3).getInt(), (long)-536870912L);
        Assert.assertEquals((long)IPv4Address.ofCidrMaskLength((int)4).getInt(), (long)-268435456L);
        Assert.assertEquals((long)IPv4Address.ofCidrMaskLength((int)5).getInt(), (long)-134217728L);
        Assert.assertEquals((long)IPv4Address.ofCidrMaskLength((int)6).getInt(), (long)-67108864L);
        Assert.assertEquals((long)IPv4Address.ofCidrMaskLength((int)7).getInt(), (long)-33554432L);
        Assert.assertEquals((long)IPv4Address.ofCidrMaskLength((int)8).getInt(), (long)-16777216L);
        Assert.assertEquals((long)IPv4Address.ofCidrMaskLength((int)9).getInt(), (long)-8388608L);
        Assert.assertEquals((long)IPv4Address.ofCidrMaskLength((int)10).getInt(), (long)-4194304L);
        Assert.assertEquals((long)IPv4Address.ofCidrMaskLength((int)11).getInt(), (long)-2097152L);
        Assert.assertEquals((long)IPv4Address.ofCidrMaskLength((int)12).getInt(), (long)-1048576L);
        Assert.assertEquals((long)IPv4Address.ofCidrMaskLength((int)13).getInt(), (long)-524288L);
        Assert.assertEquals((long)IPv4Address.ofCidrMaskLength((int)14).getInt(), (long)-262144L);
        Assert.assertEquals((long)IPv4Address.ofCidrMaskLength((int)15).getInt(), (long)-131072L);
        Assert.assertEquals((long)IPv4Address.ofCidrMaskLength((int)16).getInt(), (long)-65536L);
        Assert.assertEquals((long)IPv4Address.ofCidrMaskLength((int)17).getInt(), (long)-32768L);
        Assert.assertEquals((long)IPv4Address.ofCidrMaskLength((int)18).getInt(), (long)-16384L);
        Assert.assertEquals((long)IPv4Address.ofCidrMaskLength((int)19).getInt(), (long)-8192L);
        Assert.assertEquals((long)IPv4Address.ofCidrMaskLength((int)20).getInt(), (long)-4096L);
        Assert.assertEquals((long)IPv4Address.ofCidrMaskLength((int)21).getInt(), (long)-2048L);
        Assert.assertEquals((long)IPv4Address.ofCidrMaskLength((int)22).getInt(), (long)-1024L);
        Assert.assertEquals((long)IPv4Address.ofCidrMaskLength((int)23).getInt(), (long)-512L);
        Assert.assertEquals((long)IPv4Address.ofCidrMaskLength((int)24).getInt(), (long)-256L);
        Assert.assertEquals((long)IPv4Address.ofCidrMaskLength((int)25).getInt(), (long)-128L);
        Assert.assertEquals((long)IPv4Address.ofCidrMaskLength((int)26).getInt(), (long)-64L);
        Assert.assertEquals((long)IPv4Address.ofCidrMaskLength((int)27).getInt(), (long)-32L);
        Assert.assertEquals((long)IPv4Address.ofCidrMaskLength((int)28).getInt(), (long)-16L);
        Assert.assertEquals((long)IPv4Address.ofCidrMaskLength((int)29).getInt(), (long)-8L);
        Assert.assertEquals((long)IPv4Address.ofCidrMaskLength((int)30).getInt(), (long)-4L);
        Assert.assertEquals((long)IPv4Address.ofCidrMaskLength((int)31).getInt(), (long)-2L);
        Assert.assertEquals((long)IPv4Address.ofCidrMaskLength((int)32).getInt(), (long)-1L);
    }

    @Test
    public void testWithMask() throws Exception {
        IPv4Address original = IPv4Address.of((String)"192.168.1.101");
        IPv4Address expectedValue = IPv4Address.of((String)"192.168.1.0");
        IPv4Address expectedMask = IPv4Address.of((String)"255.255.255.0");
        IPv4AddressWithMask v = original.withMask(IPv4Address.of((byte[])new byte[]{-1, -1, -1, 0}));
        Assert.assertEquals((Object)v.getValue(), (Object)expectedValue);
        Assert.assertEquals((Object)v.getMask(), (Object)expectedMask);
        v = original.withMask(IPv4Address.of((int)-256));
        Assert.assertEquals((Object)v.getValue(), (Object)expectedValue);
        Assert.assertEquals((Object)v.getMask(), (Object)expectedMask);
        v = original.withMask(IPv4Address.of((String)"255.255.255.0"));
        Assert.assertEquals((Object)v.getValue(), (Object)expectedValue);
        Assert.assertEquals((Object)v.getMask(), (Object)expectedMask);
        Inet4Address i4a = (Inet4Address)InetAddress.getByName("255.255.255.0");
        v = original.withMask(IPv4Address.of((Inet4Address)i4a));
        Assert.assertEquals((Object)v.getValue(), (Object)expectedValue);
        Assert.assertEquals((Object)v.getMask(), (Object)expectedMask);
        v = original.withMaskOfLength(24);
        Assert.assertEquals((Object)v.getValue(), (Object)expectedValue);
        Assert.assertEquals((Object)v.getMask(), (Object)expectedMask);
    }

    @Test
    public void testReadFrom() throws OFParseError {
        for (int i = 0; i < this.testAddresses.length; ++i) {
            IPv4Address ip = IPv4Address.read4Bytes((ByteBuf)Unpooled.copiedBuffer((byte[])this.testAddresses[i]));
            Assert.assertEquals((long)this.testInts[i], (long)ip.getInt());
            Assert.assertArrayEquals((byte[])this.testAddresses[i], (byte[])ip.getBytes());
            Assert.assertEquals((Object)this.testStrings[i], (Object)ip.toString());
        }
    }

    @Test
    public void testInvalidIPs() throws OFParseError {
        for (String invalid : this.invalidIPs) {
            try {
                IPv4Address.of((String)invalid);
                Assert.fail((String)("Invalid IP " + invalid + " should have raised IllegalArgumentException"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testOfMasked() throws OFParseError {
        for (int i = 0; i < this.ipsWithMask.length; ++i) {
            IPv4AddressWithMask value = IPv4AddressWithMask.of((String)this.ipsWithMask[i]);
            if (!this.hasMask[i]) {
                IPv4Address ip = (IPv4Address)value.getValue();
                Assert.assertArrayEquals((byte[])this.ipsWithMaskValues[i][0], (byte[])ip.getBytes());
            }
            IPv4Address mask = (IPv4Address)value.getMask();
            if (this.ipsWithMaskLengths[i] == -1) {
                Assert.assertFalse((boolean)mask.isCidrMask());
                try {
                    mask.asCidrMaskLength();
                    Assert.fail((String)"Expected IllegalStateException not thrown");
                }
                catch (IllegalStateException illegalStateException) {}
            } else {
                Assert.assertTrue((boolean)mask.isCidrMask());
                Assert.assertEquals((long)this.ipsWithMaskLengths[i], (long)mask.asCidrMaskLength());
            }
            Assert.assertArrayEquals((byte[])this.ipsWithMaskValues[i][1], (byte[])mask.getBytes());
            byte[] ipBytes = new byte[4];
            System.arraycopy(this.ipsWithMaskValues[i][0], 0, ipBytes, 0, 4);
            Assert.assertEquals((long)ipBytes.length, (long)((IPv4Address)value.getValue()).getBytes().length);
            for (int j = 0; j < ipBytes.length; ++j) {
                int n = j;
                ipBytes[n] = (byte)(ipBytes[n] & this.ipsWithMaskValues[i][1][j]);
            }
            Assert.assertArrayEquals((byte[])ipBytes, (byte[])((IPv4Address)value.getValue()).getBytes());
            Assert.assertThat((String)String.format("Byte comparison for mask of %s (%s)", this.ipsWithMask[i], value), (Object)((IPv4Address)value.getMask()).getBytes(), (Matcher)CoreMatchers.equalTo((Object)this.ipsWithMaskValues[i][1]));
        }
    }

    @Test
    public void testOfMaskedInvalid() throws Exception {
        for (String invalid : this.invalidIpsWithMask) {
            try {
                IPv4Address.of((String)invalid);
                Assert.fail((String)("Invalid IP " + invalid + " should have raised IllegalArgumentException"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testSuperclass() throws Exception {
        IPAddress superIp;
        for (String ipString : this.testStrings) {
            superIp = IPAddress.of((String)ipString);
            Assert.assertEquals((Object)IPVersion.IPv4, (Object)superIp.getIpVersion());
            Assert.assertEquals((Object)IPv4Address.of((String)ipString), (Object)superIp);
        }
        for (String ipMaskedString : this.ipsWithMask) {
            superIp = IPAddressWithMask.of((String)ipMaskedString);
            Assert.assertEquals((Object)IPVersion.IPv4, (Object)superIp.getIpVersion());
            Assert.assertEquals((Object)IPv4AddressWithMask.of((String)ipMaskedString), (Object)superIp);
        }
    }

    @Test
    public void testCompareTo() {
        Assert.assertThat((Object)IPv4Address.of((String)"1.0.0.1").compareTo(IPv4Address.of((String)"1.0.0.2")), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
        Assert.assertThat((Object)IPv4Address.of((String)"1.0.0.3").compareTo(IPv4Address.of((String)"3.0.0.1")), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
        Assert.assertThat((Object)IPv4Address.of((String)"201.0.0.1").compareTo(IPv4Address.NONE), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void testOfExceptions() {
        byte[] b;
        try {
            String s = null;
            IPv4Address.of(s);
            Assert.fail((String)"Should have thrown NullPointerException");
        }
        catch (NullPointerException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        try {
            b = null;
            IPv4Address.of(b);
            Assert.fail((String)"Should have thrown NullPointerException");
        }
        catch (NullPointerException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        try {
            b = new byte[3];
            IPv4Address.of((byte[])b);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException b2) {
            // empty catch block
        }
        try {
            b = new byte[5];
            IPv4Address.of((byte[])b);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException b3) {
            // empty catch block
        }
        try {
            IPv4AddressWithMask.of(null);
            Assert.fail((String)"Should have thrown NullPointerException");
        }
        catch (NullPointerException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        try {
            IPv4AddressWithMask.of((IPv4Address)IPv4Address.of((String)"1.2.3.4"), null);
            Assert.fail((String)"Should have thrown NullPointerException");
        }
        catch (NullPointerException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        try {
            IPv4AddressWithMask.of(null, (IPv4Address)IPv4Address.of((String)"255.0.0.0"));
            Assert.fail((String)"Should have thrown NullPointerException");
        }
        catch (NullPointerException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        try {
            IPv4AddressWithMask.of((IPv4Address)IPv4Address.of((String)"10.10.10.0"), (IPv4Address)IPv4Address.of((String)"255.0.255.0")).getSubnetBroadcastAddress();
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        try {
            IPv4Address.ofCidrMaskLength((int)-1);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        try {
            IPv4Address.ofCidrMaskLength((int)33);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }
}

