/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFStatsReplyFlags;
import org.projectfloodlight.openflow.protocol.OFTableStatsReply;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFTableStatsReplyVer15;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U64;

public class OFTableStatsReplyVer15Test {
    OFFactory factory;
    static final byte[] TABLE_STATS_REPLY_SERIALIZED = new byte[]{6, 19, 0, 40, 18, 52, 86, 120, 0, 3, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 5};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFTableStatsReply.Builder builder = this.factory.buildTableStatsReply();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsReplyFlags.REPLY_MORE)).setEntries((List)ImmutableList.of((Object)this.factory.buildTableStatsEntry().setTableId(TableId.of((int)1)).setActiveCount(10L).setLookupCount(U64.parseHex((String)"7")).setMatchedCount(U64.parseHex((String)"5")).build())).build();
        OFTableStatsReply tableStatsReply = builder.build();
        ByteBuf bb = Unpooled.buffer();
        tableStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)TABLE_STATS_REPLY_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFTableStatsReply.Builder builder = this.factory.buildTableStatsReply();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsReplyFlags.REPLY_MORE)).setEntries((List)ImmutableList.of((Object)this.factory.buildTableStatsEntry().setTableId(TableId.of((int)1)).setActiveCount(10L).setLookupCount(U64.parseHex((String)"7")).setMatchedCount(U64.parseHex((String)"5")).build())).build();
        OFTableStatsReply tableStatsReplyBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])TABLE_STATS_REPLY_SERIALIZED);
        OFTableStatsReply tableStatsReplyRead = OFTableStatsReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)TABLE_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)tableStatsReplyBuilt, (Object)tableStatsReplyRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])TABLE_STATS_REPLY_SERIALIZED);
        OFTableStatsReply tableStatsReply = OFTableStatsReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)TABLE_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        tableStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)TABLE_STATS_REPLY_SERIALIZED));
    }
}

