/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFMeterStatsReply;
import org.projectfloodlight.openflow.protocol.OFStatsReplyFlags;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFMeterStatsReplyVer15;
import org.projectfloodlight.openflow.types.U64;

public class OFMeterStatsReplyVer15Test {
    OFFactory factory;
    static final byte[] METER_STATS_REPLY_SERIALIZED = new byte[]{6, 19, 0, 88, 18, 52, 86, 120, 0, 9, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 72, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 3, -78, -48, 94, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 13};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFMeterStatsReply.Builder builder = this.factory.buildMeterStatsReply();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsReplyFlags.REPLY_MORE)).setEntries((List)ImmutableList.of((Object)this.factory.buildMeterStats().setMeterId(1L).setRefCount(1L).setPacketInCount(U64.of((long)10L)).setByteInCount(U64.of((long)10L)).setDurationSec(3L).setDurationNsec(3000000000L).setBandStats((List)ImmutableList.of((Object)this.factory.buildMeterBandStats().setPacketBandCount(U64.of((long)10L)).setByteBandCount(U64.of((long)11L)).build(), (Object)this.factory.buildMeterBandStats().setPacketBandCount(U64.of((long)12L)).setByteBandCount(U64.of((long)13L)).build())).build())).build();
        OFMeterStatsReply meterStatsReply = builder.build();
        ByteBuf bb = Unpooled.buffer();
        meterStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)METER_STATS_REPLY_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFMeterStatsReply.Builder builder = this.factory.buildMeterStatsReply();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsReplyFlags.REPLY_MORE)).setEntries((List)ImmutableList.of((Object)this.factory.buildMeterStats().setMeterId(1L).setRefCount(1L).setPacketInCount(U64.of((long)10L)).setByteInCount(U64.of((long)10L)).setDurationSec(3L).setDurationNsec(3000000000L).setBandStats((List)ImmutableList.of((Object)this.factory.buildMeterBandStats().setPacketBandCount(U64.of((long)10L)).setByteBandCount(U64.of((long)11L)).build(), (Object)this.factory.buildMeterBandStats().setPacketBandCount(U64.of((long)12L)).setByteBandCount(U64.of((long)13L)).build())).build())).build();
        OFMeterStatsReply meterStatsReplyBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])METER_STATS_REPLY_SERIALIZED);
        OFMeterStatsReply meterStatsReplyRead = OFMeterStatsReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)METER_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)meterStatsReplyBuilt, (Object)meterStatsReplyRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])METER_STATS_REPLY_SERIALIZED);
        OFMeterStatsReply meterStatsReply = OFMeterStatsReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)METER_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        meterStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)METER_STATS_REPLY_SERIALIZED));
    }
}

