/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFMeterConfigStatsRequest;
import org.projectfloodlight.openflow.protocol.OFStatsRequestFlags;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFMeterConfigStatsRequestVer15;

public class OFMeterConfigStatsRequestVer15Test {
    OFFactory factory;
    static final byte[] METER_CONFIG_STATS_REQUEST_SERIALIZED = new byte[]{6, 18, 0, 24, 18, 52, 86, 120, 0, 10, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFMeterConfigStatsRequest.Builder builder = this.factory.buildMeterConfigStatsRequest();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsRequestFlags.REQ_MORE)).setMeterId(1L).build();
        OFMeterConfigStatsRequest meterConfigStatsRequest = builder.build();
        ByteBuf bb = Unpooled.buffer();
        meterConfigStatsRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)METER_CONFIG_STATS_REQUEST_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFMeterConfigStatsRequest.Builder builder = this.factory.buildMeterConfigStatsRequest();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsRequestFlags.REQ_MORE)).setMeterId(1L).build();
        OFMeterConfigStatsRequest meterConfigStatsRequestBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])METER_CONFIG_STATS_REQUEST_SERIALIZED);
        OFMeterConfigStatsRequest meterConfigStatsRequestRead = OFMeterConfigStatsRequestVer15.READER.readFrom(input);
        Assert.assertEquals((long)METER_CONFIG_STATS_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)meterConfigStatsRequestBuilt, (Object)meterConfigStatsRequestRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])METER_CONFIG_STATS_REQUEST_SERIALIZED);
        OFMeterConfigStatsRequest meterConfigStatsRequest = OFMeterConfigStatsRequestVer15.READER.readFrom(input);
        Assert.assertEquals((long)METER_CONFIG_STATS_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        meterConfigStatsRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)METER_CONFIG_STATS_REQUEST_SERIALIZED));
    }
}

