/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionWriteMetadata;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructions;
import org.projectfloodlight.openflow.protocol.ver15.OFInstructionWriteMetadataVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFInstructionsVer15;
import org.projectfloodlight.openflow.types.U64;

public class OFInstructionWriteMetadataVer15Test {
    OFInstructions factory;
    static final byte[] INSTRUCTION_WRITE_METADATA_SERIALIZED = new byte[]{0, 2, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, -68, 0, 0, 0, 0, 0, 0, 10, -68};

    @Before
    public void setup() {
        this.factory = OFInstructionsVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFInstructionWriteMetadata.Builder builder = this.factory.buildWriteMetadata();
        builder.setMetadata(U64.parseHex((String)"abc")).setMetadataMask(U64.parseHex((String)"abc"));
        OFInstructionWriteMetadata instructionWriteMetadata = builder.build();
        ByteBuf bb = Unpooled.buffer();
        instructionWriteMetadata.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)INSTRUCTION_WRITE_METADATA_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFInstructionWriteMetadata.Builder builder = this.factory.buildWriteMetadata();
        builder.setMetadata(U64.parseHex((String)"abc")).setMetadataMask(U64.parseHex((String)"abc"));
        OFInstructionWriteMetadata instructionWriteMetadataBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])INSTRUCTION_WRITE_METADATA_SERIALIZED);
        OFInstructionWriteMetadata instructionWriteMetadataRead = OFInstructionWriteMetadataVer15.READER.readFrom(input);
        Assert.assertEquals((long)INSTRUCTION_WRITE_METADATA_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)instructionWriteMetadataBuilt, (Object)instructionWriteMetadataRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])INSTRUCTION_WRITE_METADATA_SERIALIZED);
        OFInstructionWriteMetadata instructionWriteMetadata = OFInstructionWriteMetadataVer15.READER.readFrom(input);
        Assert.assertEquals((long)INSTRUCTION_WRITE_METADATA_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        instructionWriteMetadata.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)INSTRUCTION_WRITE_METADATA_SERIALIZED));
    }
}

