/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionGotoTable;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructions;
import org.projectfloodlight.openflow.protocol.ver15.OFInstructionGotoTableVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFInstructionsVer15;
import org.projectfloodlight.openflow.types.TableId;

public class OFInstructionGotoTableVer15Test {
    OFInstructions factory;
    static final byte[] INSTRUCTION_GOTO_TABLE_SERIALIZED = new byte[]{0, 1, 0, 8, 5, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFInstructionsVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFInstructionGotoTable.Builder builder = this.factory.buildGotoTable();
        builder.setTableId(TableId.of((int)5)).build();
        OFInstructionGotoTable instructionGotoTable = builder.build();
        ByteBuf bb = Unpooled.buffer();
        instructionGotoTable.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)INSTRUCTION_GOTO_TABLE_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFInstructionGotoTable.Builder builder = this.factory.buildGotoTable();
        builder.setTableId(TableId.of((int)5)).build();
        OFInstructionGotoTable instructionGotoTableBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])INSTRUCTION_GOTO_TABLE_SERIALIZED);
        OFInstructionGotoTable instructionGotoTableRead = OFInstructionGotoTableVer15.READER.readFrom(input);
        Assert.assertEquals((long)INSTRUCTION_GOTO_TABLE_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)instructionGotoTableBuilt, (Object)instructionGotoTableRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])INSTRUCTION_GOTO_TABLE_SERIALIZED);
        OFInstructionGotoTable instructionGotoTable = OFInstructionGotoTableVer15.READER.readFrom(input);
        Assert.assertEquals((long)INSTRUCTION_GOTO_TABLE_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        instructionGotoTable.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)INSTRUCTION_GOTO_TABLE_SERIALIZED));
    }
}

