/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFGroupStatsRequest;
import org.projectfloodlight.openflow.protocol.OFStatsRequestFlags;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFGroupStatsRequestVer15;
import org.projectfloodlight.openflow.types.OFGroup;

public class OFGroupStatsRequestVer15Test {
    OFFactory factory;
    static final byte[] GROUP_STATS_REQUEST_SERIALIZED = new byte[]{6, 18, 0, 24, 18, 52, 86, 120, 0, 6, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFGroupStatsRequest.Builder builder = this.factory.buildGroupStatsRequest();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsRequestFlags.REQ_MORE)).setGroup(OFGroup.of((int)1)).build();
        OFGroupStatsRequest groupStatsRequest = builder.build();
        ByteBuf bb = Unpooled.buffer();
        groupStatsRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)GROUP_STATS_REQUEST_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFGroupStatsRequest.Builder builder = this.factory.buildGroupStatsRequest();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsRequestFlags.REQ_MORE)).setGroup(OFGroup.of((int)1)).build();
        OFGroupStatsRequest groupStatsRequestBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])GROUP_STATS_REQUEST_SERIALIZED);
        OFGroupStatsRequest groupStatsRequestRead = OFGroupStatsRequestVer15.READER.readFrom(input);
        Assert.assertEquals((long)GROUP_STATS_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)groupStatsRequestBuilt, (Object)groupStatsRequestRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])GROUP_STATS_REQUEST_SERIALIZED);
        OFGroupStatsRequest groupStatsRequest = OFGroupStatsRequestVer15.READER.readFrom(input);
        Assert.assertEquals((long)GROUP_STATS_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        groupStatsRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)GROUP_STATS_REQUEST_SERIALIZED));
    }
}

