/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFGroupAdd;
import org.projectfloodlight.openflow.protocol.OFGroupBucket;
import org.projectfloodlight.openflow.protocol.OFGroupType;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFGroupAddVer15;
import org.projectfloodlight.openflow.types.OFGroup;
import org.projectfloodlight.openflow.types.OFPort;

public class OFGroupAddVer15Test {
    OFFactory factory;
    static final byte[] GROUP_ADD_SERIALIZED = new byte[]{6, 15, 0, 64, 18, 52, 86, 120, 0, 0, 1, 0, 0, 0, 0, 1, 0, 40, 0, 0, -1, -1, -1, 0, 0, 40, 0, 24, -1, -1, -1, -3, 0, 0, 0, 16, 0, 0, 0, 1, 0, 3, 0, 0, 0, 0, 0, 0, 0, 22, 0, 8, 0, 0, 0, 1, 0, 0, 0, 8, 0, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFGroupAdd.Builder builder = this.factory.buildGroupAdd();
        builder.setXid(305419896L).setGroupType(OFGroupType.SELECT).setGroup(OFGroup.of((int)1)).setCommandBucketId(OFGroupBucket.BUCKET_MAX).setBuckets((List)ImmutableList.of((Object)this.factory.buildBucket().setBucketId(OFGroupBucket.BUCKET_FIRST).setActions((List)ImmutableList.of((Object)this.factory.actions().output(OFPort.of((int)1), 3), (Object)this.factory.actions().group(OFGroup.of((int)1)))).setProperties((List)ImmutableList.of((Object)this.factory.buildGroupBucketPropWeight().setWeight(0).build())).build()));
        OFGroupAdd groupAdd = builder.build();
        ByteBuf bb = Unpooled.buffer();
        groupAdd.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)GROUP_ADD_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFGroupAdd.Builder builder = this.factory.buildGroupAdd();
        builder.setXid(305419896L).setGroupType(OFGroupType.SELECT).setGroup(OFGroup.of((int)1)).setCommandBucketId(OFGroupBucket.BUCKET_MAX).setBuckets((List)ImmutableList.of((Object)this.factory.buildBucket().setBucketId(OFGroupBucket.BUCKET_FIRST).setActions((List)ImmutableList.of((Object)this.factory.actions().output(OFPort.of((int)1), 3), (Object)this.factory.actions().group(OFGroup.of((int)1)))).setProperties((List)ImmutableList.of((Object)this.factory.buildGroupBucketPropWeight().setWeight(0).build())).build()));
        OFGroupAdd groupAddBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])GROUP_ADD_SERIALIZED);
        OFGroupAdd groupAddRead = OFGroupAddVer15.READER.readFrom(input);
        Assert.assertEquals((long)GROUP_ADD_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)groupAddBuilt, (Object)groupAddRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])GROUP_ADD_SERIALIZED);
        OFGroupAdd groupAdd = OFGroupAddVer15.READER.readFrom(input);
        Assert.assertEquals((long)GROUP_ADD_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        groupAdd.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)GROUP_ADD_SERIALIZED));
    }
}

