/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFFlowRemoved;
import org.projectfloodlight.openflow.protocol.OFFlowRemovedReason;
import org.projectfloodlight.openflow.protocol.OFOxsList;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxs.OFOxs;
import org.projectfloodlight.openflow.protocol.stat.Stat;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFlowRemovedVer15;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.OFValueType;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U64;

public class OFFlowRemovedVer15Test {
    OFFactory factory;
    static final byte[] FLOW_REMOVED_SERIALIZED = new byte[]{6, 11, 0, 72, 18, 52, 86, 120, 20, 2, 66, 104, 0, 5, 0, 30, -2, -36, -70, -104, 118, 84, 50, 16, 0, 1, 0, 16, -128, 0, 1, 8, 0, 0, 0, 4, 0, 0, 0, 5, 0, 0, 0, 28, -128, 2, 0, 8, 0, 0, 0, 0, 0, 0, 0, 4, -128, 2, 2, 8, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFFlowRemoved.Builder builder = this.factory.buildFlowRemoved();
        builder.setXid(305419896L).setTableId(TableId.of((int)20)).setReason(OFFlowRemovedReason.DELETE).setPriority(17000).setIdleTimeout(5).setHardTimeout(30).setCookie(U64.parseHex((String)"FEDCBA9876543210")).setMatch(this.factory.buildMatch().setMasked(MatchField.IN_PORT, (OFValueType)OFPort.of((int)4), (OFValueType)OFPort.of((int)5)).build()).setStats((Stat)this.factory.buildStatV6().setOxsFields(OFOxsList.of((OFOxs[])new OFOxs[]{this.factory.oxss().buildDuration().setValue(U64.of((long)4L)).build(), this.factory.oxss().buildIdleTime().setValue(U64.of((long)6L)).build()})).build()).build();
        OFFlowRemoved flowRemoved = builder.build();
        ByteBuf bb = Unpooled.buffer();
        flowRemoved.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)FLOW_REMOVED_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFFlowRemoved.Builder builder = this.factory.buildFlowRemoved();
        builder.setXid(305419896L).setTableId(TableId.of((int)20)).setReason(OFFlowRemovedReason.DELETE).setPriority(17000).setIdleTimeout(5).setHardTimeout(30).setCookie(U64.parseHex((String)"FEDCBA9876543210")).setMatch(this.factory.buildMatch().setMasked(MatchField.IN_PORT, (OFValueType)OFPort.of((int)4), (OFValueType)OFPort.of((int)5)).build()).setStats((Stat)this.factory.buildStatV6().setOxsFields(OFOxsList.of((OFOxs[])new OFOxs[]{this.factory.oxss().buildDuration().setValue(U64.of((long)4L)).build(), this.factory.oxss().buildIdleTime().setValue(U64.of((long)6L)).build()})).build()).build();
        OFFlowRemoved flowRemovedBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])FLOW_REMOVED_SERIALIZED);
        OFFlowRemoved flowRemovedRead = OFFlowRemovedVer15.READER.readFrom(input);
        Assert.assertEquals((long)FLOW_REMOVED_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)flowRemovedBuilt, (Object)flowRemovedRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])FLOW_REMOVED_SERIALIZED);
        OFFlowRemoved flowRemoved = OFFlowRemovedVer15.READER.readFrom(input);
        Assert.assertEquals((long)FLOW_REMOVED_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        flowRemoved.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)FLOW_REMOVED_SERIALIZED));
    }
}

