/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFFlowMonitorCommand;
import org.projectfloodlight.openflow.protocol.OFFlowMonitorFlags;
import org.projectfloodlight.openflow.protocol.OFFlowMonitorRequest;
import org.projectfloodlight.openflow.protocol.OFStatsRequestFlags;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFlowMonitorRequestVer15;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.OFValueType;
import org.projectfloodlight.openflow.types.TableId;

public class OFFlowMonitorRequestVer15Test {
    OFFactory factory;
    static final byte[] FLOW_MONITOR_REQUEST_SERIALIZED = new byte[]{6, 18, 0, 48, 18, 52, 86, 120, 0, 16, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 1, 0, 0, 1, 0, 16, -128, 0, 1, 8, 0, 0, 0, 4, 0, 0, 0, 5};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFFlowMonitorRequest.Builder builder = this.factory.buildFlowMonitorRequest();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsRequestFlags.REQ_MORE)).setEntries((List)ImmutableList.of((Object)this.factory.buildFlowMonitorEntry().setMonitorId(1L).setOutPort(1L).setOutGroup(1L).setFlags((Set)ImmutableSet.of((Object)OFFlowMonitorFlags.INITIAL)).setTableId(TableId.of((int)1)).setCommand(OFFlowMonitorCommand.ADD).setMatch(this.factory.buildMatch().setMasked(MatchField.IN_PORT, (OFValueType)OFPort.of((int)4), (OFValueType)OFPort.of((int)5)).build()).build())).build();
        OFFlowMonitorRequest flowMonitorRequest = builder.build();
        ByteBuf bb = Unpooled.buffer();
        flowMonitorRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)FLOW_MONITOR_REQUEST_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFFlowMonitorRequest.Builder builder = this.factory.buildFlowMonitorRequest();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsRequestFlags.REQ_MORE)).setEntries((List)ImmutableList.of((Object)this.factory.buildFlowMonitorEntry().setMonitorId(1L).setOutPort(1L).setOutGroup(1L).setFlags((Set)ImmutableSet.of((Object)OFFlowMonitorFlags.INITIAL)).setTableId(TableId.of((int)1)).setCommand(OFFlowMonitorCommand.ADD).setMatch(this.factory.buildMatch().setMasked(MatchField.IN_PORT, (OFValueType)OFPort.of((int)4), (OFValueType)OFPort.of((int)5)).build()).build())).build();
        OFFlowMonitorRequest flowMonitorRequestBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])FLOW_MONITOR_REQUEST_SERIALIZED);
        OFFlowMonitorRequest flowMonitorRequestRead = OFFlowMonitorRequestVer15.READER.readFrom(input);
        Assert.assertEquals((long)FLOW_MONITOR_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)flowMonitorRequestBuilt, (Object)flowMonitorRequestRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])FLOW_MONITOR_REQUEST_SERIALIZED);
        OFFlowMonitorRequest flowMonitorRequest = OFFlowMonitorRequestVer15.READER.readFrom(input);
        Assert.assertEquals((long)FLOW_MONITOR_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        flowMonitorRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)FLOW_MONITOR_REQUEST_SERIALIZED));
    }
}

