/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFBundleCtrlMsg;
import org.projectfloodlight.openflow.protocol.OFBundleCtrlType;
import org.projectfloodlight.openflow.protocol.OFBundleFlags;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.ver15.OFBundleCtrlMsgVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.types.BundleId;
import org.projectfloodlight.openflow.types.U64;

public class OFBundleCtrlMsgVer15Test {
    OFFactory factory;
    static final byte[] BUNDLE_CTRL_MSG_SERIALIZED = new byte[]{6, 33, 0, 40, 18, 52, 86, 120, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 59, -102, -54, 0, 0, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFBundleCtrlMsg.Builder builder = this.factory.buildBundleCtrlMsg();
        builder.setXid(305419896L).setBundleId(BundleId.of((int)1)).setBundleCtrlType(OFBundleCtrlType.OPEN_REQUEST).setFlags((Set)ImmutableSet.of((Object)OFBundleFlags.ATOMIC)).setProperties((List)ImmutableList.of((Object)this.factory.buildBundlePropTime().setScheduledTime((List)ImmutableList.of((Object)this.factory.buildTime().setSeconds(U64.of((long)1L)).setNanoseconds(1000000000L).build())).build())).build();
        OFBundleCtrlMsg bundleCtrlMsg = builder.build();
        ByteBuf bb = Unpooled.buffer();
        bundleCtrlMsg.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BUNDLE_CTRL_MSG_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFBundleCtrlMsg.Builder builder = this.factory.buildBundleCtrlMsg();
        builder.setXid(305419896L).setBundleId(BundleId.of((int)1)).setBundleCtrlType(OFBundleCtrlType.OPEN_REQUEST).setFlags((Set)ImmutableSet.of((Object)OFBundleFlags.ATOMIC)).setProperties((List)ImmutableList.of((Object)this.factory.buildBundlePropTime().setScheduledTime((List)ImmutableList.of((Object)this.factory.buildTime().setSeconds(U64.of((long)1L)).setNanoseconds(1000000000L).build())).build())).build();
        OFBundleCtrlMsg bundleCtrlMsgBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])BUNDLE_CTRL_MSG_SERIALIZED);
        OFBundleCtrlMsg bundleCtrlMsgRead = OFBundleCtrlMsgVer15.READER.readFrom(input);
        Assert.assertEquals((long)BUNDLE_CTRL_MSG_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)bundleCtrlMsgBuilt, (Object)bundleCtrlMsgRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])BUNDLE_CTRL_MSG_SERIALIZED);
        OFBundleCtrlMsg bundleCtrlMsg = OFBundleCtrlMsgVer15.READER.readFrom(input);
        Assert.assertEquals((long)BUNDLE_CTRL_MSG_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        bundleCtrlMsg.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BUNDLE_CTRL_MSG_SERIALIZED));
    }
}

