/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFBarrierRequest;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.ver15.OFBarrierRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;

public class OFBarrierRequestVer15Test {
    OFFactory factory;
    static final byte[] BARRIER_REQUEST_SERIALIZED = new byte[]{6, 20, 0, 8, 18, 52, 86, 120};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFBarrierRequest.Builder builder = this.factory.buildBarrierRequest();
        builder.setXid(305419896L).build();
        OFBarrierRequest barrierRequest = builder.build();
        ByteBuf bb = Unpooled.buffer();
        barrierRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BARRIER_REQUEST_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFBarrierRequest.Builder builder = this.factory.buildBarrierRequest();
        builder.setXid(305419896L).build();
        OFBarrierRequest barrierRequestBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])BARRIER_REQUEST_SERIALIZED);
        OFBarrierRequest barrierRequestRead = OFBarrierRequestVer15.READER.readFrom(input);
        Assert.assertEquals((long)BARRIER_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)barrierRequestBuilt, (Object)barrierRequestRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])BARRIER_REQUEST_SERIALIZED);
        OFBarrierRequest barrierRequest = OFBarrierRequestVer15.READER.readFrom(input);
        Assert.assertEquals((long)BARRIER_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        barrierRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BARRIER_REQUEST_SERIALIZED));
    }
}

