/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFBadRequestCode;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.errormsg.OFBadRequestErrorMsg;
import org.projectfloodlight.openflow.protocol.errormsg.OFErrorMsgs;
import org.projectfloodlight.openflow.protocol.ver15.OFBadRequestErrorMsgVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFErrorMsgsVer15;
import org.projectfloodlight.openflow.types.OFErrorCauseData;

public class OFBadRequestErrorMsgVer15Test {
    OFErrorMsgs factory;
    static final byte[] BAD_REQUEST_ERROR_MSG_SERIALIZED = new byte[]{6, 1, 0, 15, 18, 52, 86, 120, 0, 1, 0, 8, 97, 98, 99};

    @Before
    public void setup() {
        this.factory = OFErrorMsgsVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFBadRequestErrorMsg.Builder builder = this.factory.buildBadRequestErrorMsg();
        builder.setXid(305419896L).setCode(OFBadRequestCode.BUFFER_UNKNOWN).setData(OFErrorCauseData.of((byte[])new byte[]{97, 98, 99}, (OFVersion)OFVersion.OF_15));
        OFBadRequestErrorMsg badRequestErrorMsg = builder.build();
        ByteBuf bb = Unpooled.buffer();
        badRequestErrorMsg.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BAD_REQUEST_ERROR_MSG_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFBadRequestErrorMsg.Builder builder = this.factory.buildBadRequestErrorMsg();
        builder.setXid(305419896L).setCode(OFBadRequestCode.BUFFER_UNKNOWN).setData(OFErrorCauseData.of((byte[])new byte[]{97, 98, 99}, (OFVersion)OFVersion.OF_15));
        OFBadRequestErrorMsg badRequestErrorMsgBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])BAD_REQUEST_ERROR_MSG_SERIALIZED);
        OFBadRequestErrorMsg badRequestErrorMsgRead = OFBadRequestErrorMsgVer15.READER.readFrom(input);
        Assert.assertEquals((long)BAD_REQUEST_ERROR_MSG_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)badRequestErrorMsgBuilt, (Object)badRequestErrorMsgRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])BAD_REQUEST_ERROR_MSG_SERIALIZED);
        OFBadRequestErrorMsg badRequestErrorMsg = OFBadRequestErrorMsgVer15.READER.readFrom(input);
        Assert.assertEquals((long)BAD_REQUEST_ERROR_MSG_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        badRequestErrorMsg.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BAD_REQUEST_ERROR_MSG_SERIALIZED));
    }
}

