/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFAsyncSet;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.ver15.OFAsyncSetVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;

public class OFAsyncSetVer15Test {
    OFFactory factory;
    static final byte[] ASYNC_SET_SERIALIZED = new byte[]{6, 28, 0, 16, 18, 52, 86, 120, 0, 1, 0, 8, 0, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFAsyncSet.Builder builder = this.factory.buildAsyncSet();
        builder.setXid(305419896L).setProperties((List)ImmutableList.of((Object)this.factory.buildAsyncConfigPropPacketInMaster().setMask(0L).build())).build();
        OFAsyncSet asyncSet = builder.build();
        ByteBuf bb = Unpooled.buffer();
        asyncSet.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)ASYNC_SET_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFAsyncSet.Builder builder = this.factory.buildAsyncSet();
        builder.setXid(305419896L).setProperties((List)ImmutableList.of((Object)this.factory.buildAsyncConfigPropPacketInMaster().setMask(0L).build())).build();
        OFAsyncSet asyncSetBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])ASYNC_SET_SERIALIZED);
        OFAsyncSet asyncSetRead = OFAsyncSetVer15.READER.readFrom(input);
        Assert.assertEquals((long)ASYNC_SET_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)asyncSetBuilt, (Object)asyncSetRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])ASYNC_SET_SERIALIZED);
        OFAsyncSet asyncSet = OFAsyncSetVer15.READER.readFrom(input);
        Assert.assertEquals((long)ASYNC_SET_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        asyncSet.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)ASYNC_SET_SERIALIZED));
    }
}

