/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFAggregateStatsReply;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFOxsList;
import org.projectfloodlight.openflow.protocol.OFStatsReplyFlags;
import org.projectfloodlight.openflow.protocol.oxs.OFOxs;
import org.projectfloodlight.openflow.protocol.stat.Stat;
import org.projectfloodlight.openflow.protocol.ver15.OFAggregateStatsReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.types.U64;

public class OFAggregateStatsReplyVer15Test {
    OFFactory factory;
    static final byte[] AGGREGATE_STATS_REPLY_SERIALIZED = new byte[]{6, 19, 0, 48, 18, 52, 86, 120, 0, 2, 0, 1, 0, 0, 0, 0, 0, 0, 0, 28, -128, 2, 0, 8, 0, 0, 0, 0, 0, 0, 0, 4, -128, 2, 2, 8, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFAggregateStatsReply.Builder builder = this.factory.buildAggregateStatsReply();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsReplyFlags.REPLY_MORE)).setStats((Stat)this.factory.buildStatV6().setOxsFields(OFOxsList.of((OFOxs[])new OFOxs[]{this.factory.oxss().buildDuration().setValue(U64.of((long)4L)).build(), this.factory.oxss().buildIdleTime().setValue(U64.of((long)6L)).build()})).build());
        OFAggregateStatsReply aggregateStatsReply = builder.build();
        ByteBuf bb = Unpooled.buffer();
        aggregateStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)AGGREGATE_STATS_REPLY_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFAggregateStatsReply.Builder builder = this.factory.buildAggregateStatsReply();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsReplyFlags.REPLY_MORE)).setStats((Stat)this.factory.buildStatV6().setOxsFields(OFOxsList.of((OFOxs[])new OFOxs[]{this.factory.oxss().buildDuration().setValue(U64.of((long)4L)).build(), this.factory.oxss().buildIdleTime().setValue(U64.of((long)6L)).build()})).build());
        OFAggregateStatsReply aggregateStatsReplyBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])AGGREGATE_STATS_REPLY_SERIALIZED);
        OFAggregateStatsReply aggregateStatsReplyRead = OFAggregateStatsReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)AGGREGATE_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)aggregateStatsReplyBuilt, (Object)aggregateStatsReplyRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])AGGREGATE_STATS_REPLY_SERIALIZED);
        OFAggregateStatsReply aggregateStatsReply = OFAggregateStatsReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)AGGREGATE_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        aggregateStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)AGGREGATE_STATS_REPLY_SERIALIZED));
    }
}

