/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFPacketOut;
import org.projectfloodlight.openflow.protocol.ver13.OFFactoryVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFPacketOutVer13;

public class OFPacketOutVer13Test {
    OFFactory factory;
    static final byte[] PACKET_OUT_SERIALIZED = new byte[]{4, 13, 0, 51, 18, 52, 86, 120, 0, 0, 0, 100, 0, 0, 0, 4, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 2, -1, -1, 0, 0, 0, 0, 0, 0, 0, 24, 0, 8, 0, 0, 0, 0, 97, 98, 99};

    @Before
    public void setup() {
        this.factory = OFFactoryVer13.INSTANCE;
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])PACKET_OUT_SERIALIZED);
        OFPacketOut packetOut = OFPacketOutVer13.READER.readFrom(input);
        Assert.assertEquals((long)PACKET_OUT_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        packetOut.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)PACKET_OUT_SERIALIZED));
    }
}

