/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnGlobalVrfAllowed;
import org.projectfloodlight.openflow.protocol.oxm.OFOxms;
import org.projectfloodlight.openflow.protocol.ver13.OFOxmBsnGlobalVrfAllowedVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFOxmsVer13;
import org.projectfloodlight.openflow.types.OFBooleanValue;

public class OFOxmBsnGlobalVrfAllowedVer13Test {
    OFOxms factory;
    static final byte[] OXM_BSN_GLOBAL_VRF_ALLOWED_SERIALIZED = new byte[]{0, 3, 6, 1, 1};

    @Before
    public void setup() {
        this.factory = OFOxmsVer13.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFOxmBsnGlobalVrfAllowed.Builder builder = this.factory.buildBsnGlobalVrfAllowed();
        builder.setValue(OFBooleanValue.TRUE);
        OFOxmBsnGlobalVrfAllowed oxmBsnGlobalVrfAllowed = builder.build();
        ByteBuf bb = Unpooled.buffer();
        oxmBsnGlobalVrfAllowed.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)OXM_BSN_GLOBAL_VRF_ALLOWED_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFOxmBsnGlobalVrfAllowed.Builder builder = this.factory.buildBsnGlobalVrfAllowed();
        builder.setValue(OFBooleanValue.TRUE);
        OFOxmBsnGlobalVrfAllowed oxmBsnGlobalVrfAllowedBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])OXM_BSN_GLOBAL_VRF_ALLOWED_SERIALIZED);
        OFOxmBsnGlobalVrfAllowed oxmBsnGlobalVrfAllowedRead = OFOxmBsnGlobalVrfAllowedVer13.READER.readFrom(input);
        Assert.assertEquals((long)OXM_BSN_GLOBAL_VRF_ALLOWED_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)oxmBsnGlobalVrfAllowedBuilt, (Object)oxmBsnGlobalVrfAllowedRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])OXM_BSN_GLOBAL_VRF_ALLOWED_SERIALIZED);
        OFOxmBsnGlobalVrfAllowed oxmBsnGlobalVrfAllowed = OFOxmBsnGlobalVrfAllowedVer13.READER.readFrom(input);
        Assert.assertEquals((long)OXM_BSN_GLOBAL_VRF_ALLOWED_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        oxmBsnGlobalVrfAllowed.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)OXM_BSN_GLOBAL_VRF_ALLOWED_SERIALIZED));
    }
}

