/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionGotoTable;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructions;
import org.projectfloodlight.openflow.protocol.ver13.OFInstructionGotoTableVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFInstructionsVer13;

public class OFInstructionGotoTableVer13Test {
    OFInstructions factory;
    static final byte[] INSTRUCTION_GOTO_TABLE_SERIALIZED = new byte[]{0, 1, 0, 8, 5, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFInstructionsVer13.INSTANCE;
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])INSTRUCTION_GOTO_TABLE_SERIALIZED);
        OFInstructionGotoTable instructionGotoTable = OFInstructionGotoTableVer13.READER.readFrom(input);
        Assert.assertEquals((long)INSTRUCTION_GOTO_TABLE_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        instructionGotoTable.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)INSTRUCTION_GOTO_TABLE_SERIALIZED));
    }
}

